/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.render;

import com.lothrazar.cyclic.data.Model3D;
import com.lothrazar.cyclic.render.FakeBlockRenderTypes;
import com.lothrazar.cyclic.render.RenderResizableCuboid;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class RenderUtils {
    public static final int FULL_LIGHT = 0xF000F0;

    public static void drawTiledSprite(PoseStack matrix, int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite, int textureWidth, int textureHeight, int zLevel, boolean blend) {
        if (desiredWidth == 0 || desiredHeight == 0 || textureWidth == 0 || textureHeight == 0) {
            return;
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        int xTileCount = desiredWidth / textureWidth;
        int xRemainder = desiredWidth - xTileCount * textureWidth;
        int yTileCount = desiredHeight / textureHeight;
        int yRemainder = desiredHeight - yTileCount * textureHeight;
        int yStart = yPosition + yOffset;
        float uMin = sprite.m_118409_();
        float uMax = sprite.m_118410_();
        float vMin = sprite.m_118411_();
        float vMax = sprite.m_118412_();
        float uDif = uMax - uMin;
        float vDif = vMax - vMin;
        if (blend) {
            RenderSystem.m_69478_();
        }
        BufferBuilder vertexBuffer = Tesselator.m_85913_().m_85915_();
        vertexBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix4f = matrix.m_85850_().m_85861_();
        block0: for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            float uLocalMax;
            float uLocalMin;
            int width;
            int n = width = xTile == xTileCount ? xRemainder : textureWidth;
            if (width == 0) break;
            int x = xPosition + xTile * textureWidth;
            int maskRight = textureWidth - width;
            int shiftedX = x + textureWidth - maskRight;
            float uLocalDif = uDif * (float)maskRight / (float)textureWidth;
            boolean right = true;
            if (right) {
                uLocalMin = uMin;
                uLocalMax = uMax - uLocalDif;
            } else {
                uLocalMin = uMin + uLocalDif;
                uLocalMax = uMax;
            }
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                float vLocalMax;
                float vLocalMin;
                int height;
                int n2 = height = yTile == yTileCount ? yRemainder : textureHeight;
                if (height == 0) continue block0;
                int y = yStart - (yTile + 1) * textureHeight;
                int maskTop = textureHeight - height;
                float vLocalDif = vDif * (float)maskTop / (float)textureHeight;
                boolean down = true;
                if (down) {
                    vLocalMin = vMin;
                    vLocalMax = vMax - vLocalDif;
                } else {
                    vLocalMin = vMin + vLocalDif;
                    vLocalMax = vMax;
                }
                vertexBuffer.m_85982_(matrix4f, (float)x, (float)(y + textureHeight), (float)zLevel).m_7421_(uLocalMin, vLocalMax).m_5752_();
                vertexBuffer.m_85982_(matrix4f, (float)shiftedX, (float)(y + textureHeight), (float)zLevel).m_7421_(uLocalMax, vLocalMax).m_5752_();
                vertexBuffer.m_85982_(matrix4f, (float)shiftedX, (float)(y + maskTop), (float)zLevel).m_7421_(uLocalMax, vLocalMin).m_5752_();
                vertexBuffer.m_85982_(matrix4f, (float)x, (float)(y + maskTop), (float)zLevel).m_7421_(uLocalMin, vLocalMin).m_5752_();
            }
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)vertexBuffer.m_231175_());
        if (blend) {
            RenderSystem.m_69461_();
        }
    }

    private static void renderCube(Matrix4f matrix, VertexConsumer builder, BlockPos pos, Color color, float alpha) {
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float startX = 0.0f;
        float startY = 0.0f;
        float startZ = -1.0f;
        float endX = 1.0f;
        float endY = 1.0f;
        float endZ = 0.0f;
        builder.m_85982_(matrix, startX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
    }

    private static void renderModelBrightnessColorQuads(PoseStack.Pose matrixEntry, VertexConsumer builder, float red, float green, float blue, float alpha, List<BakedQuad> quads, int combinedLights, int combinedOverlay) {
        for (BakedQuad bakedquad : quads) {
            float b;
            float g;
            float r;
            if (bakedquad.m_111304_()) {
                r = red * 1.0f;
                g = green * 1.0f;
                b = blue * 1.0f;
            } else {
                r = 1.0f;
                g = 1.0f;
                b = 1.0f;
            }
            boolean readExistingColor = false;
            builder.putBulkData(matrixEntry, bakedquad, r, g, b, alpha, combinedLights, combinedOverlay, readExistingColor);
        }
    }

    public static void renderObject(Model3D object, PoseStack matrix, VertexConsumer buffer, int argb, int light) {
        if (object != null) {
            RenderResizableCuboid.INSTANCE.renderCube(object, matrix, buffer, argb, light);
        }
    }

    public static int calculateGlowLight(int light, FluidStack fluid) {
        return fluid.isEmpty() ? light : RenderUtils.calculateGlowLight(light, fluid.getFluid().getFluidType().getLightLevel());
    }

    public static int calculateGlowLight(int light, int glow) {
        if (glow >= 15) {
            return 0xF000F0;
        }
        int blockLight = LightTexture.m_109883_((int)light);
        int skyLight = LightTexture.m_109894_((int)light);
        return LightTexture.m_109885_((int)Math.max(blockLight, glow), (int)Math.max(skyLight, glow));
    }

    public static int getColorARGB(FluidStack fluidStack, float fluidScale) {
        if (fluidStack.isEmpty()) {
            return -1;
        }
        return RenderUtils.getColorARGB(fluidStack);
    }

    private static int getColorARGB(FluidStack fluidStack) {
        IClientFluidTypeExtensions fluidAttributes = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        return fluidAttributes.getTintColor(fluidStack);
    }

    public static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static float getAlpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static void renderAsBlock(BlockPos centerPos, List<BlockPos> shape, PoseStack matrix, ItemStack stack, float alpha, float scale) {
        BlockState renderBlockState = Block.m_49814_((Item)stack.m_41720_()).m_49966_();
        RenderUtils.renderAsBlock(centerPos, shape, matrix, renderBlockState, alpha, scale);
    }

    public static void renderAsBlock(BlockPos centerPos, List<BlockPos> shape, PoseStack matrix, BlockState renderBlockState, float alpha, float scale) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        Minecraft mc = Minecraft.m_91087_();
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        VertexConsumer builder = buffer.m_6299_(FakeBlockRenderTypes.FAKE_BLOCK);
        BlockRenderDispatcher dispatcher = mc.m_91289_();
        matrix.m_85836_();
        matrix.m_85837_((double)(-centerPos.m_123341_()), (double)(-centerPos.m_123342_()), (double)(-centerPos.m_123343_()));
        for (BlockPos coordinate : shape) {
            float x = coordinate.m_123341_();
            float y = coordinate.m_123342_();
            float z = coordinate.m_123343_();
            matrix.m_85836_();
            matrix.m_85837_((double)x, (double)y, (double)z);
            matrix.m_85837_((double)-5.0E-4f, (double)-5.0E-4f, (double)-5.0E-4f);
            matrix.m_85841_(scale, scale, scale);
            BakedModel ibakedmodel = dispatcher.m_110910_(renderBlockState);
            BlockColors blockColors = Minecraft.m_91087_().m_91298_();
            int color = blockColors.m_92577_(renderBlockState, (BlockAndTintGetter)world, coordinate, 0);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            if (renderBlockState.m_60799_() == RenderShape.MODEL) {
                int combinedLights = 0xF00000;
                int combinedOverlay = 655360;
                for (Direction direction : Direction.values()) {
                    RenderUtils.renderModelBrightnessColorQuads(matrix.m_85850_(), builder, red, green, blue, alpha, ibakedmodel.getQuads(renderBlockState, direction, RandomSource.m_216335_((long)Mth.m_14057_((Vec3i)coordinate)), ibakedmodel.getModelData((BlockAndTintGetter)world, centerPos, renderBlockState, null), FakeBlockRenderTypes.FAKE_BLOCK), combinedLights, combinedOverlay);
                }
            }
            matrix.m_85849_();
        }
        matrix.m_85849_();
    }

    public static void renderOutline(BlockPos view, BlockPos pos, PoseStack matrix, float scale, Color color) {
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        coords.add(pos);
        RenderUtils.renderOutline(view, coords, matrix, scale, color);
    }

    public static void renderOutline(BlockPos view, List<BlockPos> coords, PoseStack matrix, float scale, Color color) {
        Minecraft mc = Minecraft.m_91087_();
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        matrix.m_85836_();
        matrix.m_85837_((double)(-view.m_123341_()), (double)(-view.m_123342_()), (double)(-view.m_123343_()));
        VertexConsumer builder = buffer.m_6299_(FakeBlockRenderTypes.SOLID_COLOUR);
        for (BlockPos e : coords) {
            if (e == null) continue;
            matrix.m_85836_();
            float ctr = (1.0f - scale) / 2.0f;
            matrix.m_85837_((double)((float)e.m_123341_() + ctr), (double)((float)e.m_123342_() + ctr), (double)((float)e.m_123343_() + ctr));
            matrix.m_85837_((double)-0.005f, (double)-0.005f, (double)-0.005f);
            matrix.m_85841_(scale, scale, scale);
            matrix.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
            Matrix4f positionMatrix = matrix.m_85850_().m_85861_();
            RenderUtils.renderCube(positionMatrix, builder, e, color, 0.125f);
            matrix.m_85849_();
        }
        matrix.m_85849_();
        buffer.m_109912_(FakeBlockRenderTypes.SOLID_COLOUR);
    }

    public static BlockHitResult getLookingAt(Player player, int range) {
        return (BlockHitResult)player.m_19907_((double)range, 0.0f, false);
    }

    public static void renderColourCubes(RenderLevelLastEvent evt, Map<BlockPos, Color> coords, float alpha) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        float scale = 1.01f;
        Minecraft mc = Minecraft.m_91087_();
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        Vec3 view = mc.f_91063_.m_109153_().m_90583_();
        PoseStack matrix = evt.getPoseStack();
        matrix.m_85836_();
        matrix.m_85837_(-view.m_7096_(), -view.m_7098_(), -view.m_7094_());
        VertexConsumer builder = buffer.m_6299_(FakeBlockRenderTypes.TRANSPARENT_COLOUR);
        for (BlockPos posCurr : coords.keySet()) {
            matrix.m_85836_();
            matrix.m_85837_((double)posCurr.m_123341_(), (double)posCurr.m_123342_(), (double)posCurr.m_123343_());
            matrix.m_85837_((double)-0.005f, (double)-0.005f, (double)-0.005f);
            matrix.m_85841_(scale, scale, scale);
            matrix.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
            RenderUtils.renderCube(matrix.m_85850_().m_85861_(), builder, posCurr, coords.get(posCurr), alpha);
            matrix.m_85849_();
        }
        matrix.m_85849_();
        RenderSystem.m_69465_();
        buffer.m_109912_(FakeBlockRenderTypes.TRANSPARENT_COLOUR);
    }

    public static void createBox(PoseStack poseStack, BlockPos pos) {
        poseStack.m_85836_();
        RenderUtils.createBox(Minecraft.m_91087_().m_91269_().m_110104_(), poseStack, pos);
        poseStack.m_85849_();
    }

    private static void createBox(MultiBufferSource.BufferSource bufferSource, PoseStack poseStack, BlockPos pos) {
        float x = pos.m_123341_();
        float y = pos.m_123342_();
        float z = pos.m_123343_();
        float offset = 1.0f;
        Minecraft mc = Minecraft.m_91087_();
        Vec3 cameraPosition = mc.f_91063_.m_109153_().m_90583_();
        RenderUtils.createBox(bufferSource, poseStack, x, y, z, offset, cameraPosition);
    }

    public static void createBox(PoseStack poseStack, BlockPos pos, Vec3 cameraPosition) {
        float x = pos.m_123341_();
        float y = pos.m_123342_();
        float z = pos.m_123343_();
        float offset = 1.0f;
        poseStack.m_85836_();
        RenderUtils.createBox(Minecraft.m_91087_().m_91269_().m_110104_(), poseStack, x, y, z, offset, cameraPosition);
        poseStack.m_85849_();
    }

    private static void createBox(MultiBufferSource.BufferSource bufferSource, PoseStack poseStack, float x, float y, float z, float offset, Vec3 cameraPosition) {
        long c = System.currentTimeMillis() / 15L % 360L;
        float[] color = RenderUtils.getHSBtoRGBF((float)c / 360.0f, 1.0f, 1.0f);
        Vec3 vec = new Vec3((double)x, (double)y, (double)z).m_82546_(cameraPosition);
        if (vec.m_82554_(Vec3.f_82478_) > 200.0) {
            vec = vec.m_82541_().m_82490_(200.0);
            x = (float)((double)x + vec.f_82479_);
            y = (float)((double)y + vec.f_82480_);
            z = (float)((double)z + vec.f_82481_);
        }
        RenderSystem.m_69465_();
        VertexConsumer vertexConsumer = bufferSource.m_6299_(FakeBlockRenderTypes.TOMB_LINES);
        poseStack.m_85837_(-cameraPosition.f_82479_, -cameraPosition.f_82480_, -cameraPosition.f_82481_);
        Matrix4f pose = poseStack.m_85850_().m_85861_();
        vertexConsumer.m_85982_(pose, x, y, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x + offset, y, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x, y, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x, y + offset, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x, y, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x, y, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x + offset, y + offset, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x, y + offset, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x + offset, y + offset, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x + offset, y, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x + offset, y + offset, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x + offset, y + offset, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x, y + offset, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x, y + offset, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x, y + offset, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x + offset, y + offset, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x + offset, y, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x + offset, y, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x + offset, y, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x + offset, y + offset, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x, y, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x + offset, y, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x, y, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x, y + offset, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        bufferSource.m_109912_(FakeBlockRenderTypes.TOMB_LINES);
        RenderSystem.m_69482_();
    }

    public static float[] getHSBtoRGBF(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
    }
}

