/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.builder;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public enum BuilderActionType {
    SINGLE,
    X3,
    X5,
    X7,
    X9,
    X91,
    X19;

    public static final String NBTBLOCKSTATE = "blockstate";
    private static final String NBT = "ActionType";
    private static final String NBTTIMEOUT = "timeout";

    public static int getTimeout(ItemStack wand) {
        return wand.m_41784_().m_128451_(NBTTIMEOUT);
    }

    public static void setTimeout(ItemStack wand) {
        wand.m_41784_().m_128405_(NBTTIMEOUT, 15);
    }

    public static void tickTimeout(ItemStack wand) {
        CompoundTag tags = wand.m_41784_();
        int t = tags.m_128451_(NBTTIMEOUT);
        if (t > 0) {
            wand.m_41784_().m_128405_(NBTTIMEOUT, t - 1);
        }
    }

    public static int get(ItemStack wand) {
        if (wand.m_41619_()) {
            return 0;
        }
        CompoundTag tags = wand.m_41784_();
        return tags.m_128451_(NBT);
    }

    public static String getName(ItemStack wand) {
        try {
            CompoundTag tags = wand.m_41784_();
            return "tool.action." + BuilderActionType.values()[tags.m_128451_(NBT)].toString().toLowerCase();
        }
        catch (Exception e) {
            return "tool.action." + SINGLE.toString().toLowerCase();
        }
    }

    public static void toggle(ItemStack wand) {
        CompoundTag tags = wand.m_41784_();
        int type = tags.m_128451_(NBT);
        if (++type >= BuilderActionType.values().length) {
            type = SINGLE.ordinal();
        }
        tags.m_128405_(NBT, type);
        wand.m_41751_(tags);
    }

    public static void setBlockState(ItemStack wand, BlockState target) {
        CompoundTag encoded = NbtUtils.m_129202_((BlockState)target);
        wand.m_41784_().m_128365_(NBTBLOCKSTATE, (Tag)encoded);
    }

    public static BlockState getBlockState(ItemStack wand) {
        if (!wand.m_41784_().m_128441_(NBTBLOCKSTATE)) {
            return null;
        }
        return NbtUtils.m_129241_((CompoundTag)wand.m_41784_().m_128469_(NBTBLOCKSTATE));
    }
}

