/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.shapebuilder;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.shapebuilder.BuildStructureType;
import com.lothrazar.cyclic.block.shapebuilder.ContainerStructure;
import com.lothrazar.cyclic.capabilities.block.CustomEnergyStorage;
import com.lothrazar.cyclic.data.BlockPosDim;
import com.lothrazar.cyclic.data.PreviewOutlineType;
import com.lothrazar.cyclic.data.RelativeShape;
import com.lothrazar.cyclic.item.datacard.LocationGpsCard;
import com.lothrazar.cyclic.item.datacard.ShapeCard;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.BlockUtil;
import com.lothrazar.cyclic.util.ShapeUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileStructure
extends TileBlockEntityCyclic
implements MenuProvider {
    public static ForgeConfigSpec.IntValue POWERCONF;
    static final int SLOT_BUILD = 0;
    protected static final int SLOT_SHAPE = 1;
    protected static final int SLOT_GPS = 2;
    public static final int MAX_HEIGHT = 100;
    static final int MAX = 64000;
    CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    ItemStackHandler inventory = new ItemStackHandler(3){

        public ItemStack getStackInSlot(int slot) {
            if (slot < 0 || slot >= this.stacks.size()) {
                return ItemStack.f_41583_;
            }
            return super.getStackInSlot(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return Block.m_49814_((Item)stack.m_41720_()) != null;
            }
            if (slot == 1) {
                return stack.m_41720_() instanceof ShapeCard;
            }
            return stack.m_41720_() instanceof LocationGpsCard;
        }
    };
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private BuildStructureType buildType = BuildStructureType.FACING;
    private int buildSize = 3;
    private int height = 2;
    private int shapeIndex = 0;
    private static final int spotsSkippablePerTrigger = 50;

    public TileStructure(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.STRUCTURE.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileStructure e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileStructure e) {
        e.tick();
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        int t = tag.m_128451_("buildType");
        this.buildType = BuildStructureType.values()[t];
        this.buildSize = tag.m_128451_("buildSize");
        this.height = tag.m_128451_("height");
        this.shapeIndex = tag.m_128451_("shapeIndex");
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("buildType", this.buildType.ordinal());
        tag.m_128405_("buildSize", this.buildSize);
        tag.m_128405_("height", this.height);
        tag.m_128405_("shapeIndex", this.shapeIndex);
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        super.m_183515_(tag);
    }

    public AABB getRenderBoundingBox() {
        return BlockEntity.INFINITE_EXTENT_AABB;
    }

    public Component m_5446_() {
        return ((Block)BlockRegistry.STRUCTURE.get()).m_49954_();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerStructure(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY && (Integer)POWERCONF.get() > 0) {
            return this.energyCap.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case BUILDTYPE: {
                if (value >= BuildStructureType.values().length) {
                    value = 0;
                }
                this.buildType = BuildStructureType.values()[value];
                break;
            }
            case SIZE: {
                this.buildSize = value;
                break;
            }
            case HEIGHT: {
                this.height = Math.min(value, 100);
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case RENDER: {
                this.render = value % PreviewOutlineType.values().length;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case TIMER: {
                return this.timer;
            }
            case BUILDTYPE: {
                return this.buildType.ordinal();
            }
            case SIZE: {
                return this.buildSize;
            }
            case HEIGHT: {
                return this.height;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
        }
        return 0;
    }

    public void tick() {
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            return;
        }
        List<BlockPos> shape = this.getShape();
        if (shape.size() == 0) {
            return;
        }
        if (this.shapeIndex < 0 || this.shapeIndex >= shape.size()) {
            this.shapeIndex = 0;
        }
        BlockPos nextPos = shape.get(this.shapeIndex);
        ItemStack stack = this.inventory.getStackInSlot(0);
        Block stuff = Block.m_49814_((Item)stack.m_41720_());
        if (stuff == null) {
            return;
        }
        int cost = (Integer)POWERCONF.get();
        for (int i = 0; i < 50 && (this.energy.getEnergyStored() >= cost || cost <= 0); ++i) {
            if (!this.f_58857_.m_151570_(nextPos) && this.f_58857_.m_46859_(nextPos)) {
                BlockState placeState = stuff.m_49966_();
                if (this.f_58857_.f_46443_ || !BlockUtil.placeStateSafe(this.f_58857_, null, nextPos, placeState)) break;
                this.incrementPosition(shape);
                stack.m_41774_(1);
                this.energy.extractEnergy(cost, false);
                break;
            }
            nextPos = shape.get(this.shapeIndex);
            this.incrementPosition(shape);
        }
    }

    private void incrementPosition(List<BlockPos> shape) {
        if (shape == null || shape.size() == 0) {
            return;
        }
        int c = this.shapeIndex + 1;
        if (c < 0 || c >= shape.size()) {
            c = 0;
        }
        this.shapeIndex = c;
    }

    private BlockPos getPosTarget() {
        BlockPosDim loc;
        if (2 < this.inventory.getSlots() && (loc = LocationGpsCard.getPosition(this.inventory.getStackInSlot(2))) != null && loc.getPos() != null) {
            return loc.getPos();
        }
        return this.m_58899_();
    }

    public BlockPos getTargetFacing() {
        return this.getPosTarget().m_5484_(this.getCurrentFacing(), this.buildSize + 1);
    }

    public List<BlockPos> getShape() {
        RelativeShape shape;
        ItemStack shapeCard;
        if (1 < this.inventory.getSlots() && (shapeCard = this.inventory.getStackInSlot(1)).m_41720_() instanceof ShapeCard && (shape = RelativeShape.read(shapeCard)) != null) {
            shape.setWorldCenter(this.f_58857_, this.getPosTarget());
            if (shape.getShape() != null && shape.getShape().size() > 0) {
                return shape.getShape();
            }
        }
        List<BlockPos> shape2 = new ArrayList<BlockPos>();
        switch (this.buildType) {
            case CIRCLE: {
                shape2 = ShapeUtil.circleHorizontal(this.getPosTarget(), this.getSize() * 2);
                shape2 = ShapeUtil.repeatShapeByHeight(shape2, this.getHeight() - 1);
                break;
            }
            case FACING: {
                shape2 = ShapeUtil.line(this.getPosTarget(), this.getCurrentFacing(), this.getSize());
                shape2 = ShapeUtil.repeatShapeByHeight(shape2, this.getHeight() - 1);
                break;
            }
            case SQUARE: {
                shape2 = ShapeUtil.squareHorizontalHollow(this.getPosTarget(), this.getSize());
                shape2 = ShapeUtil.repeatShapeByHeight(shape2, this.getHeight() - 1);
                break;
            }
            case SOLID: {
                shape2 = ShapeUtil.squareHorizontalFull(this.getTargetFacing(), this.getSize());
                shape2 = ShapeUtil.repeatShapeByHeight(shape2, this.getHeight() - 1);
                break;
            }
            case SPHERE: {
                shape2 = ShapeUtil.sphere(this.getPosTarget(), this.getSize());
                break;
            }
            case DOME: {
                shape2 = ShapeUtil.sphereDome(this.getPosTarget(), this.getSize());
                break;
            }
            case CUP: {
                shape2 = ShapeUtil.sphereCup(this.getPosTarget().m_6630_(this.getSize()), this.getSize());
                break;
            }
            case DIAGONAL: {
                shape2 = ShapeUtil.diagonal(this.getPosTarget(), this.getCurrentFacing(), this.getSize() * 2, true);
                break;
            }
            case PYRAMID: {
                shape2 = ShapeUtil.squarePyramid(this.getPosTarget(), this.getSize(), this.getHeight());
                break;
            }
            case TUNNEL: {
                shape2 = ShapeUtil.circleVertical(this.getPosTarget(), this.getSize(), this.getHeight(), this.getCurrentFacing());
            }
        }
        return shape2;
    }

    private int getHeight() {
        return this.height;
    }

    private int getSize() {
        return this.buildSize;
    }

    static enum Fields {
        TIMER,
        BUILDTYPE,
        SIZE,
        HEIGHT,
        REDSTONE,
        RENDER;

    }
}

