/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.hopperfluid;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.hopperfluid.BlockFluidHopper;
import com.lothrazar.cyclic.capabilities.block.FluidTankBase;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.FluidHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileFluidHopper
extends TileBlockEntityCyclic {
    private static final int FLOW = 1000;
    public static final int CAPACITY = 1000;
    public FluidTankBase tank = new FluidTankBase(this, 1000, p -> true);
    LazyOptional<FluidTankBase> fluidCap = LazyOptional.of(() -> this.tank);

    public TileFluidHopper(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.FLUIDHOPPER.get(), pos, state);
    }

    @Override
    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    public void invalidateCaps() {
        this.fluidCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileFluidHopper e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileFluidHopper e) {
        e.tick();
    }

    public void tick() {
        if (this.isPowered()) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.tryExtract();
        Direction exportToSide = (Direction)this.m_58900_().m_61143_((Property)BlockFluidHopper.FACING);
        if (exportToSide != null && exportToSide != Direction.UP) {
            this.moveFluids(exportToSide, this.f_58858_.m_121945_(exportToSide), 1000, (IFluidHandler)this.tank);
            FluidHelpers.insertSourceCauldron(this.f_58857_, this.f_58858_.m_121945_(exportToSide), (IFluidHandler)this.tank);
            this.updateComparatorOutputLevel();
            this.updateComparatorOutputLevelAt(this.f_58858_.m_121945_(exportToSide));
        }
    }

    private void tryExtract() {
        if (this.tank == null) {
            return;
        }
        BlockPos target = this.f_58858_.m_121945_(Direction.UP);
        IFluidHandler tankAbove = FluidHelpers.getTank(this.f_58857_, target, Direction.DOWN);
        boolean success = FluidHelpers.tryFillPositionFromTank(this.f_58857_, this.f_58858_, Direction.UP, tankAbove, 1000);
        if (success) {
            this.updateComparatorOutputLevelAt(target);
            this.updateComparatorOutputLevel();
            return;
        }
        if (this.tank.getSpace() >= 1000) {
            FluidHelpers.extractSourceWaterloggedCauldron(this.f_58857_, target, (IFluidHandler)this.tank);
            this.updateComparatorOutputLevel();
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.tank.readFromNBT(tag.m_128469_("fluid"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        CompoundTag fluid = new CompoundTag();
        this.tank.writeToNBT(fluid);
        tag.m_128365_("fluid", (Tag)fluid);
        super.m_183515_(tag);
    }

    public int getFill() {
        if (this.tank == null || this.tank.getFluidInTank(0).isEmpty()) {
            return 0;
        }
        return this.tank.getFluidInTank(0).getAmount();
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }
}

