/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.enderctrl;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.enderctrl.EnderShelfHelper;
import com.lothrazar.cyclic.block.enderctrl.TileEnderCtrl;
import com.lothrazar.cyclic.block.endershelf.EnderShelfItemHandler;
import com.lothrazar.cyclic.block.endershelf.TileEnderShelf;
import com.lothrazar.cyclic.util.EnchantUtil;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.ItemStackHandler;

public class EnderControllerItemHandler
extends ItemStackHandler {
    static final int SLOTS_PER_SHELF = 5;
    private final TileEnderCtrl controller;

    public EnderControllerItemHandler(TileEnderCtrl controller) {
        super(1);
        this.controller = controller;
    }

    public ItemStack insertItem(int slot, ItemStack remaining, boolean simulate) {
        if (remaining.m_41720_() != Items.f_42690_) {
            return remaining;
        }
        if (!(remaining = this.insertItemElsewhere(remaining, false, simulate)).m_41619_()) {
            remaining = this.insertItemElsewhere(remaining, true, simulate);
        }
        return remaining;
    }

    private ItemStack insertItemElsewhere(ItemStack stack, boolean insertWhenEmpty, boolean simulate) {
        if (this.controller.m_58904_() == null) {
            return stack;
        }
        for (BlockPos shelfPos : this.controller.getShelves()) {
            BlockEntity te = this.controller.m_58904_().m_7702_(shelfPos);
            if (te == null || !EnderShelfHelper.isShelf(te.m_58900_())) continue;
            TileEnderShelf shelf = (TileEnderShelf)te;
            try {
                ModCyclic.LOGGER.info(stack + " try to push into shelf at " + shelfPos);
                stack = this.insertItemActual(shelf, stack, insertWhenEmpty, simulate);
                ModCyclic.LOGGER.info(stack + "FROM result " + shelfPos);
            }
            catch (Exception e) {
                ModCyclic.LOGGER.error("Insert item shelf error", e);
            }
        }
        return stack;
    }

    private ItemStack insertItemActual(TileEnderShelf shelf, ItemStack stack, boolean insertWhenEmpty, boolean simulate) {
        ItemStack inserted;
        ArrayList<Integer> emptySlots = new ArrayList<Integer>();
        int slots = shelf.inventory.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack inserted2;
            ItemStack slotStack = shelf.inventory.getStackInSlot(i);
            ModCyclic.LOGGER.info("       " + i + "  tsSHELF " + slotStack);
            if (slotStack.m_41619_()) {
                emptySlots.add(i);
                continue;
            }
            if (slotStack.m_41613_() >= shelf.inventory.getStackLimit(i, stack) || !EnchantUtil.doBookEnchantmentsMatch(stack, slotStack) || !(inserted2 = shelf.inventory.insertItem(i, stack, simulate)).m_41619_()) continue;
            return inserted2;
        }
        if (emptySlots.size() > 0 && insertWhenEmpty && (inserted = shelf.inventory.insertItem((Integer)emptySlots.get(0), stack, simulate)).m_41619_()) {
            return inserted;
        }
        return stack;
    }

    public int getSlots() {
        return this.controller.getShelves().size() * 5;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.insertItem(slot, stack, false);
        this.onContentsChanged(slot);
    }

    public ItemStack getStackInSlot(int slot) {
        if (this.controller.getShelves().size() == 0 || this.controller.m_58904_() == null) {
            return ItemStack.f_41583_;
        }
        int shelf = slot / 5;
        int realSlot = slot % 5;
        EnderShelfItemHandler handler = this.getHandlerAt(shelf);
        if (handler != null) {
            return handler.getStackInSlot(realSlot);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.extractItemElsewhere(slot, amount, simulate);
    }

    private ItemStack extractItemElsewhere(int slot, int amount, boolean simulate) {
        if (this.controller.getShelves().size() == 0 || this.controller.m_58904_() == null) {
            return ItemStack.f_41583_;
        }
        int shelf = slot / 5;
        int realSlot = slot % 5;
        EnderShelfItemHandler handler = this.getHandlerAt(shelf);
        if (handler != null) {
            return handler.extractItem(realSlot, amount, simulate);
        }
        return ItemStack.f_41583_;
    }

    private EnderShelfItemHandler getHandlerAt(int shelf) {
        try {
            BlockPos extractPos = this.controller.getShelves().get(shelf);
            BlockEntity te = this.controller.m_58904_().m_7702_(extractPos);
            return EnderShelfHelper.getShelfHandler(te);
        }
        catch (Exception e) {
            return null;
        }
    }
}

