/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.breaker;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.breaker.ContainerBreaker;
import com.lothrazar.cyclic.data.DataTags;
import com.lothrazar.cyclic.item.datacard.BlockStateMatcher;
import com.lothrazar.cyclic.item.datacard.BlockstateCard;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileBreaker
extends TileBlockEntityCyclic
implements MenuProvider {
    static final int MAX = 64000;
    public static final int TIMER_FULL = 500;
    ItemStackHandler inventory = new ItemStackHandler(){

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.m_41720_() == ItemRegistry.STATECARD.get();
        }
    };
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);

    public TileBreaker(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.BREAKER.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileBreaker e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileBreaker e) {
        e.tick();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void tick() {
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        this.setLitProperty(true);
        if (this.f_58857_.f_46443_) {
            return;
        }
        BlockPos target = this.f_58858_.m_121945_(this.getCurrentFacing());
        if (this.isTargetValid(target)) {
            this.f_58857_.m_46961_(target, true);
        }
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    private boolean isTargetValid(BlockPos targetPos) {
        BlockState targetState = this.f_58857_.m_8055_(targetPos);
        if (targetState.m_60795_()) {
            return false;
        }
        if (targetState.m_60800_((BlockGetter)this.f_58857_, targetPos) < 0.0f) {
            return false;
        }
        if (targetState.m_204336_(DataTags.BREAKER_IGNORED)) {
            ModCyclic.LOGGER.info("breaker/ignored tag skips " + targetPos);
            return false;
        }
        if (targetState.m_60819_() != null && !targetState.m_60819_().m_76178_() && !targetState.m_61138_((Property)BlockStateProperties.f_61362_)) {
            return false;
        }
        return this.isValidFromDatacard(targetState);
    }

    private boolean isValidFromDatacard(BlockState targetState) {
        ItemStack filter = this.inventory.getStackInSlot(0);
        if (filter.m_41619_()) {
            return true;
        }
        for (BlockStateMatcher m : BlockstateCard.getSavedStates(filter)) {
            if (!m.doesMatch(targetState)) continue;
            return true;
        }
        return false;
    }

    public Component m_5446_() {
        return ((Block)BlockRegistry.BREAKER.get()).m_49954_();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerBreaker(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        super.m_183515_(tag);
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TIMER: {
                this.timer = value;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.timer;
            }
        }
        return 0;
    }

    public int getEnergyMax() {
        return 64000;
    }

    static enum Fields {
        REDSTONE,
        TIMER;

    }
}

