/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.server.ServerLifecycleHooks;

public class StatueSavedData
extends SavedData {
    public static final StatueSavedData blank = new StatueSavedData();
    private static final String DATA_NAME = "statues_world_data";
    private static final Map<ResourceKey<Level>, List<BlockPos>> despawnerMap = new HashMap<ResourceKey<Level>, List<BlockPos>>();

    public boolean isDespawnerNearby(ResourceKey<Level> dimension, BlockPos pos, int range) {
        if (despawnerMap.containsKey(dimension)) {
            List<BlockPos> posList = despawnerMap.get(dimension).stream().filter(storedPos -> storedPos.m_123333_((Vec3i)pos) <= range).toList();
            return !posList.isEmpty();
        }
        return false;
    }

    public void addPosition(ResourceKey<Level> dimension, BlockPos pos) {
        List posList = despawnerMap.getOrDefault(dimension, new ArrayList());
        posList.add(pos);
        despawnerMap.put(dimension, posList);
        this.m_77762_();
    }

    public void removePosition(ResourceKey<Level> dimension, BlockPos pos) {
        List posList = despawnerMap.getOrDefault(dimension, new ArrayList());
        posList.remove(pos);
        despawnerMap.put(dimension, posList);
        this.m_77762_();
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag despawnerList = new ListTag();
        despawnerMap.forEach((dimension, posList) -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Dimension", dimension.m_135782_().toString());
            ListTag posListTag = new ListTag();
            for (BlockPos pos : posList) {
                CompoundTag tag1 = new CompoundTag();
                tag1.m_128356_("Pos", pos.m_121878_());
                posListTag.add((Object)tag1);
            }
            tag.m_128365_("Positions", (Tag)posListTag);
            despawnerList.add((Object)tag);
        });
        compound.m_128365_("DespawnerMap", (Tag)despawnerList);
        return compound;
    }

    public static StatueSavedData load(CompoundTag tag) {
        if (tag.m_128441_("DespawnerMap")) {
            ListTag despawnerList = tag.m_128437_("DespawnerMap", 10);
            despawnerList.forEach(t -> {
                CompoundTag despawnTag = (CompoundTag)t;
                String dimensionLocation = despawnTag.m_128461_("Dimension");
                ArrayList posList = new ArrayList();
                ListTag posListTag = despawnTag.m_128437_("Positions", 10);
                posListTag.forEach(t2 -> {
                    CompoundTag tag1 = (CompoundTag)t2;
                    BlockPos pos = BlockPos.m_122022_((long)tag1.m_128454_("Pos"));
                    posList.add(pos);
                });
                ResourceKey<Level> dimension = StatueSavedData.getLevelKey(dimensionLocation);
                despawnerMap.put(dimension, posList);
            });
        }
        return new StatueSavedData();
    }

    private static ResourceKey<Level> getLevelKey(String location) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(location));
    }

    public static StatueSavedData get() {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            return (StatueSavedData)ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_).m_8895_().m_164861_(StatueSavedData::load, StatueSavedData::new, DATA_NAME);
        }
        return blank;
    }
}

