/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shynieke.statues.recipe.StatuesRecipes;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class LootRecipe
implements Recipe<Container> {
    protected final ResourceLocation id;
    protected final String group;
    protected final Ingredient ingredient;
    protected final ItemStack result;
    protected final ItemStack result2;
    protected final ItemStack result3;
    protected final float resultChance;
    protected final float result2Chance;
    protected final float result3Chance;

    public LootRecipe(ResourceLocation id, String group, Ingredient ingredient, ItemStack stack, float resultChance, ItemStack stack2, float result2Chance, ItemStack stack3, float result3Chance) {
        this.id = id;
        this.group = group;
        this.ingredient = ingredient;
        this.result = stack;
        this.resultChance = resultChance;
        this.result2 = stack2;
        this.result2Chance = result2Chance;
        this.result3 = stack3;
        this.result3Chance = result3Chance;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        nonnulllist.add((Object)this.ingredient);
        return nonnulllist;
    }

    public boolean m_5818_(Container container, Level level) {
        return ((Ingredient)this.m_7527_().get(0)).test(container.m_8020_(0));
    }

    public ItemStack m_5874_(Container container) {
        return this.m_8043_().m_41777_();
    }

    public boolean m_8004_(int x, int y) {
        return false;
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public float getChance1() {
        return this.resultChance;
    }

    public ItemStack getResultItem2() {
        return this.result2;
    }

    public float getChance2() {
        return this.result2Chance;
    }

    public ItemStack getResultItem3() {
        return this.result3;
    }

    public float getChance3() {
        return this.result3Chance;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)StatuesRecipes.LOOT_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)StatuesRecipes.LOOT_RECIPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<LootRecipe> {
        public LootRecipe fromJson(ResourceLocation recipeID, JsonObject jsonObject) {
            String s = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
            JsonArray jsonelement = GsonHelper.m_13885_((JsonObject)jsonObject, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)jsonObject, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)jsonObject, (String)"ingredient");
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonelement);
            ItemStack[] stacks = new ItemStack[3];
            float[] chances = new float[3];
            for (int i = 0; i < 3; ++i) {
                String resultName = "result" + (i + 1);
                if (jsonObject.has(resultName)) {
                    if (jsonObject.get(resultName).isJsonObject()) {
                        stacks[i] = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)resultName));
                    } else {
                        String s1 = GsonHelper.m_13906_((JsonObject)jsonObject, (String)resultName);
                        ResourceLocation resourcelocation = new ResourceLocation(s1);
                        stacks[i] = new ItemStack((ItemLike)Registry.f_122827_.m_6612_(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + s1 + " does not exist")));
                    }
                } else {
                    stacks[i] = ItemStack.f_41583_;
                }
                chances[i] = GsonHelper.m_13820_((JsonObject)jsonObject, (String)(resultName + "Chance"), (float)(switch (i) {
                    default -> 1.0f;
                    case 1 -> 0.5f;
                    case 2 -> 0.1f;
                }));
            }
            return new LootRecipe(recipeID, s, ingredient, stacks[0], chances[0], stacks[1], chances[1], stacks[2], chances[2]);
        }

        @Nullable
        public LootRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf byteBuf) {
            String s = byteBuf.m_130136_(Short.MAX_VALUE);
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)byteBuf);
            ItemStack result1 = byteBuf.m_130267_();
            float chance1 = byteBuf.readFloat();
            ItemStack result2 = byteBuf.m_130267_();
            float chance2 = byteBuf.readFloat();
            ItemStack result3 = byteBuf.m_130267_();
            float chance3 = byteBuf.readFloat();
            return new LootRecipe(recipeID, s, ingredient, result1, chance1, result2, chance2, result3, chance3);
        }

        public void toNetwork(FriendlyByteBuf byteBuf, LootRecipe recipe) {
            byteBuf.m_130070_(recipe.group);
            recipe.ingredient.m_43923_(byteBuf);
            byteBuf.m_130055_(recipe.result);
            byteBuf.writeFloat(recipe.resultChance);
            byteBuf.m_130055_(recipe.result2);
            byteBuf.writeFloat(recipe.result2Chance);
            byteBuf.m_130055_(recipe.result3);
            byteBuf.writeFloat(recipe.result3Chance);
        }
    }
}

