/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.menu;

import com.shynieke.statues.blockentities.ShulkerStatueBlockEntity;
import com.shynieke.statues.registry.StatueRegistry;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ShulkerStatueMenu
extends AbstractContainerMenu {
    private final ShulkerStatueBlockEntity shulkerBE;

    public ShulkerStatueMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, ShulkerStatueMenu.getBlockEntity(playerInventory, data));
    }

    private static ShulkerStatueBlockEntity getBlockEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity BlockEntityAtPos = playerInventory.f_35978_.f_19853_.m_7702_(data.m_130135_());
        if (BlockEntityAtPos instanceof ShulkerStatueBlockEntity) {
            return (ShulkerStatueBlockEntity)BlockEntityAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + BlockEntityAtPos);
    }

    public ShulkerStatueMenu(int id, Inventory playerInventoryIn, ShulkerStatueBlockEntity shulkerBlockEntity) {
        super((MenuType)StatueRegistry.SHULKER_STATUE_MENU.get(), id);
        int x;
        int y;
        this.shulkerBE = shulkerBlockEntity;
        int xPos = 8;
        int yPos = 18;
        int index = 0;
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                int middle = x - 4;
                if (middle >= -1 && middle <= 1) continue;
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)shulkerBlockEntity.handler, index++, xPos + x * 18, yPos + y * 18));
            }
        }
        yPos = 84;
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventoryIn, x + y * 9 + 9, xPos + x * 18, yPos + y * 18));
            }
        }
        for (int x2 = 0; x2 < 9; ++x2) {
            this.m_38897_(new Slot((Container)playerInventoryIn, x2, xPos + x2 * 18, yPos + 58));
        }
    }

    public boolean m_6875_(Player playerIn) {
        return this.shulkerBE.stillValid(playerIn) && !playerIn.m_5833_();
    }

    @Nonnull
    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            int containerSize = 18;
            if (index < 18 ? !this.m_38903_(itemstack1, 18, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, 18, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        this.m_6199_(null);
        return itemstack;
    }

    public ShulkerStatueBlockEntity getShulkerBE() {
        return this.shulkerBE;
    }

    public void m_38946_() {
        super.m_38946_();
    }
}

