/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.datagen.server;

import com.shynieke.statues.registry.StatueRegistry;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class StatueAdvancementProvider
extends AdvancementProvider {
    public StatueAdvancementProvider(DataGenerator generatorIn, ExistingFileHelper fileHelperIn) {
        super(generatorIn, fileHelperIn);
    }

    protected void registerAdvancements(Consumer<Advancement> consumer, ExistingFileHelper fileHelper) {
        Advancement root = Advancement.Builder.m_138353_().m_138358_(StatueAdvancementProvider.rootDisplay((ItemLike)StatueRegistry.STATUE_CORE.get(), StatueAdvancementProvider.advancementPrefix("root.title"), StatueAdvancementProvider.advancementPrefix("root.desc"), StatueAdvancementProvider.modLoc("textures/block/pebble.png"))).m_138386_("core", (CriterionTriggerInstance)EnterBlockTrigger.TriggerInstance.m_31297_((Block)Blocks.f_50016_)).m_138389_(consumer, StatueAdvancementProvider.rootID("root"));
        Advancement elderGuardian = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.ELDER_GUARDIAN_STATUE, FrameType.GOAL, false, root);
        StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.RAVAGER_STATUE, FrameType.GOAL, false, elderGuardian);
        Advancement warden = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.WARDEN_STATUE, FrameType.GOAL, false, root);
        Advancement zombie = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.ZOMBIE_STATUE, root);
        Advancement babyZombie = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.BABY_ZOMBIE_STATUE, zombie);
        Advancement flood = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.FLOOD_STATUE, FrameType.GOAL, true, babyZombie);
        Advancement husk = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.HUSK_STATUE, zombie);
        Advancement creeper = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.CREEPER_STATUE, husk);
        Advancement campfire = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.CAMPFIRE_STATUE, FrameType.CHALLENGE, true, creeper);
        Advancement drowned = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.DROWNED_STATUE, husk);
        Advancement guardian = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.GUARDIAN_STATUE, drowned);
        Advancement spider = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.SPIDER_STATUE, husk);
        Advancement slime = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.SLIME_STATUE, spider);
        Advancement statueTable = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.STATUE_TABLE, root);
        Advancement displayStand = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.DISPLAY_STAND, statueTable);
        Advancement infoStatue = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.INFO_STATUE, displayStand);
        Advancement bumbo = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.BUMBO_STATUE, infoStatue);
        Advancement enderman = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.ENDERMAN_STATUE, root);
        Advancement endermite = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.ENDERMITE_STATUE, enderman);
        Advancement shulker = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.SHULKER_STATUE, endermite);
        Advancement cod = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.COD_STATUE, root);
        Advancement salmon = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.SALMON_STATUE, cod);
        Advancement tropical = StatueAdvancementProvider.onHoldAnyBlock(consumer, StatueRegistry.TROPICAL_FISH_B, FrameType.TASK, false, salmon, "tropical_fish_statue", RequirementsStrategy.f_15979_, StatueRegistry.TROPICAL_FISH_B, StatueRegistry.TROPICAL_FISH_BB, StatueRegistry.TROPICAL_FISH_BE, StatueRegistry.TROPICAL_FISH_BM, StatueRegistry.TROPICAL_FISH_BMB, StatueRegistry.TROPICAL_FISH_BMS, StatueRegistry.TROPICAL_FISH_E, StatueRegistry.TROPICAL_FISH_ES, StatueRegistry.TROPICAL_FISH_HB, StatueRegistry.TROPICAL_FISH_SB, StatueRegistry.TROPICAL_FISH_SD, StatueRegistry.TROPICAL_FISH_SS);
        Advancement tropicalAll = StatueAdvancementProvider.onHoldAnyBlock(consumer, StatueRegistry.TROPICAL_FISH_BB, FrameType.GOAL, false, tropical, "tropical_fish_all_statue", RequirementsStrategy.f_15978_, StatueRegistry.TROPICAL_FISH_B, StatueRegistry.TROPICAL_FISH_BB, StatueRegistry.TROPICAL_FISH_BE, StatueRegistry.TROPICAL_FISH_BM, StatueRegistry.TROPICAL_FISH_BMB, StatueRegistry.TROPICAL_FISH_BMS, StatueRegistry.TROPICAL_FISH_E, StatueRegistry.TROPICAL_FISH_ES, StatueRegistry.TROPICAL_FISH_HB, StatueRegistry.TROPICAL_FISH_SB, StatueRegistry.TROPICAL_FISH_SD, StatueRegistry.TROPICAL_FISH_SS);
        Advancement axolotl = StatueAdvancementProvider.onHoldAnyBlock(consumer, StatueRegistry.AXOLOTL_LUCY_STATUE, FrameType.TASK, false, salmon, "axolotl_statue", RequirementsStrategy.f_15979_, StatueRegistry.AXOLOTL_LUCY_STATUE, StatueRegistry.AXOLOTL_WILD_STATUE, StatueRegistry.AXOLOTL_GOLD_STATUE, StatueRegistry.AXOLOTL_CYAN_STATUE, StatueRegistry.AXOLOTL_BLUE_STATUE);
        Advancement axolotlAll = StatueAdvancementProvider.onHoldAnyBlock(consumer, StatueRegistry.AXOLOTL_GOLD_STATUE, FrameType.GOAL, false, axolotl, "axolotl_all_statue", RequirementsStrategy.f_15978_, StatueRegistry.AXOLOTL_LUCY_STATUE, StatueRegistry.AXOLOTL_WILD_STATUE, StatueRegistry.AXOLOTL_GOLD_STATUE, StatueRegistry.AXOLOTL_CYAN_STATUE, StatueRegistry.AXOLOTL_BLUE_STATUE);
        Advancement pufferSmall = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.PUFFERFISH_SMALL_STATUE, salmon);
        Advancement pufferMedium = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.PUFFERFISH_MEDIUM_STATUE, pufferSmall);
        Advancement puffer = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.PUFFERFISH_STATUE, pufferMedium);
        Advancement dolphin = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.DOLPHIN_STATUE, salmon);
        Advancement squid = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.SQUID_STATUE, dolphin);
        Advancement turtle = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.TURTLE_STATUE, squid);
        Advancement witch = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.WITCH_STATUE, root);
        Advancement pillager = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.PILLAGER_STATUE, witch);
        Advancement vindicator = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.VINDICATOR_STATUE, pillager);
        StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.EVOKER_STATUE, vindicator);
        Advancement cow = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.COW_STATUE, root);
        Advancement mooshroom = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.MOOSHROOM_STATUE, cow);
        Advancement mooshroomBrown = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.BROWN_MOOSHROOM_STATUE, mooshroom);
        Advancement pig = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.PIG_STATUE, cow);
        Advancement snowman = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.SNOW_GOLEM_STATUE, cow);
        Advancement allay = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.ALLAY_STATUE, cow);
        Advancement wasteland = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.WASTELAND_STATUE, FrameType.CHALLENGE, true, pig);
        Advancement chicken = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.CHICKEN_STATUE, cow);
        Advancement kingCluck = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.KING_CLUCK_STATUE, FrameType.GOAL, true, chicken);
        Advancement chickenJockey = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.CHICKEN_JOCKEY_STATUE, chicken);
        Advancement sheep = StatueAdvancementProvider.onHoldAnyBlock(consumer, StatueRegistry.SHEEP_STATUE_WHITE, FrameType.TASK, false, cow, "sheep_statue", RequirementsStrategy.f_15979_, StatueRegistry.SHEEP_SHAVEN_STATUE, StatueRegistry.SHEEP_STATUE_BLACK, StatueRegistry.SHEEP_STATUE_BLUE, StatueRegistry.SHEEP_STATUE_BROWN, StatueRegistry.SHEEP_STATUE_CYAN, StatueRegistry.SHEEP_STATUE_GRAY, StatueRegistry.SHEEP_STATUE_GREEN, StatueRegistry.SHEEP_STATUE_LIGHT_BLUE, StatueRegistry.SHEEP_STATUE_LIGHT_GRAY, StatueRegistry.SHEEP_STATUE_LIME, StatueRegistry.SHEEP_STATUE_MAGENTA, StatueRegistry.SHEEP_STATUE_ORANGE, StatueRegistry.SHEEP_STATUE_PINK, StatueRegistry.SHEEP_STATUE_PURPLE, StatueRegistry.SHEEP_STATUE_RED, StatueRegistry.SHEEP_STATUE_WHITE, StatueRegistry.SHEEP_STATUE_YELLOW);
        Advancement sheepAll = StatueAdvancementProvider.onHoldAnyBlock(consumer, StatueRegistry.SHEEP_STATUE_WHITE, FrameType.GOAL, false, sheep, "sheep_all_statue", RequirementsStrategy.f_15978_, StatueRegistry.SHEEP_SHAVEN_STATUE, StatueRegistry.SHEEP_STATUE_BLACK, StatueRegistry.SHEEP_STATUE_BLUE, StatueRegistry.SHEEP_STATUE_BROWN, StatueRegistry.SHEEP_STATUE_CYAN, StatueRegistry.SHEEP_STATUE_GRAY, StatueRegistry.SHEEP_STATUE_GREEN, StatueRegistry.SHEEP_STATUE_LIGHT_BLUE, StatueRegistry.SHEEP_STATUE_LIGHT_GRAY, StatueRegistry.SHEEP_STATUE_LIME, StatueRegistry.SHEEP_STATUE_MAGENTA, StatueRegistry.SHEEP_STATUE_ORANGE, StatueRegistry.SHEEP_STATUE_PINK, StatueRegistry.SHEEP_STATUE_PURPLE, StatueRegistry.SHEEP_STATUE_RED, StatueRegistry.SHEEP_STATUE_WHITE, StatueRegistry.SHEEP_STATUE_YELLOW);
        Advancement cat = StatueAdvancementProvider.onHoldAnyBlock(consumer, StatueRegistry.CAT_JELLIE_STATUE, FrameType.TASK, false, root, "cat_statue", RequirementsStrategy.f_15979_, StatueRegistry.CAT_BLACK_STATUE, StatueRegistry.CAT_BRITISH_SHORTHAIR_STATUE, StatueRegistry.CAT_CALICO_STATUE, StatueRegistry.CAT_JELLIE_STATUE, StatueRegistry.CAT_PERSIAN_STATUE, StatueRegistry.CAT_RAGDOLL_STATUE, StatueRegistry.CAT_RED_STATUE, StatueRegistry.CAT_SIAMESE_STATUE, StatueRegistry.CAT_TABBY_STATUE, StatueRegistry.CAT_TUXEDO_STATUE, StatueRegistry.CAT_WHITE_STATUE);
        Advancement catAll = StatueAdvancementProvider.onHoldAnyBlock(consumer, StatueRegistry.CAT_TUXEDO_STATUE, FrameType.GOAL, false, cat, "cat_all_statue", RequirementsStrategy.f_15978_, StatueRegistry.CAT_BLACK_STATUE, StatueRegistry.CAT_BRITISH_SHORTHAIR_STATUE, StatueRegistry.CAT_CALICO_STATUE, StatueRegistry.CAT_JELLIE_STATUE, StatueRegistry.CAT_PERSIAN_STATUE, StatueRegistry.CAT_RAGDOLL_STATUE, StatueRegistry.CAT_RED_STATUE, StatueRegistry.CAT_SIAMESE_STATUE, StatueRegistry.CAT_TABBY_STATUE, StatueRegistry.CAT_TUXEDO_STATUE, StatueRegistry.CAT_WHITE_STATUE);
        Advancement frog = StatueAdvancementProvider.onHoldAnyBlock(consumer, StatueRegistry.FROG_TEMPERATE_STATUE, FrameType.TASK, false, root, "frog_statue", RequirementsStrategy.f_15979_, StatueRegistry.FROG_TEMPERATE_STATUE, StatueRegistry.FROG_WARM_STATUE, StatueRegistry.FROG_COLD_STATUE);
        Advancement frogAll = StatueAdvancementProvider.onHoldAnyBlock(consumer, StatueRegistry.FROG_COLD_STATUE, FrameType.GOAL, false, frog, "frog_all_statue", RequirementsStrategy.f_15978_, StatueRegistry.FROG_TEMPERATE_STATUE, StatueRegistry.FROG_WARM_STATUE, StatueRegistry.FROG_COLD_STATUE);
        Advancement tadpole = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.TADPOLE_STATUE, frog);
        Advancement fox = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.FOX_STATUE, cat);
        Advancement foxSnow = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.FOX_SNOW_STATUE, fox);
        Advancement panda = StatueAdvancementProvider.onHoldAnyBlock(consumer, StatueRegistry.PANDA_LAZY_STATUE, FrameType.TASK, false, foxSnow, "panda_statue", RequirementsStrategy.f_15979_, StatueRegistry.PANDA_ANGRY_STATUE, StatueRegistry.PANDA_BROWN_STATUE, StatueRegistry.PANDA_LAZY_STATUE, StatueRegistry.PANDA_NORMAL_STATUE, StatueRegistry.PANDA_PLAYFUL_STATUE, StatueRegistry.PANDA_WEAK_STATUE, StatueRegistry.PANDA_WORRIED_STATUE);
        Advancement pandaAll = StatueAdvancementProvider.onHoldAnyBlock(consumer, StatueRegistry.PANDA_BROWN_STATUE, FrameType.GOAL, false, panda, "panda_all_statue", RequirementsStrategy.f_15978_, StatueRegistry.PANDA_ANGRY_STATUE, StatueRegistry.PANDA_BROWN_STATUE, StatueRegistry.PANDA_LAZY_STATUE, StatueRegistry.PANDA_NORMAL_STATUE, StatueRegistry.PANDA_PLAYFUL_STATUE, StatueRegistry.PANDA_WEAK_STATUE, StatueRegistry.PANDA_WORRIED_STATUE);
        Advancement bee = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.BEE_STATUE, foxSnow);
        Advancement beeTrans = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.TRANS_BEE_STATUE, FrameType.GOAL, false, bee);
        Advancement beeAngry = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.ANGRY_BEE_STATUE, bee);
        Advancement rabbit = StatueAdvancementProvider.onHoldAnyBlock(consumer, StatueRegistry.RABBIT_BR_STATUE, FrameType.TASK, false, foxSnow, "rabbit_statue", RequirementsStrategy.f_15979_, StatueRegistry.RABBIT_BR_STATUE, StatueRegistry.RABBIT_BS_STATUE, StatueRegistry.RABBIT_BW_STATUE, StatueRegistry.RABBIT_GO_STATUE, StatueRegistry.RABBIT_WH_STATUE, StatueRegistry.RABBIT_WS_STATUE);
        Advancement rabbitAll = StatueAdvancementProvider.killerCollection(consumer, StatueRegistry.RABBIT_WH_STATUE, rabbit, "rabbit_all_statue", StatueRegistry.RABBIT_BR_STATUE, StatueRegistry.RABBIT_BS_STATUE, StatueRegistry.RABBIT_BW_STATUE, StatueRegistry.RABBIT_GO_STATUE, StatueRegistry.RABBIT_WH_STATUE, StatueRegistry.RABBIT_WS_STATUE);
        Advancement blaze = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.BLAZE_STATUE, root);
        Advancement ghast = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.GHAST_STATUE, blaze);
        Advancement magma = StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.MAGMA_STATUE, ghast);
        StatueAdvancementProvider.onHoldBlock(consumer, StatueRegistry.PLAYER_STATUE, root);
    }

    protected static Advancement onHoldBlock(Consumer<Advancement> consumer, RegistryObject<Block> registryObject, FrameType type, boolean hidden, Advancement root) {
        String path = registryObject.getId().m_135815_();
        ResourceLocation registryLocation = StatueAdvancementProvider.modLoc(path);
        DisplayInfo info = hidden ? StatueAdvancementProvider.hiddenDisplay((ItemLike)registryObject.get(), path, type) : StatueAdvancementProvider.simpleDisplay((ItemLike)registryObject.get(), path, type);
        return Advancement.Builder.m_138353_().m_138358_(info).m_138398_(root).m_138386_(path, (CriterionTriggerInstance)StatueAdvancementProvider.onHeldItems((ItemLike)registryObject.get())).m_138389_(consumer, StatueAdvancementProvider.rootID(registryLocation.m_135815_()));
    }

    protected static Advancement onHoldBlock(Consumer<Advancement> consumer, RegistryObject<Block> registryObject, Advancement root) {
        String path = registryObject.getId().m_135815_();
        ResourceLocation registryLocation = StatueAdvancementProvider.modLoc(path);
        return Advancement.Builder.m_138353_().m_138358_(StatueAdvancementProvider.simpleDisplay((ItemLike)registryObject.get(), path, FrameType.TASK)).m_138398_(root).m_138386_(path, (CriterionTriggerInstance)StatueAdvancementProvider.onHeldItems((ItemLike)registryObject.get())).m_138389_(consumer, StatueAdvancementProvider.rootID(registryLocation.m_135815_()));
    }

    protected static Advancement onHoldAnyBlock(Consumer<Advancement> consumer, RegistryObject<Block> displayObject, FrameType type, boolean hidden, Advancement root, String path, RequirementsStrategy requirementsStrategy, RegistryObject<Block> ... registryObjects) {
        ResourceLocation registryLocation = StatueAdvancementProvider.modLoc(path);
        DisplayInfo info = hidden ? StatueAdvancementProvider.hiddenDisplay((ItemLike)displayObject.get(), path, type) : StatueAdvancementProvider.simpleDisplay((ItemLike)displayObject.get(), path, type);
        Advancement.Builder builder = Advancement.Builder.m_138353_().m_138358_(info).m_138398_(root);
        for (RegistryObject<Block> registryObject : registryObjects) {
            builder.m_138386_(registryObject.getId().m_135815_(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)registryObject.get()}));
        }
        return builder.m_138360_(requirementsStrategy).m_138389_(consumer, StatueAdvancementProvider.rootID(registryLocation.m_135815_()));
    }

    protected static Advancement killerCollection(Consumer<Advancement> consumer, RegistryObject<Block> displayObject, Advancement root, String path, RegistryObject<Block> ... registryObjects) {
        ResourceLocation registryLocation = StatueAdvancementProvider.modLoc(path);
        Advancement.Builder builder = Advancement.Builder.m_138353_().m_138358_(StatueAdvancementProvider.simpleDisplay((ItemLike)displayObject.get(), path, FrameType.GOAL)).m_138398_(root);
        for (RegistryObject<Block> registryObject : registryObjects) {
            builder.m_138386_(registryObject.getId().m_135815_(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)registryObject.get()}));
        }
        return builder.m_138354_(AdvancementRewards.Builder.m_144826_((ResourceLocation)StatueAdvancementProvider.modLoc("killer_rabbit"))).m_138360_(RequirementsStrategy.f_15978_).m_138389_(consumer, StatueAdvancementProvider.rootID(registryLocation.m_135815_()));
    }

    protected static Advancement onHoldItem(Consumer<Advancement> consumer, RegistryObject<Item> registryObject, FrameType type, boolean hidden, Advancement root) {
        String path = registryObject.getId().m_135815_();
        ResourceLocation registryLocation = StatueAdvancementProvider.modLoc(path);
        DisplayInfo info = hidden ? StatueAdvancementProvider.hiddenDisplay((ItemLike)registryObject.get(), path, type) : StatueAdvancementProvider.simpleDisplay((ItemLike)registryObject.get(), path, type);
        return Advancement.Builder.m_138353_().m_138358_(info).m_138398_(root).m_138386_(path, (CriterionTriggerInstance)StatueAdvancementProvider.onHeldItems((ItemLike)registryObject.get())).m_138389_(consumer, StatueAdvancementProvider.rootID(registryLocation.m_135815_()));
    }

    protected static DisplayInfo rootDisplay(ItemLike icon, String titleKey, String descKey, ResourceLocation background) {
        return new DisplayInfo(new ItemStack(icon), (Component)Component.m_237115_((String)titleKey), (Component)Component.m_237115_((String)descKey), background, FrameType.TASK, false, false, false);
    }

    protected static DisplayInfo simpleDisplay(ItemLike icon, String name, FrameType type) {
        return new DisplayInfo(new ItemStack(icon), (Component)Component.m_237115_((String)StatueAdvancementProvider.advancementPrefix(name + ".title")), (Component)Component.m_237115_((String)StatueAdvancementProvider.advancementPrefix(name + ".desc")), null, type, true, true, false);
    }

    protected static DisplayInfo hiddenDisplay(ItemLike icon, String name, FrameType type) {
        return new DisplayInfo(new ItemStack(icon), (Component)Component.m_237115_((String)StatueAdvancementProvider.advancementPrefix(name + ".title")), (Component)Component.m_237115_((String)StatueAdvancementProvider.advancementPrefix(name + ".desc")), null, type, true, true, true);
    }

    protected static KilledTrigger.TriggerInstance onKill(EntityType<?> entityType) {
        return KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(entityType));
    }

    protected static InventoryChangeTrigger.TriggerInstance onHeldItems(ItemLike ... items) {
        return InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])items);
    }

    private static ResourceLocation modLoc(String path) {
        return new ResourceLocation("statues", path);
    }

    private static String advancementPrefix(String name) {
        return "advancement.statues." + name;
    }

    private static String rootID(String name) {
        return StatueAdvancementProvider.modLoc(name).toString();
    }
}

