/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.client;

import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.shynieke.statues.Statues;
import com.shynieke.statues.blockentities.PlayerBlockEntity;
import com.shynieke.statues.blocks.statues.fish.FishStatueBlock;
import com.shynieke.statues.client.SupporterType;
import com.shynieke.statues.client.ber.StatueTableBER;
import com.shynieke.statues.client.model.PlayerStatueModel;
import com.shynieke.statues.client.render.PlayerBER;
import com.shynieke.statues.client.render.PlayerStatueRenderer;
import com.shynieke.statues.client.render.StatueBatRenderer;
import com.shynieke.statues.client.screen.ShulkerStatueScreen;
import com.shynieke.statues.client.screen.StatueTableScreen;
import com.shynieke.statues.compat.curios.client.StatueCurioRenderer;
import com.shynieke.statues.registry.StatueBlockEntities;
import com.shynieke.statues.registry.StatueRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.Services;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ClientHandler {
    public static final ModelLayerLocation PLAYER_STATUE = new ModelLayerLocation(new ResourceLocation("statues", "player_statue"), "player_statue");
    public static final ModelLayerLocation PLAYER_STATUE_SLIM = new ModelLayerLocation(new ResourceLocation("statues", "player_statue_slim"), "player_statue_slim");
    public static final List<UUID> SUPPORTER = new ArrayList<UUID>();
    public static final List<UUID> TRANSLATORS = new ArrayList<UUID>();

    public static void doClientStuff(FMLClientSetupEvent event) {
        ClientHandler.setPlayerCache(Minecraft.m_91087_());
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)StatueRegistry.STATUE_TABLE_MENU.get()), StatueTableScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)StatueRegistry.SHULKER_STATUE_MENU.get()), ShulkerStatueScreen::new);
            ItemProperties.register((Item)((Item)StatueRegistry.PLAYER_COMPASS.get()), (ResourceLocation)new ResourceLocation("angle"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){
                private final Angle rotation = new Angle();
                private final Angle rota = new Angle();

                public float m_142187_(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entityIn, int p_174567_) {
                    LivingEntity entity;
                    Object object = entity = entityIn != null ? entityIn : stack.m_41609_();
                    if (entity == null) {
                        return 0.0f;
                    }
                    if (level == null && entity.f_19853_ instanceof ClientLevel) {
                        level = (ClientLevel)entity.f_19853_;
                    }
                    if (level != null) {
                        long location;
                        BlockPos blockpos = this.getWorldPos(level);
                        long gameTime = level.m_46467_();
                        CompoundTag tag = stack.m_41783_();
                        if (tag != null && tag.m_128441_("lastPlayerLocation") && (location = tag.m_128454_("lastPlayerLocation")) != 0L) {
                            blockpos = BlockPos.m_122022_((long)location);
                        }
                        if (blockpos != null && !(entity.m_20275_((double)blockpos.m_123341_() + 0.5, entity.m_20182_().m_7098_(), (double)blockpos.m_123343_() + 0.5) < (double)1.0E-5f)) {
                            double d3;
                            boolean flag = entity instanceof Player && ((Player)entity).m_7578_();
                            double d1 = 0.0;
                            if (flag) {
                                d1 = entityIn.m_146908_();
                            } else if (entity instanceof ItemFrame) {
                                d1 = this.getFrameRotation((ItemFrame)entity);
                            } else if (entity instanceof ItemEntity) {
                                d1 = 180.0f - ((ItemEntity)entity).m_32008_(0.5f) / ((float)Math.PI * 2) * 360.0f;
                            } else if (entityIn != null) {
                                d1 = entityIn.f_20883_;
                            }
                            d1 = Mth.m_14109_((double)(d1 / 360.0), (double)1.0);
                            double d2 = this.getLocationToAngle(Vec3.m_82512_((Vec3i)blockpos), (Entity)entity) / 6.2831854820251465;
                            if (flag) {
                                if (this.rotation.shouldUpdate(gameTime)) {
                                    this.rotation.update(gameTime, 0.5 - (d1 - 0.25));
                                }
                                d3 = d2 + this.rotation.rotation;
                            } else {
                                d3 = 0.5 - (d1 - 0.25 - d2);
                            }
                            return Mth.m_14091_((float)((float)d3), (float)1.0f);
                        }
                        if (this.rota.shouldUpdate(gameTime)) {
                            this.rota.update(gameTime, Math.random());
                        }
                        double d0 = this.rota.rotation + (double)((float)stack.hashCode() / 2.1474836E9f);
                        return Mth.m_14091_((float)((float)d0), (float)1.0f);
                    }
                    double d0 = this.rota.rotation + (double)((float)stack.hashCode() / 2.1474836E9f);
                    return Mth.m_14091_((float)((float)d0), (float)1.0f);
                }

                @Nullable
                private BlockPos getWorldPos(ClientLevel level) {
                    return level.m_6042_().f_63858_() ? level.m_220360_() : null;
                }

                private double getFrameRotation(ItemFrame itemFrameIn) {
                    Direction direction = itemFrameIn.m_6350_();
                    int i = direction.m_122434_().m_122478_() ? 90 * direction.m_122421_().m_122540_() : 0;
                    return Mth.m_14098_((int)(180 + direction.m_122416_() * 90 + itemFrameIn.m_31823_() * 45 + i));
                }

                private double getLocationToAngle(Vec3 location, Entity entityIn) {
                    return Math.atan2(location.m_7094_() - entityIn.m_20189_(), location.m_7096_() - entityIn.m_20185_());
                }
            });
        });
        new Thread(() -> {
            Statues.LOGGER.info("Loading Statues supporter data...");
            try {
                URL url = new URL("https://raw.githubusercontent.com/ShyNieke/StatuesMod/1.19.x/Supporters.txt");
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                    String s;
                    block12: while ((s = reader.readLine()) != null) {
                        String[] split = s.split(" ", 2);
                        if (split.length != 2) {
                            Statues.LOGGER.error("Invalid entry {} will be ignored.", (Object)s);
                            continue;
                        }
                        SupporterType type = SupporterType.valueOf(split[1]);
                        switch (type) {
                            default: {
                                SUPPORTER.add(UUID.fromString(split[0]));
                                continue block12;
                            }
                            case TRANSLATOR: 
                        }
                        TRANSLATORS.add(UUID.fromString(split[0]));
                    }
                    reader.close();
                }
                catch (IOException ex) {
                    Statues.LOGGER.error("Exception loading supporter data!");
                    ex.printStackTrace();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Statues.LOGGER.info("Loaded {} supporters.", (Object)SUPPORTER.size());
            Statues.LOGGER.info("Loaded {} translators.", (Object)TRANSLATORS.size());
        }, "Statues Perks Data Loader").start();
        if (ModList.get().isLoaded("curios")) {
            StatueCurioRenderer.setupRenderer(event);
        }
    }

    public static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)StatueBlockEntities.PLAYER.get(), PlayerBER::new);
        event.registerEntityRenderer((EntityType)StatueRegistry.PLAYER_STATUE_ENTITY.get(), PlayerStatueRenderer::new);
        event.registerEntityRenderer((EntityType)StatueRegistry.STATUE_BAT.get(), StatueBatRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)StatueBlockEntities.STATUE_TABLE.get(), StatueTableBER::new);
    }

    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(PLAYER_STATUE, () -> LayerDefinition.m_171565_((MeshDefinition)PlayerStatueModel.createStatueMesh(CubeDeformation.f_171458_, false), (int)64, (int)64));
        event.registerLayerDefinition(PLAYER_STATUE_SLIM, () -> LayerDefinition.m_171565_((MeshDefinition)PlayerStatueModel.createStatueMesh(CubeDeformation.f_171458_, true), (int)64, (int)64));
    }

    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register(FishStatueBlock::getColor, new Block[]{(Block)StatueRegistry.TROPICAL_FISH_B.get(), (Block)StatueRegistry.TROPICAL_FISH_BB.get(), (Block)StatueRegistry.TROPICAL_FISH_BE.get(), (Block)StatueRegistry.TROPICAL_FISH_BM.get(), (Block)StatueRegistry.TROPICAL_FISH_BMB.get(), (Block)StatueRegistry.TROPICAL_FISH_BMS.get(), (Block)StatueRegistry.TROPICAL_FISH_E.get(), (Block)StatueRegistry.TROPICAL_FISH_ES.get(), (Block)StatueRegistry.TROPICAL_FISH_HB.get(), (Block)StatueRegistry.TROPICAL_FISH_SB.get(), (Block)StatueRegistry.TROPICAL_FISH_SD.get(), (Block)StatueRegistry.TROPICAL_FISH_SS.get()});
    }

    public static void onLogin(ClientPlayerNetworkEvent.LoggingIn event) {
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.m_91090_()) {
            ClientHandler.setPlayerCache(mc);
        }
    }

    public static void onRespawn(ClientPlayerNetworkEvent.Clone event) {
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.m_91090_()) {
            ClientHandler.setPlayerCache(mc);
        }
    }

    public static void preStitchEvent(TextureStitchEvent.Pre event) {
        if (ModList.get().isLoaded("curios") && event.getAtlas().m_118330_().equals((Object)InventoryMenu.f_39692_)) {
            event.addSprite(new ResourceLocation("statues", "curios/core"));
        }
    }

    private static void setPlayerCache(Minecraft mc) {
        YggdrasilAuthenticationService authenticationService = new YggdrasilAuthenticationService(mc.m_91096_());
        Services services = Services.m_214344_((YggdrasilAuthenticationService)authenticationService, (File)mc.f_91069_);
        services.f_214336_().m_143974_((Executor)mc);
        PlayerBlockEntity.setup(services, (Executor)mc);
        GameProfileCache.m_11004_((boolean)false);
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Angle {
        private double rotation;
        private double deltaRotation;
        private long lastUpdateTick;

        private Angle() {
        }

        private boolean shouldUpdate(long p_239448_1_) {
            return this.lastUpdateTick != p_239448_1_;
        }

        private void update(long updateTick, double p_239449_3_) {
            this.lastUpdateTick = updateTick;
            double d0 = p_239449_3_ - this.rotation;
            d0 = Mth.m_14109_((double)(d0 + 0.5), (double)1.0) - 0.5;
            this.deltaRotation += d0 * 0.1;
            this.deltaRotation *= 0.8;
            this.rotation = Mth.m_14109_((double)(this.rotation + this.deltaRotation), (double)1.0);
        }
    }
}

