/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues;

import com.shynieke.statues.blocks.AbstractBaseBlock;
import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.compat.patchouli.PatchouliCompat;
import com.shynieke.statues.config.StatuesConfig;
import com.shynieke.statues.registry.StatueTags;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.ModList;

public class InfoStatueBlock
extends AbstractBaseBlock {
    private static final VoxelShape BOTTOM_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.5, (double)13.0);
    private static final VoxelShape TOP_SHAPE = Block.m_49796_((double)5.5, (double)4.5, (double)5.5, (double)10.5, (double)7.0, (double)10.5);
    private static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)BOTTOM_SHAPE, (VoxelShape)TOP_SHAPE);

    public InfoStatueBlock(BlockBehaviour.Properties builder) {
        super(builder.m_60918_(SoundType.f_56742_));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult result) {
        if (handIn == InteractionHand.MAIN_HAND) {
            ItemStack heldItem = playerIn.m_21205_();
            if (heldItem.m_150930_(Items.f_42517_) && ModList.get().isLoaded("patchouli")) {
                PatchouliCompat.convertBook(playerIn);
                return InteractionResult.SUCCESS;
            }
            if (heldItem.m_150930_(Items.f_42516_) && !(playerIn instanceof FakePlayer) && playerIn.m_36316_().getId().equals(UUID.fromString("7135da42-d327-47bb-bb04-5ba4e212fb32"))) {
                if (!level.f_46443_) {
                    playerIn.m_213846_((Component)Component.m_237113_((String)"Statues version: ").m_7220_((Component)Component.m_237113_((String)ModList.get().getModFileById("statues").versionString())).m_130940_(ChatFormatting.GOLD));
                }
                return InteractionResult.SUCCESS;
            }
            if (heldItem.m_204117_(StatueTags.UPGRADEABLE_STATUES) && !(playerIn instanceof FakePlayer) && this.upgraded(heldItem)) {
                BlockItem blockItem;
                Item item = heldItem.m_41720_();
                if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).m_40614_()) instanceof AbstractStatueBase) {
                    AbstractStatueBase statueBase = (AbstractStatueBase)item;
                    if (!level.f_46443_) {
                        playerIn.m_213846_((Component)Component.m_237113_((String)"To level this statue you need to kill ").m_7220_((Component)Component.m_237115_((String)statueBase.getEntity().m_20675_()).m_130940_(ChatFormatting.GOLD)));
                    }
                }
                return InteractionResult.SUCCESS;
            }
            this.sendInfoMessage(playerIn, level, pos);
        }
        return InteractionResult.SUCCESS;
    }

    private boolean upgraded(ItemStack stack) {
        return stack.m_41737_("BlockEntityTag") != null && stack.m_41737_("BlockEntityTag").m_128471_("statueUpgraded");
    }

    public void sendInfoMessage(Player player, Level level, BlockPos pos) {
        if (!level.f_46443_) {
            int random = level.f_46441_.m_188503_(100);
            ArrayList<String> messages = new ArrayList<String>((Collection)StatuesConfig.COMMON.info_messages.get());
            List luckyPlayers = (List)StatuesConfig.COMMON.lucky_players.get();
            if (ModList.get().isLoaded("veinminer")) {
                messages.add("Did you know we have veinminer");
            }
            if (ModList.get().isLoaded("curios")) {
                messages.add("Did you know we have curios support");
            }
            int idx = new Random().nextInt(messages.size());
            MutableComponent randomMessage = Component.m_237113_((String)((String)messages.get(idx)));
            if (!luckyPlayers.isEmpty() && random < 20) {
                for (String luckyPlayer : luckyPlayers) {
                    if (luckyPlayer.isEmpty()) continue;
                    String luckyUser = luckyPlayer.trim();
                    if (!player.m_5446_().getString().equalsIgnoreCase(luckyUser)) continue;
                    randomMessage = Component.m_237113_((String)"Luck is not on your side today");
                }
            } else {
                LocalDate localdate = LocalDate.now();
                int i = localdate.get(ChronoField.DAY_OF_MONTH);
                int j = localdate.get(ChronoField.MONTH_OF_YEAR);
                randomMessage = level.f_46441_.m_188500_() <= 0.3 && j == 11 && i <= 20 ? Component.m_237113_((String)"Please check out our friends over at ").m_130940_(ChatFormatting.YELLOW).m_7220_(ForgeHooks.newChatWithLinks((String)"https://lovetropics.com/")) : Component.m_237113_((String)((String)messages.get(idx)));
            }
            player.m_213846_((Component)randomMessage);
            level.m_5594_(null, pos, SoundEvents.f_11797_, SoundSource.NEUTRAL, 0.5f, 1.0f);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

