/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blockentities;

import com.shynieke.statues.Statues;
import com.shynieke.statues.blockentities.AbstractStatueBlockEntity;
import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.fakeplayer.StatueFakePlayer;
import com.shynieke.statues.recipe.LootRecipe;
import com.shynieke.statues.registry.StatueBlockEntities;
import com.shynieke.statues.registry.StatueRegistry;
import com.shynieke.statues.util.LootHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class StatueBlockEntity
extends AbstractStatueBlockEntity {
    private AABB hitbox;
    protected LootRecipe cachedLootRecipe;

    public StatueBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)StatueBlockEntities.STATUE.get(), pos, state);
    }

    public StatueBlockEntity(BlockEntityType<?> tileType, BlockPos pos, BlockState state) {
        super(tileType, pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, StatueBlockEntity blockEntity) {
        if (((Boolean)state.m_61143_((Property)AbstractStatueBase.INTERACTIVE)).booleanValue() && state.m_60734_() instanceof AbstractStatueBase) {
            if (!blockEntity.isStatueInteractable()) {
                --blockEntity.interactCooldown;
                if (blockEntity.interactCooldown <= 0) {
                    blockEntity.interactCooldown = blockEntity.getInteractCooldown();
                    blockEntity.setStatueInteractable(true);
                }
            }
            if (!blockEntity.isStatueAble()) {
                --blockEntity.cooldown;
                if (blockEntity.cooldown <= 0) {
                    blockEntity.cooldown = blockEntity.getCooldown();
                    blockEntity.setStatueAble(true);
                    if (blockEntity.canAutomate() && blockEntity.canDropLoot()) {
                        blockEntity.giveItem();
                        blockEntity.setStatueInteractable(false);
                    }
                }
            } else if (!level.m_46753_(pos)) {
                if (blockEntity.isSpawner()) {
                    blockEntity.summonMob((ServerLevel)level);
                }
                if (blockEntity.isKiller()) {
                    blockEntity.killMob((ServerLevel)level);
                }
                blockEntity.setStatueAble(false);
            }
            blockEntity.m_6596_();
        }
    }

    @Override
    public InteractionResult interact(Level level, BlockPos pos, BlockState state, Player player, InteractionHand handIn, BlockHitResult result) {
        AbstractStatueBase statueBase = this.getStatue();
        if (statueBase == null) {
            return InteractionResult.PASS;
        }
        if (this.makesSounds()) {
            this.playSound(statueBase.getSound(state), pos);
        }
        if (this.isStatueInteractable()) {
            if (this.canDropLoot()) {
                this.giveItem();
            }
            this.setStatueInteractable(false);
        }
        if (this.hasSpecialInteraction()) {
            this.onSpecialInteract(level, pos, state, player, handIn, result);
        }
        return InteractionResult.CONSUME;
    }

    public void onSpecialInteract(Level level, BlockPos pos, BlockState state, Player player, InteractionHand handIn, BlockHitResult result) {
        Vec3 hitPos = result.m_82450_();
        if (state.m_60713_((Block)StatueRegistry.FLOOD_STATUE.get())) {
            this.floodBehavior(player, pos, handIn, (float)hitPos.f_82479_, (float)hitPos.f_82480_, (float)hitPos.f_82481_);
        } else if (state.m_60713_((Block)StatueRegistry.MOOSHROOM_STATUE.get()) || state.m_60713_((Block)StatueRegistry.BROWN_MOOSHROOM_STATUE.get())) {
            this.mooshroomBehavior(player, pos, handIn);
        } else if (state.m_60713_((Block)StatueRegistry.COW_STATUE.get())) {
            this.cowBehavior(player, pos, handIn);
        } else if (state.m_60713_((Block)StatueRegistry.SPIDER_STATUE.get())) {
            this.giveEffect(player, pos, MobEffects.f_19614_);
        }
    }

    public void giveItem() {
        if (this.f_58857_ != null) {
            LootRecipe loot = this.cachedLootRecipe != null ? this.cachedLootRecipe : (this.cachedLootRecipe = LootHelper.getMatchingLoot(this.f_58857_, new ItemStack((ItemLike)this.m_58900_().m_60734_())));
            if (loot == null) {
                Statues.LOGGER.error("No loot found for statue {}, please report this to the Statues issue tracker", (Object)this.m_58900_());
                return;
            }
            double random = this.f_58857_.f_46441_.m_188500_();
            ItemStack stack1 = loot.m_8043_().m_41777_();
            float chance1 = loot.getChance1();
            if (!stack1.m_41619_() && random <= (double)chance1) {
                this.exportItem(stack1);
            }
            ItemStack stack2 = loot.getResultItem2().m_41777_();
            float chance2 = loot.getChance2();
            if (!stack2.m_41619_() && random <= (double)chance2) {
                this.exportItem(stack2);
            }
            ItemStack stack3 = loot.getResultItem3().m_41777_();
            float chance3 = loot.getChance3();
            if (!stack3.m_41619_() && random <= (double)chance3) {
                this.exportItem(stack3);
            }
        }
    }

    private void exportItem(ItemStack stack) {
        if (this.canAutomate()) {
            ArrayList<AbstractStatueBlockEntity.BiggestInventory> inventoryList = new ArrayList<AbstractStatueBlockEntity.BiggestInventory>();
            for (Direction dir : Direction.values()) {
                IItemHandler itemHandler;
                boolean flag2;
                BlockEntity foundTile;
                BlockPos offPos = this.f_58858_.m_121945_(dir);
                if (!this.f_58857_.isAreaLoaded(this.f_58858_, 1) || (foundTile = this.f_58857_.m_7702_(offPos)) == null) continue;
                ResourceLocation typeLocation = ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)foundTile.m_58903_());
                boolean bl = flag2 = typeLocation != null;
                if (!flag2 || foundTile.m_58901_() || !foundTile.m_58898_() || !foundTile.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent() || (itemHandler = (IItemHandler)foundTile.getCapability(ForgeCapabilities.ITEM_HANDLER, dir.m_122424_()).orElse(null)) == null) continue;
                inventoryList.add(new AbstractStatueBlockEntity.BiggestInventory(offPos, itemHandler.getSlots(), dir.m_122424_()));
            }
            inventoryList.sort(Collections.reverseOrder());
            if (inventoryList.isEmpty()) {
                this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_(), stack));
            } else {
                AbstractStatueBlockEntity.BiggestInventory inventory;
                IItemHandler itemHandler;
                ItemStack rest;
                Iterator iterator = inventoryList.iterator();
                while (iterator.hasNext() && !(rest = ItemHandlerHelper.insertItem((IItemHandler)(itemHandler = (inventory = (AbstractStatueBlockEntity.BiggestInventory)iterator.next()).getIItemHandler(this.f_58857_)), (ItemStack)stack, (boolean)false)).m_41619_()) {
                }
            }
        } else {
            this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_(), stack));
        }
    }

    public void killMob(ServerLevel serverLevel) {
        BlockPos pos = this.m_58899_();
        if (this.hitbox == null) {
            this.hitbox = new AABB((double)((float)pos.m_123341_() - 0.5f), (double)((float)pos.m_123342_() - 0.5f), (double)((float)pos.m_123343_() - 0.5f), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f)).m_82377_(-12.0, -12.0, -12.0).m_82377_(12.0, 12.0, 12.0);
        }
        List<LivingEntity> targetList = this.f_58857_.m_45976_(LivingEntity.class, this.hitbox).stream().filter(entity -> entity.m_6095_().equals(this.getStatue().getEntity()) && !(entity instanceof FakePlayer)).toList();
        int killerLevel = this.getUpgradeLevel("mob_killer");
        for (LivingEntity target : targetList) {
            if (killerLevel > 1) {
                ItemStack tempSword = new ItemStack((ItemLike)Items.f_42388_, 1);
                StatueFakePlayer.useFakePlayer(serverLevel, fakePlayer -> {
                    fakePlayer.m_21008_(InteractionHand.MAIN_HAND, tempSword);
                    target.m_6469_(DamageSource.m_19344_((Player)fakePlayer), (float)fakePlayer.m_21133_(Attributes.f_22281_));
                    return true;
                });
                continue;
            }
            target.m_6469_(DamageSource.f_19318_, 6.0f);
        }
    }

    public void summonMob(ServerLevel serverLevel) {
        BlockPos pos = this.m_58899_();
        int spawnerLevel = this.getSpawnerLevel() + 1;
        boolean screwTheRulesIHasMoney = spawnerLevel > 3;
        int spawnCount = serverLevel.f_46441_.m_188503_(spawnerLevel) + 1;
        EntityType<?> entityType = this.getStatue().getEntity();
        for (int i = 0; i < spawnCount; ++i) {
            Entity entity;
            BlockPos blockpos;
            double d2;
            double d1;
            double d0 = (double)pos.m_123341_() + (serverLevel.f_46441_.m_188500_() - serverLevel.f_46441_.m_188500_()) * 4.0 + 0.5;
            if (!serverLevel.m_45772_(entityType.m_20585_(d0, d1 = (double)(pos.m_123342_() + serverLevel.f_46441_.m_188503_(3) - 1), d2 = (double)pos.m_123343_() + (serverLevel.f_46441_.m_188500_() - serverLevel.f_46441_.m_188500_()) * 4.0 + 0.5)) || !serverLevel.isAreaLoaded(blockpos = new BlockPos(d0, d1, d2), 1) || !screwTheRulesIHasMoney && !SpawnPlacements.m_217074_(entityType, (ServerLevelAccessor)serverLevel, (MobSpawnType)MobSpawnType.SPAWNER, (BlockPos)blockpos, (RandomSource)serverLevel.m_213780_()) || (entity = entityType.m_20615_(this.f_58857_)) == null) continue;
            entity.m_7678_(d0, d1, d2, entity.m_146908_(), entity.m_146909_());
            int k = serverLevel.m_45976_(entity.getClass(), new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1)).m_82400_(4.0)).size();
            if (k >= 6 + spawnerLevel) continue;
            entity.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.f_58857_.f_46441_.m_188501_() * 360.0f, 0.0f);
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                this.getStatue().adjustSpawnedEntity((LivingEntity)mob);
                Event.Result res = ForgeEventFactory.canEntitySpawn((Mob)mob, (LevelAccessor)serverLevel, (double)((float)entity.m_20185_()), (double)((float)entity.m_20186_()), (double)((float)entity.m_20189_()), null, (MobSpawnType)MobSpawnType.SPAWNER);
                if (res == Event.Result.DENY || res == Event.Result.DEFAULT && (!screwTheRulesIHasMoney && !mob.m_5545_((LevelAccessor)serverLevel, MobSpawnType.SPAWNER) || !mob.m_6914_((LevelReader)serverLevel))) continue;
                if (!ForgeEventFactory.doSpecialSpawn((Mob)mob, (LevelAccessor)serverLevel, (float)((float)entity.m_20185_()), (float)((float)entity.m_20186_()), (float)((float)entity.m_20189_()), null, (MobSpawnType)MobSpawnType.SPAWNER)) {
                    ((Mob)entity).m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(entity.m_20183_()), MobSpawnType.SPAWNER, (SpawnGroupData)null, (CompoundTag)null);
                }
            }
            if (!serverLevel.m_8860_(entity)) continue;
            serverLevel.m_46796_(2004, pos, 0);
            serverLevel.m_142346_(entity, GameEvent.f_157810_, blockpos);
            if (!(entity instanceof Mob)) continue;
            ((Mob)entity).m_21373_();
        }
    }

    public void floodBehavior(Player playerIn, BlockPos pos, InteractionHand hand, float hitX, float hitY, float hitZ) {
        if (this.hasSpecialInteraction() && this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ItemStack stack = playerIn.m_21120_(hand);
            int random = this.f_58857_.f_46441_.m_188503_(100);
            if (stack.m_41720_() == Items.f_42446_ && !playerIn.m_150110_().f_35937_) {
                this.f_58857_.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                stack.m_41774_(1);
                ItemStack floodBucket = LootHelper.getFloodBucket();
                if (stack.m_41619_()) {
                    playerIn.m_21008_(hand, floodBucket);
                } else if (!playerIn.m_150109_().m_36054_(floodBucket)) {
                    playerIn.m_36176_(floodBucket, false);
                }
            }
            if (random < 50) {
                FireworkRocketEntity firework = new FireworkRocketEntity(this.f_58857_, (double)((float)pos.m_123341_() + hitX), (double)((float)pos.m_123342_() + hitY), (double)((float)pos.m_123343_() + hitZ), this.getFirework(this.f_58857_.f_46441_));
                this.f_58857_.m_7967_((Entity)firework);
            }
        }
    }

    public void mooshroomBehavior(Player playerIn, BlockPos pos, InteractionHand hand) {
        ItemStack stack;
        if (this.hasSpecialInteraction() && this.f_58857_ != null && !this.f_58857_.f_46443_ && (stack = playerIn.m_21120_(hand)).m_41720_() == Items.f_42399_ && !playerIn.m_150110_().f_35937_) {
            this.f_58857_.m_5594_(null, pos, SoundEvents.f_11833_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            stack.m_41774_(1);
            ItemStack soupStack = new ItemStack((ItemLike)StatueRegistry.SOUP.get());
            if (stack.m_41619_()) {
                playerIn.m_21008_(hand, soupStack);
            } else if (!playerIn.m_150109_().m_36054_(soupStack)) {
                playerIn.m_36176_(soupStack, false);
            }
        }
    }

    public void cowBehavior(Player playerIn, BlockPos pos, InteractionHand hand) {
        ItemStack stack;
        if (this.hasSpecialInteraction() && this.f_58857_ != null && !this.f_58857_.f_46443_ && (stack = playerIn.m_21120_(hand)).m_41720_() == Items.f_42446_ && !playerIn.m_150110_().f_35937_) {
            this.f_58857_.m_5594_(null, pos, SoundEvents.f_11833_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            stack.m_41774_(1);
            if (stack.m_41619_()) {
                playerIn.m_21008_(hand, new ItemStack((ItemLike)Items.f_42455_));
            } else if (!playerIn.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42455_))) {
                playerIn.m_36176_(new ItemStack((ItemLike)Items.f_42455_), false);
            }
        }
    }

    public void giveEffect(Player player, BlockPos pos, MobEffect effect) {
        if (this.hasSpecialInteraction() && this.f_58857_ != null && !this.f_58857_.f_46443_ && this.f_58857_.f_46441_.m_188500_() <= (double)0.1f && player.m_21124_(effect) == null) {
            player.m_7292_(new MobEffectInstance(effect, 400, 1, true, true));
        }
    }
}

