/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blockentities;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.shynieke.statues.blocks.statues.PlayerStatueBlock;
import com.shynieke.statues.registry.StatueBlockEntities;
import com.shynieke.statues.registry.StatueRegistry;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.Services;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.util.StringUtil;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PlayerBlockEntity
extends BlockEntity
implements Nameable {
    @Nullable
    private static GameProfileCache profileCache;
    @Nullable
    private static MinecraftSessionService sessionService;
    @Nullable
    private static Executor mainThreadExecutor;
    private GameProfile playerProfile;
    private boolean isSlim = false;
    private boolean comparatorApplied = false;
    private boolean onlineChecking = false;
    private int checkerCooldown = 0;

    public PlayerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)StatueBlockEntities.PLAYER.get(), pos, state);
    }

    public static void setup(GameProfileCache gameProfileCache, MinecraftSessionService service, Executor executor) {
        profileCache = gameProfileCache;
        sessionService = service;
        mainThreadExecutor = executor;
    }

    public static void setup(Services services, Executor executor) {
        PlayerBlockEntity.setup(services.f_214336_(), services.f_214333_(), executor);
    }

    public static void clear() {
        profileCache = null;
        sessionService = null;
        mainThreadExecutor = null;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128425_("PlayerProfile", 10)) {
            this.setPlayerProfile(NbtUtils.m_129228_((CompoundTag)compound.m_128469_("PlayerProfile")));
        }
        this.comparatorApplied = compound.m_128471_("comparatorApplied");
        this.onlineChecking = compound.m_128471_("OnlineChecking");
        this.checkerCooldown = compound.m_128451_("checkerCooldown");
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.playerProfile != null) {
            CompoundTag tag = new CompoundTag();
            NbtUtils.m_129230_((CompoundTag)tag, (GameProfile)this.playerProfile);
            compound.m_128365_("PlayerProfile", (Tag)tag);
        }
        compound.m_128379_("comparatorApplied", this.comparatorApplied);
        compound.m_128379_("OnlineChecking", this.onlineChecking);
        compound.m_128405_("checkerCooldown", this.checkerCooldown);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag compoundNBT = pkt.m_131708_();
        this.handleUpdateTag(compoundNBT);
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public CompoundTag getPersistentData() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public boolean m_8077_() {
        return this.playerProfile != null && !this.playerProfile.getName().isEmpty();
    }

    @Nullable
    public GameProfile getPlayerProfile() {
        return this.playerProfile;
    }

    public boolean isSlim() {
        return this.isSlim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayerProfile(@Nullable GameProfile profile) {
        PlayerBlockEntity playerBlockEntity = this;
        synchronized (playerBlockEntity) {
            this.playerProfile = profile;
            if (this.f_58857_ != null && this.f_58857_.f_46443_ && this.playerProfile != null && this.playerProfile.isComplete()) {
                Minecraft.m_91087_().m_91109_().m_118817_(this.playerProfile, (textureType, textureLocation, profileTexture) -> {
                    if (textureType.equals((Object)MinecraftProfileTexture.Type.SKIN)) {
                        String metadata = profileTexture.getMetadata("model");
                        this.isSlim = metadata != null && metadata.equals("slim");
                    }
                }, true);
            }
        }
        this.updateOwnerProfile();
    }

    private void updateOwnerProfile() {
        PlayerBlockEntity.updateGameprofile(this.playerProfile, profile -> {
            this.playerProfile = profile;
            this.m_6596_();
        });
    }

    @Nullable
    public static void updateGameprofile(@Nullable GameProfile profile, Consumer<GameProfile> profileConsumer) {
        if (!(profile == null || StringUtil.m_14408_((String)profile.getName()) || profile.isComplete() && profile.getProperties().containsKey((Object)"textures") || profileCache == null || sessionService == null)) {
            profileCache.m_143967_(profile.getName(), gameProfile -> Util.m_183991_().execute(() -> Util.m_137521_((Optional)gameProfile, gameProfile1 -> {
                com.mojang.authlib.properties.Property property = (com.mojang.authlib.properties.Property)Iterables.getFirst((Iterable)gameProfile1.getProperties().get((Object)"textures"), (Object)null);
                if (property == null) {
                    gameProfile1 = sessionService.fillProfileProperties(gameProfile1, true);
                }
                GameProfile gameprofile = gameProfile1;
                mainThreadExecutor.execute(() -> {
                    profileCache.m_10991_(gameprofile);
                    profileConsumer.accept(gameprofile);
                });
            }, () -> mainThreadExecutor.execute(() -> profileConsumer.accept(profile)))));
        } else {
            profileConsumer.accept(profile);
        }
    }

    public void updateOnline() {
        boolean checkAnswer;
        BlockState state = this.m_58900_();
        boolean isStateOnline = (Boolean)state.m_61143_((Property)PlayerStatueBlock.ONLINE);
        boolean bl = checkAnswer = this.f_58857_.m_46003_(this.playerProfile.getId()) != null;
        if (isStateOnline != checkAnswer) {
            BlockState newState = (BlockState)state.m_61124_((Property)PlayerStatueBlock.ONLINE, (Comparable)Boolean.valueOf(checkAnswer));
            this.f_58857_.m_46597_(this.m_58899_(), newState);
            this.f_58857_.m_7260_(this.m_58899_(), state, newState, 3);
        }
    }

    public void setComparatorApplied(boolean comparatorApplied) {
        this.comparatorApplied = comparatorApplied;
        if (!comparatorApplied) {
            BlockState state = this.m_58900_();
            BlockState newState = (BlockState)state.m_61124_((Property)PlayerStatueBlock.ONLINE, (Comparable)Boolean.valueOf(false));
            this.f_58857_.m_46597_(this.m_58899_(), newState);
            this.f_58857_.m_7260_(this.m_58899_(), state, newState, 3);
        }
        this.m_6596_();
    }

    public boolean getComparatorApplied() {
        return this.comparatorApplied;
    }

    public int getCooldown() {
        return this.checkerCooldown;
    }

    public void setOnlineChecking(boolean onlineChecking) {
        this.onlineChecking = onlineChecking;
        this.m_6596_();
    }

    public Component m_7755_() {
        return this.m_8077_() ? Component.m_237113_((String)(this.playerProfile != null ? this.playerProfile.getName() : "")) : Component.m_237115_((String)"statue.player");
    }

    @Nullable
    public Component m_7770_() {
        return null;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, PlayerBlockEntity blockEntity) {
        if (level != null && state.m_60713_((Block)StatueRegistry.PLAYER_STATUE.get()) && blockEntity.comparatorApplied) {
            if (!blockEntity.onlineChecking) {
                ++blockEntity.checkerCooldown;
                blockEntity.m_6596_();
                if (blockEntity.checkerCooldown == 0) {
                    blockEntity.checkerCooldown = 200;
                }
                if (blockEntity.checkerCooldown >= 200) {
                    blockEntity.checkerCooldown = 0;
                    blockEntity.setOnlineChecking(true);
                }
            } else {
                blockEntity.updateOnline();
                blockEntity.setOnlineChecking(false);
            }
        }
    }
}

