/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.deep.AbstractDeepEditorElement;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.HideableElement;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.button.vanillawidget.VanillaWidgetEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.button.vanillawidget.VanillaWidgetElementBuilder;
import de.keksuccino.fancymenu.customization.layer.ElementFactory;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layout.Layout;
import de.keksuccino.fancymenu.customization.layout.LayoutHandler;
import de.keksuccino.fancymenu.customization.layout.editor.AnchorPointOverlay;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorHistory;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorUI;
import de.keksuccino.fancymenu.customization.layout.editor.widget.AbstractLayoutEditorWidget;
import de.keksuccino.fancymenu.customization.layout.editor.widget.LayoutEditorWidgetRegistry;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.customization.widget.ScreenWidgetDiscoverer;
import de.keksuccino.fancymenu.customization.widget.WidgetMeta;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinScreen;
import de.keksuccino.fancymenu.util.ListUtils;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.ObjectUtils;
import de.keksuccino.fancymenu.util.ScreenTitleUtils;
import de.keksuccino.fancymenu.util.file.FileUtils;
import de.keksuccino.fancymenu.util.file.type.FileType;
import de.keksuccino.fancymenu.util.file.type.groups.FileTypeGroup;
import de.keksuccino.fancymenu.util.file.type.types.FileTypes;
import de.keksuccino.fancymenu.util.file.type.types.TextFileType;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.contextmenu.v2.ContextMenu;
import de.keksuccino.fancymenu.util.rendering.ui.menubar.v2.MenuBar;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CustomizableScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.NotificationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.filebrowser.SaveFileScreen;
import de.keksuccino.fancymenu.util.rendering.ui.widget.CustomizableWidget;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class LayoutEditorScreen
extends Screen
implements ElementFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final Map<SerializedElement, ElementBuilder<?, ?>> COPIED_ELEMENTS_CLIPBOARD = new LinkedHashMap();
    public static final int ELEMENT_DRAG_CRUMPLE_ZONE = 5;
    @Nullable
    protected static LayoutEditorScreen currentInstance = null;
    @Nullable
    public Screen layoutTargetScreen;
    @NotNull
    public Layout layout;
    public List<AbstractEditorElement> normalEditorElements = new ArrayList<AbstractEditorElement>();
    public List<VanillaWidgetEditorElement> vanillaWidgetEditorElements = new ArrayList<VanillaWidgetEditorElement>();
    public List<AbstractDeepEditorElement> deepEditorElements = new ArrayList<AbstractDeepEditorElement>();
    public LayoutEditorHistory history = new LayoutEditorHistory(this);
    public MenuBar menuBar;
    public AnchorPointOverlay anchorPointOverlay = new AnchorPointOverlay(this);
    public ContextMenu rightClickMenu;
    public ContextMenu activeElementContextMenu = null;
    public List<AbstractLayoutEditorWidget> layoutEditorWidgets = new ArrayList<AbstractLayoutEditorWidget>();
    protected boolean isMouseSelection = false;
    protected int mouseSelectionStartX = 0;
    protected int mouseSelectionStartY = 0;
    public int leftMouseDownPosX = 0;
    public int leftMouseDownPosY = 0;
    protected boolean elementMovingStarted = false;
    protected boolean elementResizingStarted = false;
    protected boolean mouseDraggingStarted = false;
    protected List<AbstractEditorElement> currentlyDraggedElements = new ArrayList<AbstractEditorElement>();
    protected int rightClickMenuOpenPosX = -1000;
    protected int rightClickMenuOpenPosY = -1000;
    protected LayoutEditorHistory.Snapshot preDragElementSnapshot;
    public final List<WidgetMeta> cachedVanillaWidgetMetas = new ArrayList<WidgetMeta>();
    protected boolean addedCalled = false;

    public LayoutEditorScreen(@NotNull Layout layout) {
        this(null, layout);
    }

    public LayoutEditorScreen(@Nullable Screen layoutTargetScreen, @NotNull Layout layout) {
        super((Component)Components.literal(""));
        Component cachedOriTitle;
        this.layoutTargetScreen = layoutTargetScreen;
        layout.updateLastEditedTime();
        layout.saveToFileIfPossible();
        this.layout = layout.copy();
        if (this.layoutTargetScreen != null && (cachedOriTitle = ScreenCustomizationLayer.cachedOriginalMenuTitles.get(this.layoutTargetScreen.getClass())) != null) {
            ScreenTitleUtils.setScreenTitle(this.layoutTargetScreen, cachedOriTitle);
        }
        this.constructElementInstances();
    }

    protected void m_7856_() {
        this.currentlyDraggedElements.clear();
        this.anchorPointOverlay.resetOverlay();
        for (WidgetMeta m : this.cachedVanillaWidgetMetas) {
            AbstractWidget abstractWidget = m.getWidget();
            if (!(abstractWidget instanceof CustomizableWidget)) continue;
            CustomizableWidget w = (CustomizableWidget)abstractWidget;
            w.resetWidgetCustomizationsFancyMenu();
        }
        if (this.layoutEditorWidgets == null || this.layoutEditorWidgets.isEmpty()) {
            this.layoutEditorWidgets = LayoutEditorWidgetRegistry.buildWidgetInstances(this);
        }
        this.closeRightClickMenu();
        this.rightClickMenu = LayoutEditorUI.buildRightClickContextMenu(this);
        this.m_7787_(this.rightClickMenu);
        if (this.menuBar != null) {
            this.menuBar.closeAllContextMenus();
        }
        this.menuBar = LayoutEditorUI.buildMenuBar(this, this.menuBar == null || this.menuBar.isExpanded());
        this.m_7787_(this.menuBar);
        for (AbstractLayoutEditorWidget w : Lists.reverse(new ArrayList<AbstractLayoutEditorWidget>(this.layoutEditorWidgets))) {
            this.m_7787_((GuiEventListener)w);
        }
        this.isMouseSelection = false;
        this.preDragElementSnapshot = null;
        this.closeActiveElementMenu(true);
        this.serializeElementInstancesToLayoutInstance();
        if (this.layout.forcedScale != 0.0f) {
            WidgetMeta m;
            float newscale = this.layout.forcedScale;
            if (newscale <= 0.0f) {
                newscale = 1.0f;
            }
            m = Minecraft.m_91087_().m_91268_();
            m.m_85378_(newscale);
            this.f_96543_ = m.m_85445_();
            this.f_96544_ = m.m_85446_();
        }
        if (this.layout.autoScalingWidth != 0 && this.layout.autoScalingHeight != 0) {
            Window m = Minecraft.m_91087_().m_91268_();
            double guiWidth = (double)this.f_96543_ * m.m_85449_();
            double guiHeight = (double)this.f_96544_ * m.m_85449_();
            double percentX = guiWidth / (double)this.layout.autoScalingWidth * 100.0;
            double percentY = guiHeight / (double)this.layout.autoScalingHeight * 100.0;
            double newScaleX = percentX / 100.0 * m.m_85449_();
            double newScaleY = percentY / 100.0 * m.m_85449_();
            double newScale = Math.min(newScaleX, newScaleY);
            m.m_85378_(newScale);
            this.f_96543_ = m.m_85445_();
            this.f_96544_ = m.m_85446_();
        }
        this.constructElementInstances();
        for (AbstractLayoutEditorWidget w : this.layoutEditorWidgets) {
            w.refresh();
        }
        if (!this.addedCalled) {
            this.added();
        }
        this.addedCalled = true;
    }

    public boolean m_6913_() {
        return false;
    }

    public void m_86600_() {
        for (AbstractLayoutEditorWidget w : this.layoutEditorWidgets) {
            w.tick();
        }
        for (AbstractEditorElement e : this.getAllElements()) {
            e.element.tick();
        }
        if (this.layout.menuBackground != null) {
            this.layout.menuBackground.tick();
        }
    }

    public void m_7861_() {
        for (AbstractEditorElement e : this.getAllElements()) {
            e.element.onCloseScreen();
        }
        if (this.layout.menuBackground != null) {
            this.layout.menuBackground.onCloseScreen();
        }
    }

    public void added() {
        for (AbstractEditorElement e : this.getAllElements()) {
            e.element.onOpenScreen();
        }
        if (this.layout.menuBackground != null) {
            this.layout.menuBackground.onOpenScreen();
        }
    }

    public void m_6305_(@NotNull PoseStack pose, int mouseX, int mouseY, float partial) {
        if (this.activeElementContextMenu != null && !this.activeElementContextMenu.isOpen()) {
            this.activeElementContextMenu = null;
        }
        this.renderBackground(pose, mouseX, mouseY, partial);
        this.renderElements(pose, mouseX, mouseY, partial);
        this.renderMouseSelectionRectangle(pose, mouseX, mouseY);
        this.anchorPointOverlay.m_6305_(pose, mouseX, mouseY, partial);
        this.renderLayoutEditorWidgets(pose, mouseX, mouseY, partial);
        this.menuBar.m_6305_(pose, mouseX, mouseY, partial);
        this.rightClickMenu.m_6305_(pose, mouseX, mouseY, partial);
        if (this.activeElementContextMenu != null) {
            this.activeElementContextMenu.m_6305_(pose, mouseX, mouseY, partial);
        }
    }

    protected void renderLayoutEditorWidgets(PoseStack pose, int mouseX, int mouseY, float partial) {
        for (AbstractLayoutEditorWidget w : this.layoutEditorWidgets) {
            if (!w.isVisible()) continue;
            w.m_6305_(pose, mouseX, mouseY, partial);
        }
    }

    protected void renderMouseSelectionRectangle(PoseStack pose, int mouseX, int mouseY) {
        if (this.isMouseSelection) {
            int startX = Math.min(this.mouseSelectionStartX, mouseX);
            int startY = Math.min(this.mouseSelectionStartY, mouseY);
            int endX = Math.max(this.mouseSelectionStartX, mouseX);
            int endY = Math.max(this.mouseSelectionStartY, mouseY);
            LayoutEditorScreen.m_93172_((PoseStack)pose, (int)startX, (int)startY, (int)endX, (int)endY, (int)RenderingUtils.replaceAlphaInColor(UIBase.getUIColorTheme().layout_editor_mouse_selection_rectangle_color.getColorInt(), 70));
            UIBase.renderBorder(pose, startX, startY, endX, endY, 1, UIBase.getUIColorTheme().layout_editor_mouse_selection_rectangle_color.getColor(), true, true, true, true);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected void renderElements(PoseStack pose, int mouseX, int mouseY, float partial) {
        if (this.layout.renderElementsBehindVanilla) {
            for (AbstractEditorElement abstractEditorElement : new ArrayList<AbstractEditorElement>(this.normalEditorElements)) {
                if (abstractEditorElement.isSelected()) continue;
                abstractEditorElement.m_6305_(pose, mouseX, mouseY, partial);
            }
        }
        for (VanillaWidgetEditorElement vanillaWidgetEditorElement : new ArrayList<VanillaWidgetEditorElement>(this.vanillaWidgetEditorElements)) {
            if (vanillaWidgetEditorElement.isSelected() || vanillaWidgetEditorElement.isHidden()) continue;
            vanillaWidgetEditorElement.m_6305_(pose, mouseX, mouseY, partial);
        }
        for (AbstractDeepEditorElement abstractDeepEditorElement : new ArrayList<AbstractDeepEditorElement>(this.deepEditorElements)) {
            if (abstractDeepEditorElement.isSelected() || abstractDeepEditorElement.isHidden()) continue;
            abstractDeepEditorElement.m_6305_(pose, mouseX, mouseY, partial);
        }
        if (!this.layout.renderElementsBehindVanilla) {
            for (AbstractEditorElement abstractEditorElement : new ArrayList<AbstractEditorElement>(this.normalEditorElements)) {
                if (abstractEditorElement.isSelected()) continue;
                abstractEditorElement.m_6305_(pose, mouseX, mouseY, partial);
            }
        }
        List<AbstractEditorElement> selected = this.getSelectedElements();
        for (AbstractEditorElement e : selected) {
            e.m_6305_(pose, mouseX, mouseY, partial);
        }
    }

    protected void renderBackground(PoseStack pose, int mouseX, int mouseY, float partial) {
        LayoutEditorScreen.m_93172_((PoseStack)pose, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)UIBase.getUIColorTheme().screen_background_color_darker.getColorInt());
        if (this.layout.menuBackground != null) {
            this.layout.menuBackground.keepBackgroundAspectRatio = this.layout.preserveBackgroundAspectRatio;
            this.layout.menuBackground.opacity = 1.0f;
            this.layout.menuBackground.m_6305_(pose, mouseX, mouseY, partial);
        }
        this.renderScrollListHeaderFooterPreview(pose, mouseX, mouseY, partial);
        this.renderGrid(pose);
    }

    protected void renderScrollListHeaderFooterPreview(PoseStack pose, int mouseX, int mouseY, float partial) {
        if (this.layout.showScrollListHeaderFooterPreviewInEditor) {
            ResourceLocation loc;
            ITexture footerTexture;
            int x0 = 0;
            int x1 = this.f_96543_;
            int y0 = 48;
            int y1 = this.f_96544_ - 64;
            ITexture headerTexture = this.layout.scrollListHeaderTexture != null ? (ITexture)this.layout.scrollListHeaderTexture.get() : null;
            ITexture iTexture = footerTexture = this.layout.scrollListFooterTexture != null ? (ITexture)this.layout.scrollListFooterTexture.get() : null;
            if (headerTexture != null) {
                loc = headerTexture.getResourceLocation();
                if (loc != null) {
                    RenderingUtils.bindTexture(loc);
                    RenderingUtils.resetShaderColor();
                    if (this.layout.preserveScrollListHeaderFooterAspectRatio) {
                        int[] headerSize = headerTexture.getAspectRatio().getAspectRatioSizeByMinimumSize(this.f_96543_, y0);
                        int headerWidth = headerSize[0];
                        int headerHeight = headerSize[1];
                        int headerX = x0 + this.f_96543_ / 2 - headerWidth / 2;
                        int headerY = y0 / 2 - headerHeight / 2;
                        RenderingUtils.m_239260_(x0, 0, x0 + this.f_96543_, y0);
                        LayoutEditorScreen.m_93133_((PoseStack)pose, (int)headerX, (int)headerY, (float)0.0f, (float)0.0f, (int)headerWidth, (int)headerHeight, (int)headerWidth, (int)headerHeight);
                        RenderingUtils.m_240060_();
                    } else if (this.layout.repeatScrollListHeaderTexture) {
                        RenderingUtils.blitRepeat(pose, x0, 0, this.f_96543_, y0, headerTexture.getWidth(), headerTexture.getHeight());
                    } else {
                        LayoutEditorScreen.m_93133_((PoseStack)pose, (int)x0, (int)0, (float)0.0f, (float)0.0f, (int)this.f_96543_, (int)y0, (int)this.f_96543_, (int)y0);
                    }
                }
            } else {
                RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93096_);
                RenderSystem.m_157429_((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
                LayoutEditorScreen.m_93133_((PoseStack)pose, (int)x0, (int)0, (float)0.0f, (float)0.0f, (int)this.f_96543_, (int)y0, (int)32, (int)32);
            }
            if (footerTexture != null) {
                loc = footerTexture.getResourceLocation();
                if (loc != null) {
                    RenderingUtils.bindTexture(loc);
                    RenderingUtils.resetShaderColor();
                    if (this.layout.preserveScrollListHeaderFooterAspectRatio) {
                        int footerOriginalHeight = this.f_96544_ - y1;
                        int[] footerSize = footerTexture.getAspectRatio().getAspectRatioSizeByMinimumSize(this.f_96543_, footerOriginalHeight);
                        int footerWidth = footerSize[0];
                        int footerHeight = footerSize[1];
                        int footerX = x0 + this.f_96543_ / 2 - footerWidth / 2;
                        int footerY = y1 + footerOriginalHeight / 2 - footerHeight / 2;
                        RenderingUtils.m_239260_(x0, y1, x0 + this.f_96543_, y1 + footerOriginalHeight);
                        LayoutEditorScreen.m_93133_((PoseStack)pose, (int)footerX, (int)footerY, (float)0.0f, (float)0.0f, (int)footerWidth, (int)footerHeight, (int)footerWidth, (int)footerHeight);
                        RenderingUtils.m_240060_();
                    } else if (this.layout.repeatScrollListFooterTexture) {
                        int footerHeight = this.f_96544_ - y1;
                        RenderingUtils.blitRepeat(pose, x0, y1, this.f_96543_, footerHeight, footerTexture.getWidth(), footerTexture.getHeight());
                    } else {
                        int footerHeight = this.f_96544_ - y1;
                        LayoutEditorScreen.m_93133_((PoseStack)pose, (int)x0, (int)y1, (float)0.0f, (float)0.0f, (int)this.f_96543_, (int)footerHeight, (int)this.f_96543_, (int)footerHeight);
                    }
                }
            } else {
                RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93096_);
                RenderSystem.m_157429_((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
                LayoutEditorScreen.m_93133_((PoseStack)pose, (int)x0, (int)y1, (float)0.0f, (float)y1, (int)this.f_96543_, (int)(this.f_96544_ - y1), (int)32, (int)32);
            }
            RenderingUtils.resetShaderColor();
            if (this.layout.renderScrollListHeaderShadow) {
                this.m_93179_(pose, x0, y0, x1, y0 + 4, -16777216, 0);
            }
            if (this.layout.renderScrollListFooterShadow) {
                this.m_93179_(pose, x0, y1 - 4, x1, y1, 0, -16777216);
            }
            RenderingUtils.resetShaderColor();
        }
    }

    protected void renderGrid(@NotNull PoseStack pose) {
        if (FancyMenu.getOptions().showLayoutEditorGrid.getValue().booleanValue()) {
            int maxX;
            float scale = UIBase.calculateFixedScale(1.0f);
            int scaledWidth = (int)((float)this.f_96543_ / scale);
            int scaledHeight = (int)((float)this.f_96544_ / scale);
            pose.m_85836_();
            pose.m_85841_(scale, scale, scale);
            int gridSize = FancyMenu.getOptions().layoutEditorGridSize.getValue();
            int lineThickness = 1;
            LayoutEditorScreen.m_93172_((PoseStack)pose, (int)(scaledWidth / 2 - 1), (int)0, (int)(scaledWidth / 2 + 1), (int)scaledHeight, (int)UIBase.getUIColorTheme().layout_editor_grid_color_center.getColorInt());
            for (int linesVerticalToLeftPosX = scaledWidth / 2 - gridSize - 1; linesVerticalToLeftPosX > 0; linesVerticalToLeftPosX -= gridSize) {
                int minY = 0;
                int maxY = scaledHeight;
                int maxX2 = linesVerticalToLeftPosX + lineThickness;
                LayoutEditorScreen.m_93172_((PoseStack)pose, (int)linesVerticalToLeftPosX, (int)minY, (int)maxX2, (int)maxY, (int)UIBase.getUIColorTheme().layout_editor_grid_color_normal.getColorInt());
            }
            for (int linesVerticalToRightPosX = scaledWidth / 2 + gridSize; linesVerticalToRightPosX < scaledWidth; linesVerticalToRightPosX += gridSize) {
                int minY = 0;
                int maxY = scaledHeight;
                maxX = linesVerticalToRightPosX + lineThickness;
                LayoutEditorScreen.m_93172_((PoseStack)pose, (int)linesVerticalToRightPosX, (int)minY, (int)maxX, (int)maxY, (int)UIBase.getUIColorTheme().layout_editor_grid_color_normal.getColorInt());
            }
            LayoutEditorScreen.m_93172_((PoseStack)pose, (int)0, (int)(scaledHeight / 2 - 1), (int)scaledWidth, (int)(scaledHeight / 2 + 1), (int)UIBase.getUIColorTheme().layout_editor_grid_color_center.getColorInt());
            for (int linesHorizontalToTopPosY = scaledHeight / 2 - gridSize - 1; linesHorizontalToTopPosY > 0; linesHorizontalToTopPosY -= gridSize) {
                int minX = 0;
                maxX = scaledWidth;
                int maxY = linesHorizontalToTopPosY + lineThickness;
                LayoutEditorScreen.m_93172_((PoseStack)pose, (int)minX, (int)linesHorizontalToTopPosY, (int)maxX, (int)maxY, (int)UIBase.getUIColorTheme().layout_editor_grid_color_normal.getColorInt());
            }
            for (int linesHorizontalToBottomPosY = scaledHeight / 2 + gridSize; linesHorizontalToBottomPosY < scaledHeight; linesHorizontalToBottomPosY += gridSize) {
                int minX = 0;
                int maxX3 = scaledWidth;
                int maxY = linesHorizontalToBottomPosY + lineThickness;
                LayoutEditorScreen.m_93172_((PoseStack)pose, (int)minX, (int)linesHorizontalToBottomPosY, (int)maxX3, (int)maxY, (int)UIBase.getUIColorTheme().layout_editor_grid_color_normal.getColorInt());
            }
            pose.m_85849_();
        }
    }

    protected void constructElementInstances() {
        Object editorElement;
        for (AbstractEditorElement e : this.getAllElements()) {
            e.resetElementStates();
        }
        this.normalEditorElements.clear();
        this.vanillaWidgetEditorElements.clear();
        this.deepEditorElements.clear();
        Layout.OrderedElementCollection normalElements = new Layout.OrderedElementCollection();
        ArrayList vanillaWidgetElements = this.layoutTargetScreen != null ? new ArrayList() : null;
        ArrayList deepElements = this.layoutTargetScreen != null ? new ArrayList() : null;
        this.cachedVanillaWidgetMetas.clear();
        if (this.layoutTargetScreen != null) {
            this.cachedVanillaWidgetMetas.addAll(ScreenWidgetDiscoverer.getWidgetsOfScreen(this.layoutTargetScreen, true));
        }
        for (WidgetMeta m : this.cachedVanillaWidgetMetas) {
            AbstractWidget abstractWidget = m.getWidget();
            if (!(abstractWidget instanceof CustomizableWidget)) continue;
            CustomizableWidget w = (CustomizableWidget)abstractWidget;
            w.resetWidgetCustomizationsFancyMenu();
        }
        this.constructElementInstances(this.layout.screenIdentifier, this.cachedVanillaWidgetMetas, this.layout, normalElements, vanillaWidgetElements, deepElements);
        for (AbstractElement e : ListUtils.mergeLists(normalElements.backgroundElements, normalElements.foregroundElements)) {
            editorElement = e.builder.wrapIntoEditorElementInternal(e, this);
            if (editorElement == null) continue;
            this.normalEditorElements.add((AbstractEditorElement)((Object)editorElement));
        }
        if (deepElements != null) {
            for (AbstractElement e : deepElements) {
                editorElement = e.builder.wrapIntoEditorElementInternal(e, this);
                if (!(editorElement instanceof AbstractDeepEditorElement)) continue;
                AbstractDeepEditorElement d = (AbstractDeepEditorElement)editorElement;
                this.deepEditorElements.add(d);
            }
        }
        if (vanillaWidgetElements != null) {
            for (AbstractElement e : vanillaWidgetElements) {
                editorElement = (VanillaWidgetEditorElement)VanillaWidgetElementBuilder.INSTANCE.wrapIntoEditorElementInternal(e, this);
                if (editorElement == null) continue;
                this.vanillaWidgetEditorElements.add((VanillaWidgetEditorElement)editorElement);
            }
        }
    }

    protected void serializeElementInstancesToLayoutInstance() {
        SerializedElement serialized;
        this.layout.serializedElements.clear();
        this.layout.serializedVanillaButtonElements.clear();
        this.layout.serializedDeepElements.clear();
        for (AbstractEditorElement abstractEditorElement : this.normalEditorElements) {
            serialized = abstractEditorElement.element.builder.serializeElementInternal(abstractEditorElement.element);
            if (serialized == null) continue;
            this.layout.serializedElements.add(serialized);
        }
        for (AbstractEditorElement abstractEditorElement : this.deepEditorElements) {
            serialized = abstractEditorElement.element.builder.serializeElementInternal(abstractEditorElement.element);
            if (serialized == null) continue;
            this.layout.serializedDeepElements.add(serialized);
        }
        for (VanillaWidgetEditorElement vanillaWidgetEditorElement : this.vanillaWidgetEditorElements) {
            serialized = VanillaWidgetElementBuilder.INSTANCE.serializeElementInternal(vanillaWidgetEditorElement.element);
            if (serialized == null) continue;
            this.layout.serializedVanillaButtonElements.add(serialized);
        }
    }

    @NotNull
    public List<AbstractEditorElement> getAllElements() {
        ArrayList<AbstractEditorElement> elements = new ArrayList<AbstractEditorElement>();
        ArrayList<AbstractEditorElement> selected = new ArrayList<AbstractEditorElement>();
        ArrayList<AbstractEditorElement> elementsFinal = new ArrayList<AbstractEditorElement>();
        if (this.layout.renderElementsBehindVanilla) {
            elements.addAll(this.normalEditorElements);
        }
        elements.addAll(this.vanillaWidgetEditorElements);
        elements.addAll(this.deepEditorElements);
        if (!this.layout.renderElementsBehindVanilla) {
            elements.addAll(this.normalEditorElements);
        }
        for (AbstractEditorElement e : elements) {
            if (!e.isSelected()) {
                elementsFinal.add(e);
                continue;
            }
            selected.add(e);
        }
        elementsFinal.addAll(selected);
        return elementsFinal;
    }

    @NotNull
    public List<AbstractEditorElement> getHoveredElements() {
        ArrayList<AbstractEditorElement> elements = new ArrayList<AbstractEditorElement>();
        for (AbstractEditorElement e : this.getAllElements()) {
            HideableElement h;
            boolean hidden;
            if (!e.isHovered() || (hidden = e instanceof HideableElement && (h = (HideableElement)((Object)e)).isHidden())) continue;
            elements.add(e);
        }
        return elements;
    }

    @Nullable
    public AbstractEditorElement getTopHoveredElement() {
        List<AbstractEditorElement> hoveredElements = this.getHoveredElements();
        return hoveredElements.size() > 0 ? hoveredElements.get(hoveredElements.size() - 1) : null;
    }

    @NotNull
    public List<AbstractEditorElement> getSelectedElements() {
        ArrayList<AbstractEditorElement> l = new ArrayList<AbstractEditorElement>();
        this.getAllElements().forEach(element -> {
            if (element.isSelected()) {
                l.add((AbstractEditorElement)((Object)element));
            }
        });
        return l;
    }

    @NotNull
    protected <E extends AbstractEditorElement> List<E> getSelectedElementsOfType(@NotNull Class<E> type) {
        ArrayList<AbstractEditorElement> l = new ArrayList<AbstractEditorElement>();
        for (AbstractEditorElement e : this.getSelectedElements()) {
            if (!type.isAssignableFrom(((Object)((Object)e)).getClass())) continue;
            l.add(e);
        }
        return l;
    }

    @Nullable
    public AbstractEditorElement getElementByInstanceIdentifier(@NotNull String instanceIdentifier) {
        instanceIdentifier = instanceIdentifier.replace("vanillabtn:", "").replace("button_compatibility_id:", "");
        for (AbstractEditorElement e : this.getAllElements()) {
            if (!e.element.getInstanceIdentifier().equals(instanceIdentifier)) continue;
            return e;
        }
        return null;
    }

    public void selectAllElements() {
        for (AbstractEditorElement e : this.getAllElements()) {
            e.setSelected(true);
        }
    }

    public void deselectAllElements() {
        for (AbstractEditorElement e : this.getAllElements()) {
            e.setSelected(false);
        }
    }

    public boolean deleteElement(@NotNull AbstractEditorElement element) {
        if (element.settings.isDestroyable()) {
            if (!element.settings.shouldHideInsteadOfDestroy()) {
                this.normalEditorElements.remove((Object)element);
                this.vanillaWidgetEditorElements.remove((Object)element);
                this.deepEditorElements.remove((Object)element);
                for (AbstractLayoutEditorWidget w : this.layoutEditorWidgets) {
                    w.editorElementRemovedOrHidden(element);
                }
                return true;
            }
            if (element instanceof HideableElement) {
                HideableElement hideable = (HideableElement)((Object)element);
                hideable.setHidden(true);
                return true;
            }
        }
        return false;
    }

    protected boolean isElementOverlappingArea(@NotNull AbstractEditorElement element, int xStart, int yStart, int xEnd, int yEnd) {
        int elementStartX = element.getX();
        int elementStartY = element.getY();
        int elementEndX = element.getX() + element.getWidth();
        int elementEndY = element.getY() + element.getHeight();
        return xEnd > elementStartX && yEnd > elementStartY && yStart < elementEndY && xStart < elementEndX;
    }

    public boolean allSelectedElementsMovable() {
        for (AbstractEditorElement e : this.getSelectedElements()) {
            if (e.settings.isMovable()) continue;
            return false;
        }
        return true;
    }

    public boolean canMoveLayerUp(AbstractEditorElement element) {
        int index = this.normalEditorElements.indexOf((Object)element);
        if (index == -1) {
            return false;
        }
        return index < this.normalEditorElements.size() - 1;
    }

    public boolean canMoveLayerDown(AbstractEditorElement element) {
        int index = this.normalEditorElements.indexOf((Object)element);
        return index > 0;
    }

    @Nullable
    public AbstractEditorElement moveLayerUp(@NotNull AbstractEditorElement element) {
        AbstractEditorElement movedAbove = null;
        try {
            if (this.normalEditorElements.contains((Object)element)) {
                ArrayList<AbstractEditorElement> newNormalEditorElements = new ArrayList<AbstractEditorElement>();
                int index = this.normalEditorElements.indexOf((Object)element);
                int i = 0;
                if (index < this.normalEditorElements.size() - 1) {
                    for (AbstractEditorElement e : this.normalEditorElements) {
                        if (e != element) {
                            newNormalEditorElements.add(e);
                            if (i == index + 1) {
                                movedAbove = e;
                                newNormalEditorElements.add(element);
                            }
                        }
                        ++i;
                    }
                    this.normalEditorElements = newNormalEditorElements;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return movedAbove;
    }

    @Nullable
    public AbstractEditorElement moveLayerDown(AbstractEditorElement element) {
        AbstractEditorElement movedBehind = null;
        try {
            if (this.normalEditorElements.contains((Object)element)) {
                ArrayList<AbstractEditorElement> newNormalEditorElements = new ArrayList<AbstractEditorElement>();
                int index = this.normalEditorElements.indexOf((Object)element);
                int i = 0;
                if (index > 0) {
                    for (AbstractEditorElement e : this.normalEditorElements) {
                        if (e != element) {
                            if (i == index - 1) {
                                newNormalEditorElements.add(element);
                                movedBehind = e;
                            }
                            newNormalEditorElements.add(e);
                        }
                        ++i;
                    }
                    this.normalEditorElements = newNormalEditorElements;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return movedBehind;
    }

    public void copyElementsToClipboard(AbstractEditorElement ... elements) {
        if (elements != null && elements.length > 0) {
            COPIED_ELEMENTS_CLIPBOARD.clear();
            for (AbstractEditorElement e : elements) {
                SerializedElement serialized;
                if (!e.settings.isCopyable() || (serialized = e.element.builder.serializeElementInternal(e.element)) == null) continue;
                serialized.putProperty("instance_identifier", ScreenCustomization.generateUniqueIdentifier());
                COPIED_ELEMENTS_CLIPBOARD.put(serialized, e.element.builder);
            }
        }
    }

    public void pasteElementsFromClipboard() {
        if (!COPIED_ELEMENTS_CLIPBOARD.isEmpty()) {
            this.deselectAllElements();
            for (Map.Entry<SerializedElement, ElementBuilder<?, ?>> m : COPIED_ELEMENTS_CLIPBOARD.entrySet()) {
                Object deserializedEditorElement;
                m.getKey().putProperty("instance_identifier", ScreenCustomization.generateUniqueIdentifier());
                Object deserialized = m.getValue().deserializeElementInternal(m.getKey());
                if (deserialized == null || (deserializedEditorElement = m.getValue().wrapIntoEditorElementInternal((AbstractElement)deserialized, this)) == null) continue;
                this.normalEditorElements.add((AbstractEditorElement)((Object)deserializedEditorElement));
                this.layoutEditorWidgets.forEach(widget -> widget.editorElementAdded((AbstractEditorElement)((Object)deserializedEditorElement)));
                ((AbstractEditorElement)((Object)deserializedEditorElement)).setSelected(true);
            }
        }
    }

    public void saveLayout() {
        if (this.layout.layoutFile != null) {
            this.layout.updateLastEditedTime();
            this.serializeElementInstancesToLayoutInstance();
            if (!this.layout.saveToFileIfPossible()) {
                Minecraft.m_91087_().m_91152_((Screen)NotificationScreen.error(call -> Minecraft.m_91087_().m_91152_((Screen)this), LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.saving_failed.generic", new String[0])));
            } else {
                LayoutHandler.reloadLayouts();
            }
        } else {
            this.saveLayoutAs();
        }
    }

    public void saveLayoutAs() {
        Object fileNamePreset = "universal_layout";
        if (this.layoutTargetScreen != null) {
            fileNamePreset = ScreenIdentifierHandler.getIdentifierOfScreen(this.layoutTargetScreen) + "_layout";
        }
        fileNamePreset = ((String)fileNamePreset).toLowerCase();
        fileNamePreset = CharacterFilter.buildOnlyLowercaseFileNameFilter().filterForAllowedChars((String)fileNamePreset);
        fileNamePreset = FileUtils.generateAvailableFilename((String)LayoutHandler.LAYOUT_DIR.getAbsolutePath(), (String)fileNamePreset, (String)"txt");
        if (this.layout.layoutFile != null) {
            fileNamePreset = this.layout.layoutFile.getName();
        }
        SaveFileScreen s = (SaveFileScreen)SaveFileScreen.build(LayoutHandler.LAYOUT_DIR, (String)fileNamePreset, "txt", call -> {
            if (call != null) {
                try {
                    Layout old;
                    this.layout.updateLastEditedTime();
                    this.serializeElementInstancesToLayoutInstance();
                    this.layout.layoutFile = call.getAbsoluteFile();
                    if (this.layout.layoutFile.isFile() && (old = LayoutHandler.getLayout(this.layout.getLayoutName())) != null) {
                        old.delete(false);
                    }
                    if (!this.layout.saveToFileIfPossible()) {
                        Minecraft.m_91087_().m_91152_((Screen)NotificationScreen.error(call2 -> Minecraft.m_91087_().m_91152_((Screen)this), LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.saving_failed.generic", new String[0])));
                    } else {
                        LayoutHandler.reloadLayouts();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Minecraft.m_91087_().m_91152_((Screen)NotificationScreen.error(call2 -> Minecraft.m_91087_().m_91152_((Screen)this), LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.saving_failed.generic", new String[0])));
                }
            }
            Minecraft.m_91087_().m_91152_((Screen)this);
        }).setVisibleDirectoryLevelsAboveRoot(2).setShowSubDirectories(false);
        FileTypeGroup fileTypeGroup = FileTypeGroup.of((FileType[])new TextFileType[]{FileTypes.TXT_TEXT});
        fileTypeGroup.setDisplayName((Component)Components.translatable("fancymenu.file_types.groups.text", new Object[0]));
        s.setFileTypes(fileTypeGroup);
        Minecraft.m_91087_().m_91152_((Screen)s);
    }

    public void onUpdateSelectedElements() {
        List<AbstractEditorElement> selected = this.getSelectedElements();
        if (selected.size() > 1) {
            for (AbstractEditorElement e : selected) {
                e.setMultiSelected(true);
            }
        } else if (selected.size() == 1) {
            selected.get(0).setMultiSelected(false);
        }
    }

    public void openRightClickMenuAtMouse(int mouseX, int mouseY) {
        if (this.rightClickMenu != null) {
            this.rightClickMenuOpenPosX = mouseX;
            this.rightClickMenuOpenPosY = mouseY;
            this.rightClickMenu.openMenuAtMouse();
        }
    }

    public void closeRightClickMenu() {
        if (this.rightClickMenu != null) {
            if (this.rightClickMenu.isUserNavigatingInMenu()) {
                return;
            }
            this.rightClickMenuOpenPosX = -1000;
            this.rightClickMenuOpenPosY = -1000;
            this.rightClickMenu.closeMenu();
        }
    }

    public void openElementContextMenuAtMouseIfPossible() {
        this.closeActiveElementMenu();
        List<AbstractEditorElement> selectedElements = this.getSelectedElements();
        if (selectedElements.size() == 1) {
            this.activeElementContextMenu = selectedElements.get((int)0).rightClickMenu;
            ((IMixinScreen)((Object)this)).getChildrenFancyMenu().add(0, this.activeElementContextMenu);
            this.activeElementContextMenu.openMenuAtMouse();
        } else if (selectedElements.size() > 1) {
            List<ContextMenu> menus = ObjectUtils.getOfAll(ContextMenu.class, selectedElements, consumes -> consumes.rightClickMenu);
            this.activeElementContextMenu = ContextMenu.stackContextMenus(menus);
            ((IMixinScreen)((Object)this)).getChildrenFancyMenu().add(0, this.activeElementContextMenu);
            this.activeElementContextMenu.openMenuAtMouse();
        }
    }

    public void closeActiveElementMenu(boolean forceClose) {
        if (this.activeElementContextMenu != null) {
            if (!forceClose && this.activeElementContextMenu.isUserNavigatingInMenu()) {
                return;
            }
            this.activeElementContextMenu.closeMenu();
            this.m_169411_(this.activeElementContextMenu);
        }
        this.activeElementContextMenu = null;
    }

    public void closeActiveElementMenu() {
        this.closeActiveElementMenu(false);
    }

    public boolean isUserNavigatingInRightClickMenu() {
        return this.rightClickMenu != null && this.rightClickMenu.isUserNavigatingInMenu();
    }

    public boolean isUserNavigatingInElementMenu() {
        return this.activeElementContextMenu != null && this.activeElementContextMenu.isUserNavigatingInMenu();
    }

    public void saveWidgetSettings() {
        for (AbstractLayoutEditorWidget w : this.layoutEditorWidgets) {
            w.getBuilder().writeSettingsInternal(w);
        }
    }

    @NotNull
    public List<AbstractEditorElement> getCurrentlyDraggedElements() {
        return this.currentlyDraggedElements;
    }

    @Nullable
    protected List<AbstractEditorElement> getElementChildChainOfExcluding(@NotNull AbstractEditorElement element) {
        Objects.requireNonNull(element);
        ArrayList<AbstractEditorElement> chain = new ArrayList<AbstractEditorElement>();
        try {
            AbstractEditorElement e = element;
            while ((e = this.getChildElementOf(e)) != null) {
                if (e == element) {
                    throw new IllegalStateException("Child of origin element is its own child. This shouldn't be possible and comes from an invalid ELEMENT anchor point. You need to manually fix this.");
                }
                if (chain.contains((Object)e)) {
                    throw new IllegalStateException("Chain already contains element! This shouldn't be possible and probably comes from an invalid ELEMENT anchor who's child is its parent or similar scenarios (sweet home Alabama). You need to manually fix this.");
                }
                chain.add(e);
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] There was an error while trying to get the element chain!", (Throwable)ex);
            return null;
        }
        return chain;
    }

    @Nullable
    protected AbstractEditorElement getChildElementOf(@NotNull AbstractEditorElement element) {
        for (AbstractEditorElement e : this.getAllElements()) {
            String parentOfE = e.element.anchorPointElementIdentifier;
            if (parentOfE == null || !parentOfE.equals(element.element.getInstanceIdentifier())) continue;
            return e;
        }
        return null;
    }

    protected void moveSelectedElementsByXYOffset(int offsetX, int offsetY) {
        List<AbstractEditorElement> selected = this.getSelectedElements();
        if (selected.size() > 0 && this.allSelectedElementsMovable()) {
            this.history.saveSnapshot();
        }
        boolean multiSelect = selected.size() > 1;
        for (AbstractEditorElement e : selected) {
            if (this.allSelectedElementsMovable()) {
                if (multiSelect && e.isElementAnchorAndParentIsSelected()) continue;
                e.element.posOffsetX += offsetX;
                e.element.posOffsetY += offsetY;
                continue;
            }
            if (e.settings.isMovable()) continue;
            e.renderMovingNotAllowedTime = System.currentTimeMillis() + 800L;
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean menuBarContextOpen;
        this.leftMouseDownPosX = (int)mouseX;
        this.leftMouseDownPosY = (int)mouseY;
        boolean bl = menuBarContextOpen = this.menuBar != null && this.menuBar.isEntryContextMenuOpen();
        if (PopupHandler.isPopupActive()) {
            this.closeRightClickMenu();
            this.closeActiveElementMenu();
            return false;
        }
        if (super.m_6375_(mouseX, mouseY, button)) {
            this.closeRightClickMenu();
            this.closeActiveElementMenu();
            return true;
        }
        if (menuBarContextOpen) {
            return true;
        }
        AbstractEditorElement topHoverElement = this.getTopHoveredElement();
        boolean topHoverGotSelected = false;
        if (!(topHoverElement == null || this.rightClickMenu.isUserNavigatingInMenu() || this.activeElementContextMenu != null && this.activeElementContextMenu.isUserNavigatingInMenu() || topHoverElement.isSelected())) {
            topHoverElement.setSelected(true);
            topHoverElement.recentlyLeftClickSelected = true;
            topHoverGotSelected = true;
        }
        boolean canStartMouseSelection = true;
        for (AbstractEditorElement e : this.getAllElements()) {
            e.m_6375_(mouseX, mouseY, button);
            if (!e.isHovered() && !e.isGettingResized() && e.getHoveredResizeGrabber() == null) continue;
            canStartMouseSelection = false;
        }
        if (button == 0 && canStartMouseSelection) {
            this.isMouseSelection = true;
            this.mouseSelectionStartX = (int)mouseX;
            this.mouseSelectionStartY = (int)mouseY;
        }
        if (!(this.rightClickMenu.isUserNavigatingInMenu() || this.activeElementContextMenu != null && this.activeElementContextMenu.isUserNavigatingInMenu() || LayoutEditorScreen.m_96637_() || button != 0 && (button != 1 || topHoverElement != null && !topHoverGotSelected))) {
            for (AbstractEditorElement e : this.getAllElements()) {
                if (e.isGettingResized() || topHoverElement != null && e == topHoverElement) continue;
                e.setSelected(false);
            }
        }
        this.closeActiveElementMenu();
        if (button == 0 && !this.rightClickMenu.isUserNavigatingInMenu()) {
            this.closeRightClickMenu();
        }
        if (topHoverElement == null) {
            if (button == 1) {
                this.openRightClickMenuAtMouse((int)mouseX, (int)mouseY);
            }
        } else {
            this.closeRightClickMenu();
            if (button == 1) {
                this.openElementContextMenuAtMouseIfPossible();
            }
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        AbstractEditorElement topHoverElement;
        this.anchorPointOverlay.m_6348_(mouseX, mouseY, button);
        this.elementMovingStarted = false;
        this.elementResizingStarted = false;
        this.currentlyDraggedElements.clear();
        boolean mouseWasInDraggingMode = this.mouseDraggingStarted;
        this.mouseDraggingStarted = false;
        boolean cachedMouseSelection = this.isMouseSelection;
        if (button == 0) {
            this.isMouseSelection = false;
        }
        if (PopupHandler.isPopupActive()) {
            return false;
        }
        this.m_7897_(false);
        for (GuiEventListener child : this.m_6702_()) {
            if (!child.m_6348_(mouseX, mouseY, button)) continue;
            return true;
        }
        List<AbstractEditorElement> hoveredElements = this.getHoveredElements();
        AbstractEditorElement abstractEditorElement = topHoverElement = hoveredElements.size() > 0 ? hoveredElements.get(hoveredElements.size() - 1) : null;
        if (!mouseWasInDraggingMode && !cachedMouseSelection && button == 0 && topHoverElement != null && topHoverElement.isSelected() && !topHoverElement.recentlyMovedByDragging && !topHoverElement.recentlyLeftClickSelected && LayoutEditorScreen.m_96637_()) {
            topHoverElement.setSelected(false);
        }
        boolean elementRecentlyMovedByDragging = false;
        for (AbstractEditorElement e : this.getAllElements()) {
            if (e.recentlyMovedByDragging) {
                elementRecentlyMovedByDragging = true;
            }
            e.m_6348_(mouseX, mouseY, button);
            e.recentlyLeftClickSelected = false;
        }
        if (elementRecentlyMovedByDragging && this.preDragElementSnapshot != null) {
            this.history.saveSnapshot(this.preDragElementSnapshot);
        }
        this.preDragElementSnapshot = null;
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double $$3, double $$4) {
        boolean movingCrumpleZonePassed;
        if (PopupHandler.isPopupActive()) {
            return false;
        }
        if (super.m_7979_(mouseX, mouseY, button, $$3, $$4)) {
            return true;
        }
        if (this.isMouseSelection) {
            for (AbstractEditorElement e : this.getAllElements()) {
                boolean b = this.isElementOverlappingArea(e, Math.min(this.mouseSelectionStartX, (int)mouseX), Math.min(this.mouseSelectionStartY, (int)mouseY), Math.max(this.mouseSelectionStartX, (int)mouseX), Math.max(this.mouseSelectionStartY, (int)mouseY));
                if (!b && LayoutEditorScreen.m_96637_()) continue;
                e.setSelected(b);
            }
        }
        if (this.preDragElementSnapshot == null) {
            this.preDragElementSnapshot = this.history.createSnapshot();
        }
        int draggingDiffX = (int)(mouseX - (double)this.leftMouseDownPosX);
        int draggingDiffY = (int)(mouseY - (double)this.leftMouseDownPosY);
        if (draggingDiffX != 0 || draggingDiffY != 0) {
            this.mouseDraggingStarted = true;
        }
        List<AbstractEditorElement> allElements = this.getAllElements();
        if (!this.elementResizingStarted) {
            allElements.forEach(element -> element.updateResizingStartPos((int)mouseX, (int)mouseY));
        }
        this.elementResizingStarted = true;
        boolean bl = movingCrumpleZonePassed = Math.abs(draggingDiffX) >= 5 || Math.abs(draggingDiffY) >= 5;
        if (movingCrumpleZonePassed) {
            if (!this.elementMovingStarted) {
                allElements.forEach(element -> {
                    element.updateMovingStartPos((int)mouseX, (int)mouseY);
                    element.movingCrumpleZonePassed = true;
                });
                if (this.allSelectedElementsMovable()) {
                    this.currentlyDraggedElements.addAll(this.getSelectedElements());
                }
            }
            this.elementMovingStarted = true;
        }
        for (AbstractEditorElement e : allElements) {
            if (e.m_7979_(mouseX, mouseY, button, $$3, $$4)) break;
        }
        return false;
    }

    public boolean m_7933_(int keycode, int scancode, int modifiers) {
        if (PopupHandler.isPopupActive()) {
            return false;
        }
        this.anchorPointOverlay.m_7933_(keycode, scancode, modifiers);
        if (super.m_7933_(keycode, scancode, modifiers)) {
            return true;
        }
        String key = GLFW.glfwGetKeyName((int)keycode, (int)scancode);
        if (key == null) {
            key = "";
        }
        if (keycode == 263) {
            this.moveSelectedElementsByXYOffset(-1, 0);
            return true;
        }
        if (keycode == 265) {
            this.moveSelectedElementsByXYOffset(0, -1);
            return true;
        }
        if (keycode == 262) {
            this.moveSelectedElementsByXYOffset(1, 0);
            return true;
        }
        if (keycode == 264) {
            this.moveSelectedElementsByXYOffset(0, 1);
            return true;
        }
        if (key.equals("a") && LayoutEditorScreen.m_96637_()) {
            this.selectAllElements();
        }
        if (key.equals("c") && LayoutEditorScreen.m_96637_()) {
            this.copyElementsToClipboard(this.getSelectedElements().toArray(new AbstractEditorElement[0]));
            return true;
        }
        if (key.equals("v") && LayoutEditorScreen.m_96637_()) {
            this.pasteElementsFromClipboard();
            return true;
        }
        if (key.equals("s") && LayoutEditorScreen.m_96637_()) {
            this.saveLayout();
            return true;
        }
        if (key.equals("z") && LayoutEditorScreen.m_96637_()) {
            this.history.stepBack();
            return true;
        }
        if (key.equals("y") && LayoutEditorScreen.m_96637_()) {
            this.history.stepForward();
            return true;
        }
        if (key.equals("g") && LayoutEditorScreen.m_96637_()) {
            try {
                FancyMenu.getOptions().showLayoutEditorGrid.setValue(FancyMenu.getOptions().showLayoutEditorGrid.getValue() == false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        if (keycode == 261) {
            this.history.saveSnapshot();
            for (AbstractEditorElement e : this.getSelectedElements()) {
                e.deleteElement();
            }
            return true;
        }
        return super.m_7933_(keycode, scancode, modifiers);
    }

    public boolean m_7920_(int keycode, int scancode, int modifiers) {
        this.anchorPointOverlay.m_7920_(keycode, scancode, modifiers);
        return super.m_7920_(keycode, scancode, modifiers);
    }

    public void closeEditor() {
        this.saveWidgetSettings();
        currentInstance = null;
        if (this.layoutTargetScreen != null) {
            Screen screen = this.layoutTargetScreen;
            if (screen instanceof CustomizableScreen) {
                CustomizableScreen c = (CustomizableScreen)screen;
                if (!c.isScreenInitialized_FancyMenu()) {
                    Minecraft.m_91087_().m_91152_(this.layoutTargetScreen);
                } else {
                    Minecraft.m_91087_().m_91152_((Screen)new GenericDirtMessageScreen((Component)Component.m_237113_((String)"Closing editor..")));
                    Minecraft.m_91087_().f_91080_ = this.layoutTargetScreen;
                    ScreenCustomization.reInitCurrentScreen();
                }
            } else {
                Minecraft.m_91087_().m_91152_(this.layoutTargetScreen);
            }
        } else {
            Minecraft.m_91087_().m_91152_(null);
        }
    }

    public LayoutEditorScreen setAsCurrentInstance() {
        currentInstance = this;
        return this;
    }

    @Nullable
    public static LayoutEditorScreen getCurrentInstance() {
        return currentInstance;
    }
}

