/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.WebUtils;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.text.markdown.ScrollableMarkdownRenderer;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WelcomeScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int HEADER_HEIGHT = 40;
    private static final int FOOTER_HEIGHT = 50;
    private static final int BORDER = 40;
    private final Screen parent;
    private final Component headline = Component.m_237115_((String)"fancymenu.welcome.screen.headline").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
    private ScrollableMarkdownRenderer markdownRenderer;
    private final Font font;

    public WelcomeScreen(@Nullable Screen parent) {
        super((Component)Component.m_237115_((String)"fancymenu.welcome.screen.title"));
        this.font = Minecraft.m_91087_().f_91062_;
        this.parent = parent;
    }

    protected void m_7856_() {
        int centerX = this.f_96543_ / 2;
        int scrollWidth = this.f_96543_ - 80;
        int scrollHeight = this.f_96544_ - 40 - 50;
        if (this.markdownRenderer == null) {
            this.markdownRenderer = new ScrollableMarkdownRenderer(centerX - scrollWidth / 2, 40.0f, scrollWidth, scrollHeight);
        } else {
            this.markdownRenderer.rebuild(centerX - scrollWidth / 2, 40.0f, scrollWidth, scrollHeight);
        }
        this.markdownRenderer.getMarkdownRenderer().setText("^^^\n\n\n" + I18n.m_118938_((String)"fancymenu.welcome.screen.text", (Object[])new Object[0]) + "\n^^^");
        this.markdownRenderer.getMarkdownRenderer().setAutoLineBreakingEnabled(true);
        this.m_142416_((GuiEventListener)this.markdownRenderer);
        ((ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(centerX - 100, this.f_96544_ - 25 - 10, 200, 20, (Component)Component.m_237115_((String)"fancymenu.welcome.screen.open_docs"), button -> {
            try {
                WebUtils.openWebLink("https://docs.fancymenu.net");
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to open FancyMenu docs in WelcomeScreen!", (Throwable)ex);
            }
            FancyMenu.getOptions().showWelcomeScreen.setValue(false);
            this.m_7379_();
        }))).setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.welcome.screen.open_docs.tooltip", new String[0])));
    }

    public void m_6305_(@NotNull PoseStack graphics, int mouseX, int mouseY, float partial) {
        this.renderBackground(graphics, mouseX, mouseY, partial);
        super.m_6305_(graphics, mouseX, mouseY, partial);
        int n = this.f_96543_ / 2;
        Objects.requireNonNull(this.font);
        WelcomeScreen.m_93215_((PoseStack)graphics, (Font)this.font, (Component)this.headline, (int)n, (int)(20 - 9 / 2), (int)-1);
    }

    public void renderBackground(@NotNull PoseStack graphics, int mouseX, int mouseY, float partial) {
        this.m_7333_(graphics);
        RenderSystem.m_69478_();
        RenderingUtils.resetShaderColor();
        this.m_93179_(graphics, 0, 40, this.f_96543_, 44, -16777216, 0);
        this.m_93179_(graphics, 0, this.f_96544_ - 50 - 4, this.f_96543_, this.f_96544_ - 50, 0, -16777216);
        RenderingUtils.resetShaderColor();
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDeltaY) {
        return this.markdownRenderer.m_6050_(mouseX, mouseY, scrollDeltaY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return this.markdownRenderer.m_6348_(mouseX, mouseY, button);
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    public boolean m_6913_() {
        return false;
    }
}

