/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.gui.config;

import at.ridgo8.moreoverlays.gui.config.ConfigOptionList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class OptionValueEntry<V>
extends ConfigOptionList.OptionEntry {
    public static final int CONTROL_WIDTH_NOVALIDATOR = 44;
    public static final int CONTROL_WIDTH_VALIDATOR = 64;
    public static final int TITLE_WIDTH = 80;
    protected final ForgeConfigSpec.ConfigValue<V> value;
    protected final ForgeConfigSpec.ValueSpec spec;
    private final List<String> tooltip;
    protected Button btnReset;
    protected Button btnUndo;
    protected V defaultValue;
    protected V newValue;
    protected boolean showValidity = false;
    private String txtUndo = "";
    private String txtReset = "";
    private String name = "";
    private boolean valid = false;
    private boolean changes = false;

    public OptionValueEntry(ConfigOptionList list, ForgeConfigSpec.ConfigValue<V> confValue, ForgeConfigSpec.ValueSpec spec) {
        super(list);
        this.value = confValue;
        this.spec = spec;
        this.btnReset = new Button(list.m_5759_() - 20, 0, 20, 20, Component.m_130674_((String)"\u2604"), btn -> this.reset());
        this.btnUndo = new Button(list.m_5759_() - 42, 0, 20, 20, Component.m_130674_((String)"\u21b6"), btn -> this.undo());
        this.txtReset = I18n.m_118938_((String)"gui.config.moreoverlays.reset_config", (Object[])new Object[0]);
        this.txtUndo = I18n.m_118938_((String)"gui.config.moreoverlays.undo", (Object[])new Object[0]);
        Object defaultVal = this.spec.getDefault();
        if (defaultVal != null && spec.getClazz().isAssignableFrom(defaultVal.getClass())) {
            this.defaultValue = defaultVal;
        } else {
            this.btnReset.f_93623_ = false;
        }
        String translationKey = "config.moreoverlays." + this.getTranslationKey().toLowerCase();
        this.name = I18n.m_118936_((String)translationKey) ? I18n.m_118938_((String)translationKey, (Object[])new Object[0]) : (String)this.value.getPath().get(this.value.getPath().size() - 1);
        String[] lines = null;
        if (this.spec.getComment() != null) {
            lines = this.spec.getComment().split("\\n");
            this.tooltip = new ArrayList<String>(lines.length + 1);
        } else {
            this.tooltip = new ArrayList<String>(1);
        }
        this.tooltip.add(ChatFormatting.RED + this.name);
        for (String line : lines) {
            this.tooltip.add(ChatFormatting.YELLOW + line);
        }
        this.updateValue(this.value.get());
    }

    private String getTranslationKey() {
        return String.join((CharSequence)".", this.value.getPath());
    }

    @Override
    protected void renderControls(PoseStack matrixStack, int rowTop, int rowLeft, int rowWidth, int itemHeight, int mouseX, int mouseY, boolean mouseOver, float partialTick) {
        GuiComponent.m_93236_((PoseStack)matrixStack, (Font)Minecraft.m_91087_().f_91062_, (String)this.name, (int)-20, (int)6, (int)0xFFFFFF);
        this.btnReset.m_6305_(matrixStack, mouseX, mouseY, partialTick);
        this.btnUndo.m_6305_(matrixStack, mouseX, mouseY, partialTick);
        if (this.showValidity) {
            if (this.valid) {
                GuiComponent.m_93208_((PoseStack)matrixStack, (Font)Minecraft.m_91087_().f_91062_, (String)"\u2714", (int)(this.getConfigOptionList().m_5759_() - 53), (int)6, (int)65280);
            } else {
                GuiComponent.m_93208_((PoseStack)matrixStack, (Font)Minecraft.m_91087_().f_91062_, (String)"\u2715", (int)(this.getConfigOptionList().m_5759_() - 53), (int)6, (int)0xFF0000);
            }
        }
    }

    @Override
    protected void renderTooltip(PoseStack matrixStack, int rowTop, int rowLeft, int rowWidth, int itemHeight, int mouseX, int mouseY) {
        super.renderTooltip(matrixStack, rowTop, rowLeft, rowWidth, itemHeight, mouseX, mouseY);
        ArrayList<Component> tooltipConverted = new ArrayList<Component>();
        for (String iTextComponent : this.tooltip) {
            tooltipConverted.add(Component.m_130674_((String)iTextComponent));
        }
        if (this.btnReset.m_198029_()) {
            this.getConfigOptionList().getScreen().m_96602_(matrixStack, Component.m_130674_((String)this.txtReset), mouseX, mouseY);
        } else if (this.btnUndo.m_198029_()) {
            this.getConfigOptionList().getScreen().m_96602_(matrixStack, Component.m_130674_((String)this.txtUndo), mouseX, mouseY);
        } else if (mouseX < 80 + rowLeft) {
            this.getConfigOptionList().getScreen().m_96597_(matrixStack, tooltipConverted, mouseX, mouseY);
        }
        Lighting.m_84930_();
        GlStateManager.m_84519_();
    }

    protected abstract void overrideUnsaved(V var1);

    protected boolean isUndoable(V current) {
        return current == null || !current.equals(this.value.get()) || !this.valid;
    }

    protected void updateValue(@Nullable V value) {
        this.valid = value != null && this.spec.test(value);
        this.btnReset.f_93623_ = this.isResettable();
        this.btnUndo.f_93623_ = this.changes = this.isUndoable(value);
        this.newValue = value;
    }

    @Override
    public void undo() {
        this.overrideUnsaved(this.value.get());
        this.updateValue(this.value.get());
    }

    @Override
    public void reset() {
        if (this.defaultValue != null) {
            this.value.set(this.defaultValue);
            this.overrideUnsaved(this.defaultValue);
            this.updateValue(this.defaultValue);
        }
    }

    @Override
    public List<? extends GuiEventListener> m_6702_() {
        return Arrays.asList(this.btnReset, this.btnUndo);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public boolean hasChanges() {
        return this.changes;
    }

    @Override
    public boolean isResettable() {
        return this.defaultValue != null && (this.value.get() == null || !this.value.get().equals(this.defaultValue));
    }

    @Override
    public void save() {
        this.value.set(this.newValue);
        this.value.save();
    }
}

