/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.mixin.client;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionCollider;
import com.simibubi.create.content.contraptions.ContraptionHandler;
import java.lang.ref.Reference;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.logging.log4j.util.TriConsumer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityContraptionInteractionMixin
extends CapabilityProvider<Entity> {
    @Shadow
    public Level f_19853_;
    @Shadow
    private Vec3 f_19825_;
    @Shadow
    private float f_19829_;
    @Shadow
    @Final
    protected RandomSource f_19796_;
    @Shadow
    private EntityDimensions f_19815_;

    private EntityContraptionInteractionMixin(Class<Entity> baseClass) {
        super(baseClass);
    }

    @Shadow
    protected abstract float m_6059_();

    @Shadow
    protected abstract void m_7355_(BlockPos var1, BlockState var2);

    @Unique
    private Stream<AbstractContraptionEntity> create$getIntersectionContraptionsStream() {
        return ContraptionHandler.loadedContraptions.get((LevelAccessor)this.f_19853_).values().stream().map(Reference::get).filter(cEntity -> cEntity != null && cEntity.collidingEntities.containsKey((Entity)this));
    }

    @Unique
    private Set<AbstractContraptionEntity> create$getIntersectingContraptions() {
        Set<AbstractContraptionEntity> contraptions = this.create$getIntersectionContraptionsStream().collect(Collectors.toSet());
        contraptions.addAll(this.f_19853_.m_45976_(AbstractContraptionEntity.class, ((Entity)this).m_20191_().m_82400_(1.0)));
        return contraptions;
    }

    @Unique
    private void create$forCollision(Vec3 worldPos, TriConsumer<Contraption, BlockState, BlockPos> action) {
        this.create$getIntersectingContraptions().forEach(cEntity -> {
            Vec3 localPos = ContraptionCollider.worldToLocalPos(worldPos, cEntity);
            BlockPos blockPos = new BlockPos(localPos);
            Contraption contraption = cEntity.getContraption();
            StructureTemplate.StructureBlockInfo info = contraption.getBlocks().get(blockPos);
            if (info != null) {
                BlockState blockstate = info.f_74676_;
                action.accept((Object)contraption, (Object)blockstate, (Object)blockPos);
            }
        });
    }

    @Inject(method={"move"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;isAir()Z", ordinal=0)})
    private void create$contraptionStepSounds(MoverType mover, Vec3 movement, CallbackInfo ci) {
        Vec3 worldPos = this.f_19825_.m_82520_(0.0, -0.2, 0.0);
        MutableBoolean stepped = new MutableBoolean(false);
        this.create$forCollision(worldPos, (TriConsumer<Contraption, BlockState, BlockPos>)((TriConsumer)(contraption, state, pos) -> {
            this.m_7355_((BlockPos)pos, (BlockState)state);
            stepped.setTrue();
        }));
        if (stepped.booleanValue()) {
            this.f_19829_ = this.m_6059_();
        }
    }

    @Inject(method={"move"}, at={@At(value="TAIL")})
    private void create$onMove(MoverType mover, Vec3 movement, CallbackInfo ci) {
        if (!this.f_19853_.f_46443_) {
            return;
        }
        Entity self = (Entity)this;
        if (self.m_20096_()) {
            return;
        }
        if (self.m_20159_()) {
            return;
        }
        Vec3 worldPos = this.f_19825_.m_82520_(0.0, -0.2, 0.0);
        boolean onAtLeastOneContraption = this.create$getIntersectionContraptionsStream().anyMatch(cEntity -> {
            Vec3 localPos = ContraptionCollider.worldToLocalPos(worldPos, cEntity);
            BlockPos blockPos = new BlockPos(localPos);
            Contraption contraption = cEntity.getContraption();
            StructureTemplate.StructureBlockInfo info = contraption.getBlocks().get(blockPos);
            if (info == null) {
                return false;
            }
            cEntity.registerColliding(self);
            return true;
        });
        if (!onAtLeastOneContraption) {
            return;
        }
        self.m_6853_(true);
        self.getPersistentData().m_128379_("ContraptionGrounded", true);
    }

    @Inject(method={"spawnSprintParticle"}, at={@At(value="TAIL")})
    private void create$onSpawnSprintParticle(CallbackInfo ci) {
        Entity self = (Entity)this;
        Vec3 worldPos = this.f_19825_.m_82520_(0.0, -0.2, 0.0);
        BlockPos particlePos = new BlockPos(worldPos);
        this.create$forCollision(worldPos, (TriConsumer<Contraption, BlockState, BlockPos>)((TriConsumer)(contraption, state, pos) -> {
            if (!state.addRunningEffects(this.f_19853_, pos, self) && state.m_60799_() != RenderShape.INVISIBLE) {
                Vec3 speed = self.m_20184_();
                this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state).setPos(particlePos), self.m_20185_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.f_19815_.f_20377_, self.m_20186_() + 0.1, self.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.f_19815_.f_20378_, speed.f_82479_ * -4.0, 1.5, speed.f_82481_ * -4.0);
            }
        }));
    }
}

