/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.AllPackets;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.schematics.SchematicInstances;
import com.simibubi.create.content.schematics.SchematicItem;
import com.simibubi.create.content.schematics.SchematicWorld;
import com.simibubi.create.content.schematics.client.SchematicHotbarSlotOverlay;
import com.simibubi.create.content.schematics.client.SchematicRenderer;
import com.simibubi.create.content.schematics.client.SchematicTransformation;
import com.simibubi.create.content.schematics.client.ToolSelectionScreen;
import com.simibubi.create.content.schematics.client.tools.ToolType;
import com.simibubi.create.content.schematics.packet.SchematicPlacePacket;
import com.simibubi.create.content.schematics.packet.SchematicSyncPacket;
import com.simibubi.create.foundation.outliner.AABBOutline;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.List;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class SchematicHandler
implements IGuiOverlay {
    private String displayedSchematic;
    private SchematicTransformation transformation;
    private AABB bounds;
    private boolean deployed;
    private boolean active;
    private ToolType currentTool;
    private static final int SYNC_DELAY = 10;
    private int syncCooldown;
    private int activeHotbarSlot;
    private ItemStack activeSchematicItem;
    private AABBOutline outline;
    private Vector<SchematicRenderer> renderers = new Vector(3);
    private SchematicHotbarSlotOverlay overlay;
    private ToolSelectionScreen selectionScreen;

    public SchematicHandler() {
        for (int i = 0; i < this.renderers.capacity(); ++i) {
            this.renderers.add(new SchematicRenderer());
        }
        this.overlay = new SchematicHotbarSlotOverlay();
        this.currentTool = ToolType.DEPLOY;
        this.selectionScreen = new ToolSelectionScreen((List<ToolType>)ImmutableList.of((Object)((Object)ToolType.DEPLOY)), this::equip);
        this.transformation = new SchematicTransformation();
    }

    public void tick() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91072_.m_105295_() == GameType.SPECTATOR) {
            if (this.active) {
                this.active = false;
                this.syncCooldown = 0;
                this.activeHotbarSlot = 0;
                this.activeSchematicItem = null;
                this.renderers.forEach(r -> r.setActive(false));
            }
            return;
        }
        if (this.activeSchematicItem != null && this.transformation != null) {
            this.transformation.tick();
        }
        this.renderers.forEach(SchematicRenderer::tick);
        LocalPlayer player = mc.f_91074_;
        ItemStack stack = this.findBlueprintInHand((Player)player);
        if (stack == null) {
            this.active = false;
            this.syncCooldown = 0;
            if (this.activeSchematicItem != null && this.itemLost((Player)player)) {
                this.activeHotbarSlot = 0;
                this.activeSchematicItem = null;
                this.renderers.forEach(r -> r.setActive(false));
            }
            return;
        }
        if (!this.active || !stack.m_41783_().m_128461_("File").equals(this.displayedSchematic)) {
            this.renderers.forEach(r -> r.setActive(false));
            this.init(player, stack);
        }
        if (!this.active) {
            return;
        }
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
        }
        if (this.syncCooldown == 1) {
            this.sync();
        }
        this.selectionScreen.update();
        this.currentTool.getTool().updateSelection();
    }

    private void init(LocalPlayer player, ItemStack stack) {
        this.loadSettings(stack);
        this.displayedSchematic = stack.m_41783_().m_128461_("File");
        this.active = true;
        if (this.deployed) {
            this.setupRenderer();
            ToolType toolBefore = this.currentTool;
            this.selectionScreen = new ToolSelectionScreen(ToolType.getTools(player.m_7500_()), this::equip);
            if (toolBefore != null) {
                this.selectionScreen.setSelectedElement(toolBefore);
                this.equip(toolBefore);
            }
        } else {
            this.selectionScreen = new ToolSelectionScreen((List<ToolType>)ImmutableList.of((Object)((Object)ToolType.DEPLOY)), this::equip);
        }
    }

    private void setupRenderer() {
        StructureTemplate schematic = SchematicItem.loadSchematic(this.activeSchematicItem);
        Vec3i size = schematic.m_163801_();
        if (size.equals((Object)Vec3i.f_123288_)) {
            return;
        }
        ClientLevel clientWorld = Minecraft.m_91087_().f_91073_;
        SchematicWorld w = new SchematicWorld((Level)clientWorld);
        SchematicWorld wMirroredFB = new SchematicWorld((Level)clientWorld);
        SchematicWorld wMirroredLR = new SchematicWorld((Level)clientWorld);
        StructurePlaceSettings placementSettings = new StructurePlaceSettings();
        BlockPos pos = BlockPos.f_121853_;
        try {
            schematic.m_230328_((ServerLevelAccessor)w, pos, pos, placementSettings, w.m_213780_(), 2);
            for (BlockEntity blockEntity : w.getBlockEntities()) {
                blockEntity.m_142339_((Level)w);
            }
            w.fixControllerBlockEntities();
        }
        catch (Exception e) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Lang.translate("schematic.error", new Object[0]).component(), false);
            Create.LOGGER.error("Failed to load Schematic for Previewing", (Throwable)e);
            return;
        }
        placementSettings.m_74377_(Mirror.FRONT_BACK);
        pos = BlockPos.f_121853_.m_122030_(size.m_123341_() - 1);
        schematic.m_230328_((ServerLevelAccessor)wMirroredFB, pos, pos, placementSettings, wMirroredFB.m_213780_(), 2);
        StructureTransform transform = new StructureTransform(placementSettings.m_74407_(), Direction.Axis.Y, Rotation.NONE, placementSettings.m_74401_());
        for (BlockEntity be : wMirroredFB.getRenderedBlockEntities()) {
            transform.apply(be);
        }
        wMirroredFB.fixControllerBlockEntities();
        placementSettings.m_74377_(Mirror.LEFT_RIGHT);
        pos = BlockPos.f_121853_.m_122020_(size.m_123343_() - 1);
        schematic.m_230328_((ServerLevelAccessor)wMirroredLR, pos, pos, placementSettings, wMirroredFB.m_213780_(), 2);
        transform = new StructureTransform(placementSettings.m_74407_(), Direction.Axis.Y, Rotation.NONE, placementSettings.m_74401_());
        for (BlockEntity be : wMirroredLR.getRenderedBlockEntities()) {
            transform.apply(be);
        }
        wMirroredLR.fixControllerBlockEntities();
        this.renderers.get(0).display(w);
        this.renderers.get(1).display(wMirroredFB);
        this.renderers.get(2).display(wMirroredLR);
    }

    public void render(PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera) {
        boolean present;
        boolean bl = present = this.activeSchematicItem != null;
        if (!this.active && !present) {
            return;
        }
        if (this.active) {
            ms.m_85836_();
            this.currentTool.getTool().renderTool(ms, buffer, camera);
            ms.m_85849_();
        }
        ms.m_85836_();
        this.transformation.applyTransformations(ms, camera);
        if (!this.renderers.isEmpty()) {
            boolean fb;
            float pt = AnimationTickHolder.getPartialTicks();
            boolean lr = this.transformation.getScaleLR().getValue(pt) < 0.0f;
            boolean bl2 = fb = this.transformation.getScaleFB().getValue(pt) < 0.0f;
            if (lr && !fb) {
                this.renderers.get(2).render(ms, buffer);
            } else if (fb && !lr) {
                this.renderers.get(1).render(ms, buffer);
            } else {
                this.renderers.get(0).render(ms, buffer);
            }
        }
        if (this.active) {
            this.currentTool.getTool().renderOnSchematic(ms, buffer);
        }
        ms.m_85849_();
    }

    public void updateRenderers() {
        for (SchematicRenderer renderer : this.renderers) {
            renderer.update();
        }
    }

    public void render(ForgeGui gui, PoseStack poseStack, float partialTicks, int width, int height) {
        if (Minecraft.m_91087_().f_91066_.f_92062_ || !this.active) {
            return;
        }
        if (this.activeSchematicItem != null) {
            this.overlay.renderOn(poseStack, this.activeHotbarSlot);
        }
        this.currentTool.getTool().renderOverlay(gui, poseStack, partialTicks, width, height);
        this.selectionScreen.renderPassive(poseStack, partialTicks);
    }

    public boolean onMouseInput(int button, boolean pressed) {
        if (!this.active) {
            return false;
        }
        if (!pressed || button != 1) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_.m_6144_()) {
            return false;
        }
        if (mc.f_91077_ instanceof BlockHitResult) {
            BlockHitResult blockRayTraceResult = (BlockHitResult)mc.f_91077_;
            BlockState clickedBlock = mc.f_91073_.m_8055_(blockRayTraceResult.m_82425_());
            if (AllBlocks.SCHEMATICANNON.has(clickedBlock)) {
                return false;
            }
            if (AllBlocks.DEPLOYER.has(clickedBlock)) {
                return false;
            }
        }
        return this.currentTool.getTool().handleRightClick();
    }

    public void onKeyInput(int key, boolean pressed) {
        if (!this.active) {
            return;
        }
        if (key != AllKeys.TOOL_MENU.getBoundCode()) {
            return;
        }
        if (pressed && !this.selectionScreen.f_94673_) {
            this.selectionScreen.f_94673_ = true;
        }
        if (!pressed && this.selectionScreen.f_94673_) {
            this.selectionScreen.f_94673_ = false;
            this.selectionScreen.m_7379_();
        }
    }

    public boolean mouseScrolled(double delta) {
        if (!this.active) {
            return false;
        }
        if (this.selectionScreen.f_94673_) {
            this.selectionScreen.cycle((int)delta);
            return true;
        }
        if (AllKeys.ctrlDown()) {
            return this.currentTool.getTool().handleMouseWheel(delta);
        }
        return false;
    }

    private ItemStack findBlueprintInHand(Player player) {
        ItemStack stack = player.m_21205_();
        if (!AllItems.SCHEMATIC.isIn(stack)) {
            return null;
        }
        if (!stack.m_41782_()) {
            return null;
        }
        this.activeSchematicItem = stack;
        this.activeHotbarSlot = player.m_150109_().f_35977_;
        return stack;
    }

    private boolean itemLost(Player player) {
        for (int i = 0; i < Inventory.m_36059_(); ++i) {
            if (!player.m_150109_().m_8020_(i).m_41656_(this.activeSchematicItem) || !ItemStack.m_41658_((ItemStack)player.m_150109_().m_8020_(i), (ItemStack)this.activeSchematicItem)) continue;
            return false;
        }
        return true;
    }

    public void markDirty() {
        this.syncCooldown = 10;
    }

    public void sync() {
        if (this.activeSchematicItem == null) {
            return;
        }
        AllPackets.getChannel().sendToServer((Object)new SchematicSyncPacket(this.activeHotbarSlot, this.transformation.toSettings(), this.transformation.getAnchor(), this.deployed));
    }

    public void equip(ToolType tool) {
        this.currentTool = tool;
        this.currentTool.getTool().init();
    }

    public void loadSettings(ItemStack blueprint) {
        CompoundTag tag = blueprint.m_41783_();
        BlockPos anchor = BlockPos.f_121853_;
        StructurePlaceSettings settings = SchematicItem.getSettings(blueprint);
        this.transformation = new SchematicTransformation();
        this.deployed = tag.m_128471_("Deployed");
        if (this.deployed) {
            anchor = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("Anchor"));
        }
        Vec3i size = NBTHelper.readVec3i(tag.m_128437_("Bounds", 3));
        this.bounds = new AABB(0.0, 0.0, 0.0, (double)size.m_123341_(), (double)size.m_123342_(), (double)size.m_123343_());
        this.outline = new AABBOutline(this.bounds);
        this.outline.getParams().colored(6850245).lineWidth(0.0625f);
        this.transformation.init(anchor, settings, this.bounds);
    }

    public void deploy() {
        if (!this.deployed) {
            List<ToolType> tools = ToolType.getTools(Minecraft.m_91087_().f_91074_.m_7500_());
            this.selectionScreen = new ToolSelectionScreen(tools, this::equip);
        }
        this.deployed = true;
        this.setupRenderer();
    }

    public String getCurrentSchematicName() {
        return this.displayedSchematic != null ? this.displayedSchematic : "-";
    }

    public void printInstantly() {
        AllPackets.getChannel().sendToServer((Object)new SchematicPlacePacket(this.activeSchematicItem.m_41777_()));
        CompoundTag nbt = this.activeSchematicItem.m_41783_();
        nbt.m_128379_("Deployed", false);
        this.activeSchematicItem.m_41751_(nbt);
        SchematicInstances.clearHash(this.activeSchematicItem);
        this.renderers.forEach(r -> r.setActive(false));
        this.active = false;
        this.markDirty();
    }

    public boolean isActive() {
        return this.active;
    }

    public AABB getBounds() {
        return this.bounds;
    }

    public SchematicTransformation getTransformation() {
        return this.transformation;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public ItemStack getActiveSchematicItem() {
        return this.activeSchematicItem;
    }

    public AABBOutline getOutline() {
        return this.outline;
    }
}

