/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.contact;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.elevator.ElevatorColumn;
import com.simibubi.create.foundation.block.WrenchableDirectionalBlock;
import com.simibubi.create.foundation.utility.BlockHelper;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RedstoneContactBlock
extends WrenchableDirectionalBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public RedstoneContactBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52588_, (Comparable)Direction.UP));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED});
        super.m_7926_(builder);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)context.m_7820_().m_122424_());
        Direction placeDirection = context.m_43719_().m_122424_();
        if (context.m_43723_() != null && context.m_43723_().m_6144_() || RedstoneContactBlock.hasValidContact((LevelAccessor)context.m_43725_(), context.m_8083_(), placeDirection)) {
            state = (BlockState)state.m_61124_((Property)f_52588_, (Comparable)placeDirection);
        }
        if (RedstoneContactBlock.hasValidContact((LevelAccessor)context.m_43725_(), context.m_8083_(), (Direction)state.m_61143_((Property)f_52588_))) {
            state = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        InteractionResult onWrenched = super.onWrenched(state, context);
        if (onWrenched != InteractionResult.SUCCESS) {
            return onWrenched;
        }
        Level level = context.m_43725_();
        if (level.m_5776_()) {
            return onWrenched;
        }
        BlockPos pos = context.m_8083_();
        state = level.m_8055_(pos);
        Direction facing = (Direction)state.m_61143_((Property)f_52588_);
        if (facing.m_122434_() == Direction.Axis.Y) {
            return onWrenched;
        }
        if (ElevatorColumn.get((LevelAccessor)level, new ElevatorColumn.ColumnCoords(pos.m_123341_(), pos.m_123343_(), facing)) == null) {
            return onWrenched;
        }
        level.m_46597_(pos, BlockHelper.copyProperties(state, AllBlocks.ELEVATOR_CONTACT.getDefaultState()));
        return onWrenched;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing != stateIn.m_61143_((Property)f_52588_)) {
            return stateIn;
        }
        boolean hasValidContact = RedstoneContactBlock.hasValidContact(worldIn, currentPos, facing);
        if ((Boolean)stateIn.m_61143_((Property)POWERED) != hasValidContact) {
            return (BlockState)stateIn.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(hasValidContact));
        }
        return stateIn;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() == this && newState.m_60734_() == this && state == newState.m_61122_((Property)POWERED)) {
            worldIn.m_46672_(pos, (Block)this);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        boolean hasValidContact = RedstoneContactBlock.hasValidContact((LevelAccessor)worldIn, pos, (Direction)state.m_61143_((Property)f_52588_));
        if ((Boolean)state.m_61143_((Property)POWERED) != hasValidContact) {
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(hasValidContact)));
        }
    }

    public static boolean hasValidContact(LevelAccessor world, BlockPos pos, Direction direction) {
        BlockState blockState = world.m_8055_(pos.m_121945_(direction));
        return (AllBlocks.REDSTONE_CONTACT.has(blockState) || AllBlocks.ELEVATOR_CONTACT.has(blockState)) && blockState.m_61143_((Property)f_52588_) == direction.m_122424_();
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader level, BlockPos pos, Direction side) {
        return false;
    }

    public boolean m_7899_(BlockState state) {
        return (Boolean)state.m_61143_((Property)POWERED);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return side != null && state.m_61143_((Property)f_52588_) != side.m_122424_();
    }

    public int m_6378_(BlockState state, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)state.m_61143_((Property)POWERED) != false && side != ((Direction)state.m_61143_((Property)f_52588_)).m_122424_() ? 15 : 0;
    }
}

