/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.behaviour.dispenser;

import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.behaviour.dispenser.DispenseItemLocation;
import com.simibubi.create.content.contraptions.behaviour.dispenser.MovedDefaultDispenseItemBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.items.IItemHandler;

public class DropperMovementBehaviour
implements MovementBehaviour {
    protected static final MovedDefaultDispenseItemBehaviour DEFAULT_BEHAVIOUR = new MovedDefaultDispenseItemBehaviour();
    private static final Random RNG = new Random();

    protected void activate(MovementContext context, BlockPos pos) {
        DispenseItemLocation location = this.getDispenseLocation(context);
        if (location.isEmpty()) {
            context.world.m_46796_(1001, pos, 0);
        } else {
            this.setItemStackAt(location, DEFAULT_BEHAVIOUR.dispense(this.getItemStackAt(location, context), context, pos), context);
        }
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        if (context.world.f_46443_) {
            return;
        }
        this.collectItems(context);
        this.activate(context, pos);
    }

    private void collectItems(MovementContext context) {
        this.getStacks(context).stream().filter(itemStack -> !itemStack.m_41619_() && itemStack.m_41720_() != Items.f_41852_ && itemStack.m_41741_() > itemStack.m_41613_()).forEach(itemStack -> itemStack.m_41769_(ItemHelper.extract((IItemHandler)context.contraption.getSharedInventory(), otherItemStack -> ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)otherItemStack), ItemHelper.ExtractionCountMode.UPTO, itemStack.m_41741_() - itemStack.m_41613_(), false).m_41613_()));
    }

    private void updateTemporaryData(MovementContext context) {
        if (!(context.temporaryData instanceof NonNullList) && context.world != null) {
            NonNullList stacks = NonNullList.m_122780_((int)DropperMovementBehaviour.getInvSize(), (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)context.blockEntityData, (NonNullList)stacks);
            context.temporaryData = stacks;
        }
    }

    private NonNullList<ItemStack> getStacks(MovementContext context) {
        this.updateTemporaryData(context);
        return (NonNullList)context.temporaryData;
    }

    private ArrayList<DispenseItemLocation> getUseableLocations(MovementContext context) {
        ArrayList<DispenseItemLocation> useable = new ArrayList<DispenseItemLocation>();
        for (int slot = 0; slot < DropperMovementBehaviour.getInvSize(); ++slot) {
            DispenseItemLocation location = new DispenseItemLocation(true, slot);
            ItemStack testStack = this.getItemStackAt(location, context);
            if (testStack == null || testStack.m_41619_()) continue;
            if (testStack.m_41741_() == 1) {
                location = new DispenseItemLocation(false, ItemHelper.findFirstMatchingSlotIndex((IItemHandler)context.contraption.getSharedInventory(), arg_0 -> ((ItemStack)testStack).m_41656_(arg_0)));
                if (this.getItemStackAt(location, context).m_41619_()) continue;
                useable.add(location);
                continue;
            }
            if (testStack.m_41613_() < 2) continue;
            useable.add(location);
        }
        return useable;
    }

    @Override
    public void writeExtraData(MovementContext context) {
        NonNullList<ItemStack> stacks = this.getStacks(context);
        if (stacks == null) {
            return;
        }
        ContainerHelper.m_18973_((CompoundTag)context.blockEntityData, stacks);
    }

    @Override
    public void stopMoving(MovementContext context) {
        MovementBehaviour.super.stopMoving(context);
        this.writeExtraData(context);
    }

    protected DispenseItemLocation getDispenseLocation(MovementContext context) {
        int i = -1;
        int j = 1;
        ArrayList<DispenseItemLocation> useableLocations = this.getUseableLocations(context);
        for (int k = 0; k < useableLocations.size(); ++k) {
            if (RNG.nextInt(j++) != 0) continue;
            i = k;
        }
        if (i < 0) {
            return DispenseItemLocation.NONE;
        }
        return (DispenseItemLocation)useableLocations.get(i);
    }

    protected ItemStack getItemStackAt(DispenseItemLocation location, MovementContext context) {
        if (location.isInternal()) {
            return (ItemStack)this.getStacks(context).get(location.getSlot());
        }
        return context.contraption.getSharedInventory().getStackInSlot(location.getSlot());
    }

    protected void setItemStackAt(DispenseItemLocation location, ItemStack stack, MovementContext context) {
        if (location.isInternal()) {
            this.getStacks(context).set(location.getSlot(), (Object)stack);
        } else {
            context.contraption.getSharedInventory().setStackInSlot(location.getSlot(), stack);
        }
    }

    private static int getInvSize() {
        return 9;
    }
}

