/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.proxy;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.client.icon.IconProvider;
import org.cyclops.cyclopscore.client.key.IKeyRegistry;
import org.cyclops.cyclopscore.network.PacketHandler;
import org.cyclops.cyclopscore.proxy.CommonProxyComponent;
import org.cyclops.cyclopscore.proxy.IClientProxy;
import org.cyclops.cyclopscore.proxy.ICommonProxy;

public abstract class ClientProxyComponent
extends CommonProxyComponent
implements ICommonProxy,
IClientProxy {
    private final CommonProxyComponent commonProxyComponent;
    private final IconProvider iconProvider;
    protected final Map<BlockEntityType, BlockEntityRendererProvider> blockEntityRenderers = Maps.newHashMap();

    public ClientProxyComponent(CommonProxyComponent commonProxyComponent) {
        this.commonProxyComponent = commonProxyComponent;
        this.iconProvider = this.constructIconProvider();
    }

    protected IconProvider constructIconProvider() {
        return new IconProvider(this);
    }

    @Override
    public <T extends BlockEntity> void registerRenderer(BlockEntityType<? extends T> blockEntityType, BlockEntityRendererProvider<T> rendererFactory) {
        this.blockEntityRenderers.put(blockEntityType, rendererFactory);
    }

    @Override
    public void registerRenderers() {
        for (Map.Entry<BlockEntityType, BlockEntityRendererProvider> entry : this.blockEntityRenderers.entrySet()) {
            BlockEntityRenderers.m_173590_((BlockEntityType)entry.getKey(), (BlockEntityRendererProvider)entry.getValue());
            this.getMod().getLoggerHelper().log(Level.TRACE, String.format("Registered %s special renderer %s", entry.getKey(), entry.getValue()));
        }
    }

    @Override
    public void registerKeyBindings(IKeyRegistry keyRegistry, RegisterKeyMappingsEvent event) {
        this.getMod().getLoggerHelper().log(Level.TRACE, "Registered key bindings");
    }

    @Override
    public void registerPacketHandlers(PacketHandler packetHandler) {
        this.commonProxyComponent.registerPacketHandlers(packetHandler);
        this.getMod().getLoggerHelper().log(Level.TRACE, "Registered packet handlers");
    }

    @Override
    public void registerTickHandlers() {
        this.commonProxyComponent.registerTickHandlers();
        this.getMod().getLoggerHelper().log(Level.TRACE, "Registered tick handlers");
    }

    @Override
    public void registerEventHooks() {
        this.commonProxyComponent.registerEventHooks();
        this.getMod().getLoggerHelper().log(Level.TRACE, "Registered event hooks");
        MinecraftForge.EVENT_BUS.register((Object)this.getMod().getKeyRegistry());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientProxyComponent)) {
            return false;
        }
        ClientProxyComponent other = (ClientProxyComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CommonProxyComponent this$commonProxyComponent = this.getCommonProxyComponent();
        CommonProxyComponent other$commonProxyComponent = other.getCommonProxyComponent();
        if (this$commonProxyComponent == null ? other$commonProxyComponent != null : !this$commonProxyComponent.equals(other$commonProxyComponent)) {
            return false;
        }
        IconProvider this$iconProvider = this.getIconProvider();
        IconProvider other$iconProvider = other.getIconProvider();
        if (this$iconProvider == null ? other$iconProvider != null : !this$iconProvider.equals(other$iconProvider)) {
            return false;
        }
        Map<BlockEntityType, BlockEntityRendererProvider> this$blockEntityRenderers = this.getBlockEntityRenderers();
        Map<BlockEntityType, BlockEntityRendererProvider> other$blockEntityRenderers = other.getBlockEntityRenderers();
        return !(this$blockEntityRenderers == null ? other$blockEntityRenderers != null : !((Object)this$blockEntityRenderers).equals(other$blockEntityRenderers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientProxyComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CommonProxyComponent $commonProxyComponent = this.getCommonProxyComponent();
        result = result * 59 + ($commonProxyComponent == null ? 43 : $commonProxyComponent.hashCode());
        IconProvider $iconProvider = this.getIconProvider();
        result = result * 59 + ($iconProvider == null ? 43 : $iconProvider.hashCode());
        Map<BlockEntityType, BlockEntityRendererProvider> $blockEntityRenderers = this.getBlockEntityRenderers();
        result = result * 59 + ($blockEntityRenderers == null ? 43 : ((Object)$blockEntityRenderers).hashCode());
        return result;
    }

    public CommonProxyComponent getCommonProxyComponent() {
        return this.commonProxyComponent;
    }

    public IconProvider getIconProvider() {
        return this.iconProvider;
    }

    public Map<BlockEntityType, BlockEntityRendererProvider> getBlockEntityRenderers() {
        return this.blockEntityRenderers;
    }

    public String toString() {
        return "ClientProxyComponent(commonProxyComponent=" + String.valueOf(this.getCommonProxyComponent()) + ", iconProvider=" + String.valueOf(this.getIconProvider()) + ", blockEntityRenderers=" + String.valueOf(this.getBlockEntityRenderers()) + ")";
    }
}

