/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.collection;

import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.IngredientInstanceWrapper;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollectionMutable;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionAdapter;
import org.cyclops.cyclopscore.ingredient.collection.IngredientInstanceUnwrapperFunction;

public abstract class IngredientCollectionCollectionWrappedAdapter<T, M, C extends Collection<IngredientInstanceWrapper<T, M>>>
extends IngredientCollectionAdapter<T, M>
implements IIngredientCollectionMutable<T, M> {
    private final C collection;

    public IngredientCollectionCollectionWrappedAdapter(IngredientComponent<T, M> component, C collection) {
        super(component);
        this.collection = collection;
    }

    protected C getCollection() {
        return this.collection;
    }

    protected IngredientInstanceWrapper<T, M> wrap(T instance) {
        return this.getComponent().wrap(instance);
    }

    @Override
    public boolean add(T instance) {
        return this.getCollection().add(this.wrap(instance));
    }

    @Override
    public boolean remove(T instance) {
        return this.getCollection().remove(this.wrap(instance));
    }

    @Override
    public boolean contains(T instance) {
        return this.getCollection().contains(this.wrap(instance));
    }

    @Override
    public void clear() {
        this.getCollection().clear();
    }

    @Override
    public int size() {
        return this.getCollection().size();
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.transform(this.getCollection().iterator(), IngredientInstanceUnwrapperFunction.getInstance());
    }
}

