/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.cyclopscore.datastructure.DimPos;

public final class BlockEntityHelpers {
    public static boolean UNSAFE_BLOCK_ENTITY_GETTER = false;

    public static <T> Optional<T> get(DimPos dimPos, Class<T> targetClazz) {
        Level level = dimPos.getLevel(true);
        if (level == null) {
            return Optional.empty();
        }
        return BlockEntityHelpers.get((BlockGetter)level, dimPos.getBlockPos(), targetClazz);
    }

    public static <T> Optional<T> get(BlockGetter level, BlockPos pos, Class<T> targetClazz) {
        BlockEntity blockEntity;
        BlockEntity blockEntity2 = blockEntity = UNSAFE_BLOCK_ENTITY_GETTER && level instanceof Level && !((Level)level).m_5776_() && Thread.currentThread() != ((Level)level).m_7654_().m_6304_() ? BlockEntityHelpers.getLevelBlockEntityUnchecked((Level)level, pos) : level.m_7702_(pos);
        if (blockEntity == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(targetClazz.cast(blockEntity));
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    @Nullable
    static BlockEntity getLevelBlockEntityUnchecked(Level level, BlockPos pos) {
        if (level.m_151570_(pos)) {
            return null;
        }
        return level.m_46745_(pos).m_5685_(pos, LevelChunk.EntityCreationType.IMMEDIATE);
    }

    public static <C> LazyOptional<C> getCapability(DimPos dimPos, Capability<C> capability) {
        Level level = dimPos.getLevel(true);
        if (level == null) {
            return LazyOptional.empty();
        }
        return BlockEntityHelpers.getCapability((BlockGetter)level, dimPos.getBlockPos(), null, capability);
    }

    public static <C> LazyOptional<C> getCapability(DimPos dimPos, Direction side, Capability<C> capability) {
        Level level = dimPos.getLevel(true);
        if (level == null) {
            return LazyOptional.empty();
        }
        return BlockEntityHelpers.getCapability((BlockGetter)level, dimPos.getBlockPos(), side, capability);
    }

    public static <C> LazyOptional<C> getCapability(BlockGetter level, BlockPos pos, Capability<C> capability) {
        return BlockEntityHelpers.getCapability(level, pos, null, capability);
    }

    public static <C> LazyOptional<C> getCapability(BlockGetter level, BlockPos pos, Direction side, Capability<C> capability) {
        BlockEntity blockEntity = BlockEntityHelpers.get(level, pos, BlockEntity.class).orElse(null);
        if (blockEntity != null) {
            return blockEntity.getCapability(capability, side);
        }
        return LazyOptional.empty();
    }
}

