/*
 * Decompiled with CFR 0.152.
 */
package edivad.edivadlib.setup;

import edivad.edivadlib.Main;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.forgespi.language.IModInfo;

public class UpdateChecker {
    private final String modId;

    public UpdateChecker(String modId) {
        this.modId = modId;
    }

    @SubscribeEvent
    public void handlePlayerLoggedInEvent(ClientPlayerNetworkEvent.LoggingIn event) {
        try {
            IModInfo modInfo = (IModInfo)ModList.get().getModFileById(this.modId).getMods().get(0);
            String qualifier = modInfo.getVersion().getQualifier();
            if (qualifier != null && qualifier.contains("NONE")) {
                return;
            }
            VersionChecker.CheckResult versionRAW = VersionChecker.getResult((IModInfo)modInfo);
            if (versionRAW.target() == null) {
                return;
            }
            VersionChecker.Status status = versionRAW.status();
            LocalPlayer player = event.getPlayer();
            ArrayList<Object> messages = new ArrayList<Object>();
            if (status.equals((Object)VersionChecker.Status.OUTDATED) && versionRAW.changes().containsKey(versionRAW.target())) {
                String changes = (String)versionRAW.changes().get(versionRAW.target());
                messages.add(String.format("%s[%s]%s A new version is available (%s), please update!", ChatFormatting.GREEN, this.modId, ChatFormatting.WHITE, versionRAW.target()));
                messages.add(ChatFormatting.YELLOW + "Changelog:");
                Arrays.stream(changes.split("\n")).map(change -> ChatFormatting.WHITE + "- " + change).collect(Collectors.toCollection(() -> messages));
                if (versionRAW.changes().size() > 1) {
                    messages.add(ChatFormatting.WHITE + "- And more...");
                }
            }
            messages.stream().map(Component::m_237113_).forEach(message -> player.m_5661_((Component)message, false));
        }
        catch (Exception e) {
            Main.LOGGER.warn("Unable to check the version", (Throwable)e);
        }
    }
}

