/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.datagen;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.embeddedt.modernfix.ModernFix;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RuntimeDatagen {
    private static final String RESOURCES_OUT_DIR = RuntimeDatagen.getPropertyOrBlank("modernfix.datagen.output");
    private static final String RESOURCES_IN_DIR = RuntimeDatagen.getPropertyOrBlank("modernfix.datagen.existing");
    private static final String MODS_LIST = RuntimeDatagen.getPropertyOrBlank("modernfix.datagen.mods");
    private static final String EXISTING_MODS_LIST = RuntimeDatagen.getPropertyOrBlank("modernfix.datagen.existing_mods");
    private static final boolean IS_FLAT = Boolean.getBoolean("modernfix.datagen.flat");

    private static String getPropertyOrBlank(String name) {
        String val = System.getProperty(name);
        if (val == null || val.length() == 0) {
            return "";
        }
        return val;
    }

    public static boolean isDatagenAvailable() {
        return RESOURCES_OUT_DIR.length() > 0;
    }

    public static void runRuntimeDatagen() {
        ObfuscationReflectionHelper.setPrivateValue(DatagenModLoader.class, null, (Object)true, (String)"runningDataGen");
        HashSet mods = new HashSet(Arrays.stream(MODS_LIST.split(",")).collect(Collectors.toSet()));
        ModernFix.LOGGER.info("Beginning runtime datagen for " + mods.size() + " mods...");
        HashSet<String> existingMods = new HashSet<String>(Arrays.stream(EXISTING_MODS_LIST.split(",")).collect(Collectors.toSet()));
        HashSet existingPacks = new HashSet(Arrays.stream(RESOURCES_IN_DIR.split(",")).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toSet()));
        Path path = Paths.get(RESOURCES_OUT_DIR, new String[0]);
        GatherDataEvent.DataGeneratorConfig dataGeneratorConfig = new GatherDataEvent.DataGeneratorConfig(mods, path, Collections.emptyList(), true, true, true, true, true, mods.isEmpty() || IS_FLAT);
        if (!mods.contains("forge")) {
            existingMods.add("forge");
        }
        ExistingFileHelper existingFileHelper = new ExistingFileHelper(existingPacks, existingMods, true, null, null);
        MultiPackResourceManager manager = (MultiPackResourceManager)ObfuscationReflectionHelper.getPrivateValue(ExistingFileHelper.class, (Object)existingFileHelper, (String)"clientResources");
        ArrayList<VanillaPackResources> oldPacks = new ArrayList<VanillaPackResources>(manager.m_7536_().collect(Collectors.toList()));
        oldPacks.add(Minecraft.m_91087_().m_91100_().m_118555_());
        ObfuscationReflectionHelper.setPrivateValue(ExistingFileHelper.class, (Object)existingFileHelper, (Object)new MultiPackResourceManager(PackType.CLIENT_RESOURCES, oldPacks), (String)"clientResources");
        ModLoader.get().runEventGenerator(mc -> new GatherDataEvent(mc, dataGeneratorConfig.makeGenerator(p -> dataGeneratorConfig.isFlat() ? p : p.resolve(mc.getModId()), dataGeneratorConfig.getMods().contains(mc.getModId())), dataGeneratorConfig, existingFileHelper));
        dataGeneratorConfig.runAll();
        ObfuscationReflectionHelper.setPrivateValue(DatagenModLoader.class, null, (Object)false, (String)"runningDataGen");
        ModernFix.LOGGER.info("Finished runtime datagen.");
    }

    @SubscribeEvent
    public static void onInitTitleScreen(ScreenEvent.Init.Post event) {
        if (RuntimeDatagen.isDatagenAvailable() && event.getScreen() instanceof TitleScreen) {
            TitleScreen screen = (TitleScreen)event.getScreen();
            screen.m_142416_((GuiEventListener)new Button(screen.f_96543_ / 2 - 100 - 50, screen.f_96544_ / 4 + 48, 50, 20, (Component)Component.m_237113_((String)"DG"), arg -> RuntimeDatagen.runRuntimeDatagen()));
        }
    }
}

