/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.helper;

import com.lothrazar.simpletomb.helper.CuriosHelper;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityHelper {
    public static final String NBT_PLAYER_PERSISTED = "PlayerPersisted";

    public static boolean autoEquip(ItemStack stack, Player player) {
        if (stack.m_41619_()) {
            return false;
        }
        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (registryName == null) {
            return false;
        }
        if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44975_, (ItemStack)stack) > 0) {
            return false;
        }
        if (stack.m_41741_() == 1) {
            if (ModList.get().isLoaded("curios") && CuriosHelper.autoEquip(stack, player)) {
                return true;
            }
            if (player.m_21206_().m_41619_() && stack.m_41720_().canPerformAction(stack, ToolActions.SHIELD_BLOCK)) {
                player.m_8061_(EquipmentSlot.OFFHAND, stack.m_41777_());
                return true;
            }
            EquipmentSlot slot = stack.m_41720_().getEquipmentSlot(stack);
            boolean isElytra = false;
            if (slot == null) {
                if (stack.m_41720_() instanceof ArmorItem) {
                    slot = ((ArmorItem)stack.m_41720_()).m_40402_();
                } else {
                    if (!(stack.m_41720_() instanceof ElytraItem)) {
                        return false;
                    }
                    slot = EquipmentSlot.CHEST;
                    isElytra = true;
                }
            } else if (slot == EquipmentSlot.CHEST) {
                isElytra = stack.m_41720_() instanceof ElytraItem;
            }
            int slotId = slot.m_20749_();
            ItemStack stackInSlot = (ItemStack)player.m_150109_().f_35975_.get(slotId);
            if (stackInSlot.m_41619_()) {
                player.m_150109_().f_35975_.set(slotId, (Object)stack.m_41777_());
                return true;
            }
            if (slot != EquipmentSlot.CHEST) {
                return false;
            }
            if (isElytra) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stackInSlot.m_41777_());
                player.m_150109_().f_35975_.set(slotId, (Object)stack.m_41777_());
                return true;
            }
        }
        return false;
    }

    public static boolean isValidPlayer(@Nullable Entity entity) {
        return entity instanceof Player && !(entity instanceof FakePlayer);
    }

    public static boolean isValidPlayerMP(@Nullable Entity entity) {
        return EntityHelper.isValidPlayer(entity) && !entity.f_19853_.f_46443_;
    }

    public static CompoundTag getPersistentTag(Player player) {
        CompoundTag persistentData = player.getPersistentData();
        if (persistentData.m_128441_(NBT_PLAYER_PERSISTED)) {
            CompoundTag persistentTag = (CompoundTag)persistentData.m_128423_(NBT_PLAYER_PERSISTED);
            return persistentTag;
        }
        CompoundTag persistentTag = new CompoundTag();
        persistentData.m_128365_(NBT_PLAYER_PERSISTED, (Tag)persistentTag);
        return persistentTag;
    }
}

