/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.event;

import com.lothrazar.simpletomb.ModTomb;
import com.lothrazar.simpletomb.TombRegistry;
import com.lothrazar.simpletomb.block.BlockEntityTomb;
import com.lothrazar.simpletomb.data.LocationBlockPos;
import com.lothrazar.simpletomb.data.PlayerTombRecords;
import com.lothrazar.simpletomb.data.TombCommands;
import com.lothrazar.simpletomb.event.PlayerTombEvents;
import com.lothrazar.simpletomb.helper.WorldHelper;
import com.lothrazar.simpletomb.item.GraveKeyItem;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CommandEvents {
    private static final String ARG_SELECTED = "selected";
    private static final String ARG_PLAYER = "player";

    @SubscribeEvent
    public void onRegisterCommandsEvent(RegisterCommandsEvent event) {
        CommandDispatcher r = event.getDispatcher();
        r.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"simpletomb").requires(p -> p.m_6761_(3))).then(Commands.m_82127_((String)TombCommands.RESTORE.toString()).then(Commands.m_82129_((String)ARG_PLAYER, (ArgumentType)GameProfileArgument.m_94584_()).suggests((cs, b) -> this.buildPlayerArg((CommandContext<CommandSourceStack>)cs, b)).then(Commands.m_82129_((String)ARG_SELECTED, (ArgumentType)IntegerArgumentType.integer()).executes(x -> this.exeRestore((CommandContext<CommandSourceStack>)x, this.getPlayerProfile((CommandContext<CommandSourceStack>)x), IntegerArgumentType.getInteger((CommandContext)x, (String)ARG_SELECTED))))))).then(Commands.m_82127_((String)TombCommands.KEY.toString()).then(Commands.m_82129_((String)ARG_PLAYER, (ArgumentType)GameProfileArgument.m_94584_()).suggests((cs, b) -> this.buildPlayerArg((CommandContext<CommandSourceStack>)cs, b)).then(Commands.m_82129_((String)ARG_SELECTED, (ArgumentType)IntegerArgumentType.integer()).executes(x -> this.exeKey((CommandContext<CommandSourceStack>)x, this.getPlayerProfile((CommandContext<CommandSourceStack>)x), IntegerArgumentType.getInteger((CommandContext)x, (String)ARG_SELECTED))))))).then(Commands.m_82127_((String)TombCommands.LIST.toString()).then(Commands.m_82129_((String)ARG_PLAYER, (ArgumentType)GameProfileArgument.m_94584_()).suggests((cs, b) -> this.buildPlayerArg((CommandContext<CommandSourceStack>)cs, b)).executes(x -> this.exeList((CommandContext<CommandSourceStack>)x, this.getPlayerProfile((CommandContext<CommandSourceStack>)x)))))).then(Commands.m_82127_((String)TombCommands.DELETE.toString()).then(Commands.m_82129_((String)ARG_PLAYER, (ArgumentType)GameProfileArgument.m_94584_()).suggests((cs, b) -> this.buildPlayerArg((CommandContext<CommandSourceStack>)cs, b)).executes(x -> this.exeDelete((CommandContext<CommandSourceStack>)x, this.getPlayerProfile((CommandContext<CommandSourceStack>)x))))));
    }

    private CompletableFuture<Suggestions> buildPlayerArg(CommandContext<CommandSourceStack> cs, SuggestionsBuilder b) {
        return SharedSuggestionProvider.m_82981_(((CommandSourceStack)cs.getSource()).m_81377_().m_6846_().m_11314_().stream().map(p -> p.m_36316_().getName()), (SuggestionsBuilder)b);
    }

    private GameProfile getPlayerProfile(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return GameProfileArgument.m_94590_(ctx, (String)ARG_PLAYER).stream().findFirst().orElse(null);
    }

    private int exeDelete(CommandContext<CommandSourceStack> ctx, GameProfile target) throws CommandSyntaxException {
        PlayerTombRecords found = ModTomb.GLOBAL.findGrave(target.getId());
        if (found != null) {
            int previous = found.playerGraves.size();
            found.deleteAll();
            MutableComponent msg = Component.m_237115_((String)("Deleted: " + previous));
            msg.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD));
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)msg, false);
        }
        return 0;
    }

    private int exeList(CommandContext<CommandSourceStack> ctx, GameProfile target) throws CommandSyntaxException {
        PlayerTombRecords found = ModTomb.GLOBAL.findGrave(target.getId());
        if (found != null && found.playerGraves.size() > 0) {
            for (int i = 0; i < found.playerGraves.size(); ++i) {
                MutableComponent msg = Component.m_237115_((String)found.toDisplayString(i));
                msg.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD));
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)msg, false);
            }
        } else {
            MutableComponent msg = Component.m_237115_((String)"Found: #0");
            msg.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD));
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)msg, false);
        }
        return 0;
    }

    private int exeKey(CommandContext<CommandSourceStack> ctx, GameProfile target, int index) throws CommandSyntaxException {
        PlayerTombRecords found = ModTomb.GLOBAL.findGrave(target.getId());
        if (found != null) {
            CompoundTag grave = found.playerGraves.get(index);
            if (grave == null) {
                ModTomb.LOGGER.error("Invalid grave index " + index + "; try between 0 and  " + (found.playerGraves.size() - 1));
                return 1;
            }
            LocationBlockPos spawnPos = new LocationBlockPos(PlayerTombRecords.getPos(grave), PlayerTombRecords.getDim(grave));
            ItemStack key = new ItemStack((ItemLike)TombRegistry.GRAVE_KEY.get());
            ((GraveKeyItem)((Object)TombRegistry.GRAVE_KEY.get())).setTombPos(key, spawnPos);
            PlayerTombEvents.putKeyName(target.getName(), key);
            MutableComponent msg = Component.m_237115_((String)("Attempting to give the key for tomb [" + index + "] to player " + target.getName() + ":" + target.getId()));
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)msg, false);
            ServerPlayer user = ((CommandSourceStack)ctx.getSource()).m_81377_().m_6846_().m_11259_(target.getId());
            ItemHandlerHelper.giveItemToPlayer((Player)user, (ItemStack)key);
        }
        return 0;
    }

    private int exeRestore(CommandContext<CommandSourceStack> ctx, GameProfile target, int index) throws CommandSyntaxException {
        MutableComponent msg = Component.m_237115_((String)("Attempting to restore tomb [" + index + "] for player " + target.getName() + ":" + target.getId()));
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)msg, false);
        PlayerTombRecords found = ModTomb.GLOBAL.findGrave(target.getId());
        if (found != null) {
            BlockState state;
            CompoundTag grave = found.playerGraves.get(index);
            if (grave == null) {
                ModTomb.LOGGER.error("Invalid grave index " + index + "; try between 0 and  " + (found.playerGraves.size() - 1));
                return 1;
            }
            BlockPos pos = PlayerTombRecords.getPos(grave);
            String dim = PlayerTombRecords.getDim(grave);
            List<ItemStack> drops = PlayerTombRecords.getDrops(grave);
            ResourceKey dimKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)ResourceLocation.m_135820_((String)dim));
            ServerLevel targetWorld = ((CommandSourceStack)ctx.getSource()).m_81372_().m_7654_().m_129880_(dimKey);
            boolean wasPlaced = WorldHelper.placeGrave((Level)targetWorld, pos, state = PlayerTombEvents.getRandomGrave(targetWorld, Direction.NORTH));
            if (wasPlaced) {
                BlockEntityTomb tile = (BlockEntityTomb)targetWorld.m_7702_(pos);
                tile.initTombstoneOwner(target);
                IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
                for (ItemStack d : drops) {
                    ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)d.m_41777_(), (boolean)false);
                }
            }
            msg = Component.m_237115_((String)("Restored tomb with at [" + pos + "] in " + dim));
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)msg, false);
        }
        return 0;
    }
}

