/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.custom.HerbDryingRack;
import net.joefoxe.hexerei.tileentity.DryingRackTile;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallDryingRack
extends HerbDryingRack {
    public static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)2.0, (double)6.0, (double)12.0, (double)14.0, (double)7.0, (double)14.0), Block.m_49796_((double)1.0, (double)5.0, (double)14.0, (double)15.0, (double)9.0, (double)15.0), Block.m_49796_((double)0.0, (double)4.0, (double)15.0, (double)16.0, (double)10.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape SHAPE_90 = Stream.of(Block.m_49796_((double)2.0, (double)6.0, (double)2.0, (double)4.0, (double)7.0, (double)14.0), Block.m_49796_((double)1.0, (double)5.0, (double)1.0, (double)2.0, (double)9.0, (double)15.0), Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)1.0, (double)10.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape SHAPE_180 = Stream.of(Block.m_49796_((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)7.0, (double)4.0), Block.m_49796_((double)1.0, (double)5.0, (double)1.0, (double)15.0, (double)9.0, (double)2.0), Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)10.0, (double)1.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape SHAPE_270 = Stream.of(Block.m_49796_((double)12.0, (double)6.0, (double)2.0, (double)14.0, (double)7.0, (double)14.0), Block.m_49796_((double)14.0, (double)5.0, (double)1.0, (double)15.0, (double)9.0, (double)15.0), Block.m_49796_((double)15.0, (double)4.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape SHAPE_LEFT = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)14.0, (double)6.0, (double)12.0, (double)16.0, (double)7.0, (double)14.0), (VoxelShape)Block.m_49796_((double)15.0, (double)5.0, (double)14.0, (double)16.0, (double)9.0, (double)15.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape SHAPE_LEFT_90 = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)2.0, (double)6.0, (double)14.0, (double)4.0, (double)7.0, (double)16.0), (VoxelShape)Block.m_49796_((double)1.0, (double)5.0, (double)15.0, (double)2.0, (double)9.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape SHAPE_LEFT_180 = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)2.0, (double)2.0, (double)7.0, (double)4.0), (VoxelShape)Block.m_49796_((double)0.0, (double)5.0, (double)1.0, (double)1.0, (double)9.0, (double)2.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape SHAPE_LEFT_270 = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)12.0, (double)6.0, (double)0.0, (double)14.0, (double)7.0, (double)2.0), (VoxelShape)Block.m_49796_((double)14.0, (double)5.0, (double)0.0, (double)15.0, (double)9.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape SHAPE_RIGHT = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)12.0, (double)2.0, (double)7.0, (double)14.0), (VoxelShape)Block.m_49796_((double)0.0, (double)5.0, (double)14.0, (double)1.0, (double)9.0, (double)15.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape SHAPE_RIGHT_90 = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)2.0, (double)6.0, (double)0.0, (double)4.0, (double)7.0, (double)2.0), (VoxelShape)Block.m_49796_((double)1.0, (double)5.0, (double)0.0, (double)2.0, (double)9.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape SHAPE_RIGHT_180 = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)14.0, (double)6.0, (double)2.0, (double)16.0, (double)7.0, (double)4.0), (VoxelShape)Block.m_49796_((double)15.0, (double)5.0, (double)1.0, (double)16.0, (double)9.0, (double)2.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape SHAPE_RIGHT_270 = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)12.0, (double)6.0, (double)14.0, (double)14.0, (double)7.0, (double)16.0), (VoxelShape)Block.m_49796_((double)14.0, (double)5.0, (double)15.0, (double)15.0, (double)9.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.SOUTH, (Object)SHAPE, (Object)Direction.NORTH, (Object)SHAPE_180, (Object)Direction.WEST, (Object)SHAPE_90, (Object)Direction.EAST, (Object)SHAPE_270));
    private static final Map<Direction, VoxelShape> AABBS_LEFT = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.SOUTH, (Object)SHAPE_LEFT, (Object)Direction.NORTH, (Object)SHAPE_LEFT_180, (Object)Direction.WEST, (Object)SHAPE_LEFT_90, (Object)Direction.EAST, (Object)SHAPE_LEFT_270));
    private static final Map<Direction, VoxelShape> AABBS_RIGHT = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.SOUTH, (Object)SHAPE_RIGHT, (Object)Direction.NORTH, (Object)SHAPE_RIGHT_180, (Object)Direction.WEST, (Object)SHAPE_RIGHT_90, (Object)Direction.EAST, (Object)SHAPE_RIGHT_270));
    public static BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static BooleanProperty RIGHT = BooleanProperty.m_61465_((String)"right");
    public static BooleanProperty LEFT = BooleanProperty.m_61465_((String)"left");

    @Override
    public RenderShape m_7514_(BlockState iBlockState) {
        return RenderShape.MODEL;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        Level iblockreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        return (BlockState)((BlockState)this.updateSides((BlockGetter)iblockreader, blockpos, super.m_5573_(context)).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)context.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity instanceof DryingRackTile) {
            ((DryingRackTile)tileEntity).interactDryingRack(player, hit);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public VoxelShape m_5940_(BlockState pState, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        boolean left = (Boolean)pState.m_61143_((Property)LEFT);
        boolean right = (Boolean)pState.m_61143_((Property)RIGHT);
        if (!left && right) {
            return Stream.of(AABBS_RIGHT.get(pState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), AABBS.get(pState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_))).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
        }
        if (!right && left) {
            return Stream.of(AABBS_LEFT.get(pState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), AABBS.get(pState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_))).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
        }
        if (right && left) {
            return Stream.of(AABBS_LEFT.get(pState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), AABBS_RIGHT.get(pState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), AABBS.get(pState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_))).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
        }
        return AABBS.get(pState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_));
    }

    public WallDryingRack(BlockBehaviour.Properties properties) {
        super(properties.m_60910_());
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HorizontalDirectionalBlock.f_54117_, WATERLOGGED, NORTH, SOUTH, EAST, WEST, LEFT, RIGHT});
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    protected BlockState updateSides(BlockGetter world, BlockPos pos, BlockState state) {
        BlockState bs_north = world.m_8055_(pos.m_122012_());
        BlockState bs_east = world.m_8055_(pos.m_122029_());
        BlockState bs_south = world.m_8055_(pos.m_122019_());
        BlockState bs_west = world.m_8055_(pos.m_122024_());
        Direction dir = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        boolean north = bs_north.m_60734_() == this && bs_north.m_61138_((Property)HorizontalDirectionalBlock.f_54117_) && bs_north.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == dir;
        boolean south = bs_south.m_60734_() == this && bs_south.m_61138_((Property)HorizontalDirectionalBlock.f_54117_) && bs_south.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == dir;
        boolean east = bs_east.m_60734_() == this && bs_east.m_61138_((Property)HorizontalDirectionalBlock.f_54117_) && bs_east.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == dir;
        boolean west = bs_west.m_60734_() == this && bs_west.m_61138_((Property)HorizontalDirectionalBlock.f_54117_) && bs_west.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == dir;
        boolean left = dir == Direction.NORTH && west || dir == Direction.WEST && south || dir == Direction.SOUTH && east || dir == Direction.EAST && north;
        boolean right = dir == Direction.NORTH && east || dir == Direction.WEST && north || dir == Direction.SOUTH && west || dir == Direction.EAST && south;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west))).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(left))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(right));
    }

    @Override
    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        if (state.m_61138_((Property)WATERLOGGED) && ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(this.updateSides((BlockGetter)world, pos, state), facing, facingState, world, pos, facingPos);
    }

    @Override
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Override
    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return pLevel.m_8055_(pPos.m_121945_((Direction)pState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_))).m_60767_().m_76333_();
    }

    @Override
    public Class<DryingRackTile> getTileEntityClass() {
        return DryingRackTile.class;
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DryingRackTile((BlockEntityType)ModTileEntities.DRYING_RACK_TILE.get(), pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> entityType) {
        return entityType == ModTileEntities.DRYING_RACK_TILE.get() ? (world2, pos, state2, entity) -> ((DryingRackTile)entity).tick() : null;
    }
}

