/*
 * Decompiled with CFR 0.152.
 */
package tfar.metalbarrels.container;

import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import tfar.metalbarrels.MetalBarrels;
import tfar.metalbarrels.init.ModMenuTypes;
import tfar.metalbarrels.tile.MetalBarrelBlockEntity;

public class MetalBarrelContainer
extends AbstractContainerMenu {
    protected Player playerEntity;
    private final ContainerLevelAccess callable;
    public int width;
    public int height;

    public MetalBarrelContainer(MenuType<?> containerType, int id, Inventory playerInventory, int width, int height, int containerX, int containerY, int playerX, int playerY, ContainerLevelAccess callable) {
        super(containerType, id);
        int j;
        int i;
        this.width = width;
        this.height = height;
        this.playerEntity = playerInventory.f_35978_;
        this.callable = callable;
        ItemStackHandler stackHandler = callable.m_6721_(Level::m_7702_).map(MetalBarrelBlockEntity.class::cast).map(metalBarrelBlockEntity -> metalBarrelBlockEntity.handler).orElse(new ItemStackHandler(width * height));
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)stackHandler, j + width * i, containerX + j * 18, containerY + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, j * 18 + playerX, i * 18 + playerY));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, i * 18 + playerX, playerY + 58));
        }
    }

    public static MetalBarrelContainer copper(int id, Inventory playerInventory) {
        return MetalBarrelContainer.copperS(id, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public static MetalBarrelContainer iron(int id, Inventory playerInventory) {
        return MetalBarrelContainer.ironS(id, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public static MetalBarrelContainer silver(int id, Inventory playerInventory) {
        return MetalBarrelContainer.silverS(id, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public static MetalBarrelContainer gold(int id, Inventory playerInventory) {
        return MetalBarrelContainer.goldS(id, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public static MetalBarrelContainer diamond(int id, Inventory playerInventory) {
        return MetalBarrelContainer.diamondS(id, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public static MetalBarrelContainer netherite(int id, Inventory playerInventory) {
        return MetalBarrelContainer.netheriteS(id, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public static MetalBarrelContainer copperS(int id, Inventory playerInventory, ContainerLevelAccess callable) {
        return new MetalBarrelContainer(ModMenuTypes.COPPER, id, playerInventory, 9, 5, 8, 18, 8, 122, callable);
    }

    public static MetalBarrelContainer ironS(int id, Inventory playerInventory, ContainerLevelAccess callable) {
        return new MetalBarrelContainer(ModMenuTypes.IRON, id, playerInventory, 9, 6, 8, 18, 8, 140, callable);
    }

    public static MetalBarrelContainer silverS(int id, Inventory playerInventory, ContainerLevelAccess callable) {
        return new MetalBarrelContainer(ModMenuTypes.SILVER, id, playerInventory, 9, 8, 8, 18, 8, 176, callable);
    }

    public static MetalBarrelContainer goldS(int id, Inventory playerInventory, ContainerLevelAccess callable) {
        return new MetalBarrelContainer(ModMenuTypes.GOLD, id, playerInventory, 9, 9, 8, 18, 8, 194, callable);
    }

    public static MetalBarrelContainer diamondS(int id, Inventory playerInventory, ContainerLevelAccess callable) {
        return new MetalBarrelContainer(ModMenuTypes.DIAMOND, id, playerInventory, 12, 9, 8, 18, 35, 194, callable);
    }

    public static MetalBarrelContainer netheriteS(int id, Inventory playerInventory, ContainerLevelAccess callable) {
        return new MetalBarrelContainer(ModMenuTypes.NETHERITE, id, playerInventory, 15, 9, 8, 18, 62, 194, callable);
    }

    public boolean m_6875_(@Nonnull Player playerIn) {
        return true;
    }

    @Nonnull
    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.height * this.width ? !this.m_38903_(itemstack1, this.height * this.width, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.height * this.width, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.callable.m_39292_((world, pos) -> {
            BlockEntity tileEntity = world.m_7702_(pos);
            if (tileEntity == null) {
                MetalBarrels.logger.warn("unexpected null on container close");
                return;
            }
            MetalBarrelBlockEntity metalBarrelBlockEntity = (MetalBarrelBlockEntity)tileEntity;
            if (!playerIn.m_5833_()) {
                --metalBarrelBlockEntity.players;
            }
            if (metalBarrelBlockEntity.players <= 0) {
                metalBarrelBlockEntity.soundStuff(tileEntity.m_58900_(), SoundEvents.f_11724_);
                metalBarrelBlockEntity.changeState(playerIn.f_19853_.m_8055_(tileEntity.m_58899_()), false);
            }
        });
    }
}

