/*
 * Decompiled with CFR 0.152.
 */
package elocindev.create_questing.forge;

import com.mojang.logging.LogUtils;
import elocindev.create_questing.forge.config.ConfigBuilder;
import elocindev.create_questing.forge.config.ConfigEntries;
import elocindev.create_questing.forge.registry.ItemRegistry;
import elocindev.create_questing.forge.theme.ThemeSetup;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.resource.PathPackResources;
import org.slf4j.Logger;

@Mod(value="create_questing")
@Mod.EventBusSubscriber(modid="create_questing", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CreateQuesting {
    public static final String MODID = "create_questing";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static ConfigEntries Config = ConfigBuilder.loadConfig();

    public CreateQuesting() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ItemRegistry.REGISTRY.register(bus);
    }

    private void setup(FMLCommonSetupEvent event) {
        Config = ConfigBuilder.loadConfig();
        ThemeSetup.setup();
        LOGGER.info("Loaded Create Questing Config");
    }

    @SubscribeEvent
    public static void addPackFinders(AddPackFindersEvent event) {
        try {
            if (event.getPackType() == PackType.CLIENT_RESOURCES) {
                Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"quest_shapes"});
                PathPackResources pack = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + resourcePath, resourcePath);
                PackMetadataSection metadataSection = (PackMetadataSection)pack.m_5550_((MetadataSectionSerializer)PackMetadataSection.f_10366_);
                if (metadataSection != null) {
                    event.addRepositorySource((packConsumer, packConstructor) -> packConsumer.accept(packConstructor.create("builtin/create_questing", (Component)Component.m_237113_((String)"Create Styled Quest Shapes"), false, () -> pack, metadataSection, Pack.Position.TOP, PackSource.f_10528_, false)));
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

