/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.save;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.tainted.save.SaveTemplateProvider;
import com.direwolf20.buildinggadgets.common.tainted.save.TemplateSave;
import com.direwolf20.buildinggadgets.common.tainted.save.UndoWorldSave;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;

public enum SaveManager {
    INSTANCE;

    private SaveTemplateProvider templateProvider = new SaveTemplateProvider(this::getTemplateSave);
    private TemplateSave templateSave;
    private List<UndoSaveContainer> undoSaves = new LinkedList<UndoSaveContainer>();

    public Supplier<UndoWorldSave> registerUndoSave(Function<ServerLevel, UndoWorldSave> ctrFun) {
        UndoSaveContainer container = new UndoSaveContainer(Objects.requireNonNull(ctrFun));
        this.undoSaves.add(container);
        return container::getCurrentSave;
    }

    public void onServerStarted(ServerStartedEvent event) {
        BuildingGadgets.LOG.debug("Loading World Saves.");
        ServerLevel world = event.getServer().m_129880_(Level.f_46428_);
        for (UndoSaveContainer c : this.undoSaves) {
            c.acquire(world);
        }
        this.templateSave = SaveManager.getTemplateSave(world, "buildinggadgets_template_save");
        BuildingGadgets.LOG.debug("Finished Loading saves");
    }

    public void onServerStopped(ServerStoppedEvent event) {
        BuildingGadgets.LOG.debug("Clearing save caches");
        for (UndoSaveContainer c : this.undoSaves) {
            c.release();
        }
        this.templateSave = null;
        BuildingGadgets.LOG.debug("Finished clearing save caches");
    }

    public static UndoWorldSave getUndoSave(ServerLevel world, IntSupplier maxLengthSupplier, String name) {
        return (UndoWorldSave)world.m_8895_().m_164861_(UndoWorldSave::loads, () -> new UndoWorldSave(maxLengthSupplier), name);
    }

    private static TemplateSave getTemplateSave(ServerLevel world, String name) {
        return (TemplateSave)world.m_8895_().m_164861_(TemplateSave::loads, TemplateSave::new, name);
    }

    public SaveTemplateProvider getTemplateProvider() {
        return this.templateProvider;
    }

    public TemplateSave getTemplateSave() {
        return this.templateSave;
    }

    private static final class UndoSaveContainer {
        private final Function<ServerLevel, UndoWorldSave> constructor;
        @Nullable
        private UndoWorldSave currentSave;

        private UndoSaveContainer(Function<ServerLevel, UndoWorldSave> constructor) {
            this.constructor = constructor;
            this.currentSave = null;
        }

        private void acquire(ServerLevel world) {
            this.currentSave = this.constructor.apply(world);
        }

        @Nullable
        private UndoWorldSave getCurrentSave() {
            return this.currentSave;
        }

        private void release() {
            this.currentSave = null;
        }
    }
}

