/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.building.placement;

import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.google.common.collect.AbstractIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class ConnectedSurface
implements Iterable<BlockPos> {
    private final BlockGetter world;
    private final Region searchingRegion;
    private final Function<BlockPos, BlockPos> searching2referenceMapper;
    private final BlockPos searchingCenter;
    @Nullable
    private final Direction side;
    private final BiPredicate<BlockState, BlockPos> predicate;

    public static ConnectedSurface create(Region searchingRegion, BlockGetter world, BlockPos searchingCenter, Direction side, int range, boolean fuzzy) {
        return ConnectedSurface.create(searchingRegion, world, pos -> pos.m_121945_(side), searchingCenter, side, range, fuzzy);
    }

    public static ConnectedSurface create(Region searchingRegion, BlockGetter world, Function<BlockPos, BlockPos> searching2referenceMapper, BlockPos searchingCenter, Direction side, int range, boolean fuzzy) {
        return ConnectedSurface.create(world, searchingRegion, searching2referenceMapper, searchingCenter, side, fuzzy);
    }

    public static ConnectedSurface create(BlockGetter world, Region searchingRegion, Function<BlockPos, BlockPos> searching2referenceMapper, BlockPos searchingCenter, @Nullable Direction side, boolean fuzzy) {
        return new ConnectedSurface(world, searchingRegion, searching2referenceMapper, searchingCenter, side, fuzzy);
    }

    public static ConnectedSurface create(BlockGetter world, Region searchingRegion, Function<BlockPos, BlockPos> searching2referenceMapper, BlockPos searchingCenter, @Nullable Direction side, BiPredicate<BlockState, BlockPos> predicate) {
        return new ConnectedSurface(world, searchingRegion, searching2referenceMapper, searchingCenter, side, predicate);
    }

    ConnectedSurface(BlockGetter world, Region searchingRegion, Function<BlockPos, BlockPos> searching2referenceMapper, BlockPos searchingCenter, @Nullable Direction side, boolean fuzzy) {
        this(world, searchingRegion, searching2referenceMapper, searchingCenter, side, (filter, pos) -> {
            BlockState reference = world.m_8055_((BlockPos)searching2referenceMapper.apply((BlockPos)pos));
            boolean isAir = reference.m_60795_();
            return !isAir && (fuzzy || filter == reference);
        });
    }

    ConnectedSurface(BlockGetter world, Region searchingRegion, Function<BlockPos, BlockPos> searching2referenceMapper, BlockPos searchingCenter, @Nullable Direction side, BiPredicate<BlockState, BlockPos> predicate) {
        this.world = world;
        this.searchingRegion = searchingRegion;
        this.searching2referenceMapper = searching2referenceMapper;
        this.searchingCenter = searchingCenter;
        this.side = side;
        this.predicate = predicate;
    }

    public Region getBoundingBox() {
        return this.searchingRegion;
    }

    @Override
    @Nonnull
    public Iterator<BlockPos> iterator() {
        final BlockState selectedBlock = this.getReferenceFor(this.searchingCenter);
        return new AbstractIterator<BlockPos>(){
            private Queue<BlockPos> queue = new LinkedList<BlockPos>();
            private Set<BlockPos> searched;
            {
                this.searched = new HashSet<BlockPos>(ConnectedSurface.this.searchingRegion.size());
                if (this.isValid(ConnectedSurface.this.searchingCenter)) {
                    this.queue.add(ConnectedSurface.this.searchingCenter);
                    this.searched.add(ConnectedSurface.this.searchingCenter);
                }
            }

            protected BlockPos computeNext() {
                if (this.queue.isEmpty()) {
                    return (BlockPos)this.endOfData();
                }
                BlockPos current = this.queue.remove();
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        if (ConnectedSurface.this.side != null) {
                            BlockPos neighbor = ConnectedSurface.this.perpendicularSurfaceOffset(current, ConnectedSurface.this.side.m_122434_(), i, j);
                            this.addNeighbour(neighbor);
                            continue;
                        }
                        for (int k = -1; k <= 1; ++k) {
                            BlockPos neighbor = current.m_7918_(i, j, k);
                            this.addNeighbour(neighbor);
                        }
                    }
                }
                return current;
            }

            private void addNeighbour(BlockPos neighbor) {
                boolean isSearched;
                boolean bl = isSearched = !this.searched.add(neighbor);
                if (isSearched || !this.isValid(neighbor)) {
                    return;
                }
                this.queue.add(neighbor);
            }

            private boolean isValid(BlockPos pos) {
                return ConnectedSurface.this.searchingRegion.contains((Vec3i)pos) && ConnectedSurface.this.predicate.test(selectedBlock, pos);
            }
        };
    }

    private BlockState getReferenceFor(BlockPos pos) {
        return this.world.m_8055_(this.searching2referenceMapper.apply(pos));
    }

    public BlockPos perpendicularSurfaceOffset(BlockPos pos, Direction.Axis intersector, int i, int j) {
        switch (intersector) {
            case X: {
                return pos.m_7918_(0, i, j);
            }
            case Y: {
                return pos.m_7918_(i, 0, j);
            }
            case Z: {
                return pos.m_7918_(i, j, 0);
            }
        }
        throw new IllegalArgumentException("Unknown facing " + intersector);
    }
}

