/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.entities;

import com.direwolf20.buildinggadgets.common.blocks.ConstructionBlock;
import com.direwolf20.buildinggadgets.common.blocks.ConstructionBlockPowder;
import com.direwolf20.buildinggadgets.common.blocks.OurBlocks;
import com.direwolf20.buildinggadgets.common.entities.EntityBase;
import com.direwolf20.buildinggadgets.common.entities.OurEntities;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tileentities.ConstructionBlockTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;

public class ConstructionBlockEntity
extends EntityBase {
    private static final EntityDataAccessor<BlockPos> FIXED = SynchedEntityData.m_135353_(ConstructionBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> MAKING = SynchedEntityData.m_135353_(ConstructionBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public ConstructionBlockEntity(Level world, BlockPos spawnPos, boolean makePaste) {
        this((EntityType)OurEntities.CONSTRUCTION_BLOCK_ENTITY.get(), world);
        this.m_6034_(spawnPos.m_123341_(), spawnPos.m_123342_(), spawnPos.m_123343_());
        this.targetPos = spawnPos;
        this.setMakingPaste(makePaste);
    }

    public ConstructionBlockEntity(EntityType<?> constructionBlockEntityEntityType, Level level) {
        super(constructionBlockEntityEntityType, level);
    }

    public ConstructionBlockEntity(Level level) {
        super((EntityType)OurEntities.CONSTRUCTION_BLOCK_ENTITY.get(), level);
    }

    @Override
    protected int getMaxLife() {
        return 80;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(FIXED, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(MAKING, (Object)false);
    }

    @Override
    protected boolean shouldSetDespawning() {
        if (super.shouldSetDespawning()) {
            return true;
        }
        if (this.targetPos == null) {
            return false;
        }
        Block block = this.f_19853_.m_8055_(this.targetPos).m_60734_();
        return !(block instanceof ConstructionBlock) && !(block instanceof ConstructionBlockPowder);
    }

    @Override
    protected void onSetDespawning() {
        if (this.targetPos != null) {
            if (!this.getMakingPaste()) {
                BlockEntity te = this.f_19853_.m_7702_(this.targetPos);
                if (te instanceof ConstructionBlockTileEntity) {
                    BlockData tempState = ((ConstructionBlockTileEntity)te).getConstructionBlockData();
                    boolean opaque = tempState.getState().m_60804_((BlockGetter)this.f_19853_, this.targetPos);
                    boolean neighborBrightness = false;
                    boolean ambient = false;
                    if (opaque || neighborBrightness || !ambient) {
                        BlockData tempSetBlock = ((ConstructionBlockTileEntity)te).getConstructionBlockData();
                        this.f_19853_.m_46597_(this.targetPos, (BlockState)((BlockState)((BlockState)((Block)OurBlocks.CONSTRUCTION_BLOCK.get()).m_49966_().m_61124_(ConstructionBlock.BRIGHT, (Comparable)Boolean.valueOf(!opaque))).m_61124_(ConstructionBlock.NEIGHBOR_BRIGHTNESS, (Comparable)Boolean.valueOf(neighborBrightness))).m_61124_(ConstructionBlock.AMBIENT_OCCLUSION, (Comparable)Boolean.valueOf(ambient)));
                        te = this.f_19853_.m_7702_(this.targetPos);
                        if (te instanceof ConstructionBlockTileEntity) {
                            ((ConstructionBlockTileEntity)te).setBlockState(tempSetBlock);
                        }
                    }
                }
            } else if (this.f_19853_.m_8055_(this.targetPos) == ((Block)OurBlocks.CONSTRUCTION_POWDER_BLOCK.get()).m_49966_()) {
                this.f_19853_.m_46597_(this.targetPos, ((Block)OurBlocks.CONSTRUCTION_DENSE_BLOCK.get()).m_49966_());
            }
        }
    }

    public void setMakingPaste(boolean paste) {
        this.f_19804_.m_135381_(MAKING, (Object)paste);
    }

    public boolean getMakingPaste() {
        return (Boolean)this.f_19804_.m_135370_(MAKING);
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setMakingPaste(compound.m_128471_("makingPaste"));
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("makingPaste", this.getMakingPaste());
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

