/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client;

import com.direwolf20.buildinggadgets.client.screen.TemplateManagerGUI;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.OurItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

@JeiPlugin
public class BuildingGadgetsJEI
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("buildinggadgets", "jei_plugin");
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(TemplateManagerGUI.class, (IGuiContainerHandler)new GuiContainerHandler());
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        ArrayList<Item> gadgets = new ArrayList<Item>(){
            {
                this.add((Item)OurItems.BUILDING_GADGET_ITEM.get());
                this.add((Item)OurItems.EXCHANGING_GADGET_ITEM.get());
                this.add((Item)OurItems.DESTRUCTION_GADGET_ITEM.get());
                this.add((Item)OurItems.COPY_PASTE_GADGET_ITEM.get());
            }
        };
        for (Item gadget : gadgets) {
            registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)gadget, (ingredient, uidContext) -> {
                if (!(ingredient.m_41720_() instanceof AbstractGadget)) {
                    return "";
                }
                double energy = ingredient.m_41784_().m_128459_("energy");
                if (energy == 0.0) {
                    return "empty";
                }
                if (energy == (double)((AbstractGadget)ingredient.m_41720_()).getEnergyMax()) {
                    return "charged";
                }
                return "";
            });
        }
    }

    private static class GuiContainerHandler
    implements IGuiContainerHandler<TemplateManagerGUI> {
        private GuiContainerHandler() {
        }

        public List<Rect2i> getGuiExtraAreas(TemplateManagerGUI containerScreen) {
            return new ArrayList<Rect2i>(Collections.singleton(new Rect2i(containerScreen.f_96543_ / 2 + 80, containerScreen.f_96544_ / 2 - 80, 60, 120)));
        }
    }
}

