/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.container;

import earth.terrarium.ad_astra.common.config.WaterPumpConfig;
import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.fluid.FluidContainer;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import earth.terrarium.botarium.api.fluid.FluidSnapshot;
import earth.terrarium.botarium.api.fluid.UpdatingFluidContainer;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class WaterPumpFluidTank
implements UpdatingFluidContainer<BlockEntity> {
    private FluidHolder tank;
    private final Updatable updatable;

    public WaterPumpFluidTank(FluidHolder tank, Updatable updatable) {
        this.tank = tank;
        this.updatable = updatable;
    }

    public WaterPumpFluidTank(Updatable updatable) {
        this(FluidHooks.emptyFluid(), updatable);
    }

    public long insertFluid(FluidHolder fluid, boolean simulate) {
        return 0L;
    }

    public long insertInternal(FluidHolder fluid, boolean simulate) {
        if (fluid.isEmpty()) {
            return 0L;
        }
        if (this.tank.isEmpty()) {
            CompoundTag compound = fluid.getCompound() != null ? fluid.getCompound().m_6426_() : null;
            FluidHolder fluidHolder = FluidHooks.newFluidHolder((Fluid)fluid.getFluid(), (long)Math.min(this.getTankCapacity(0), fluid.getFluidAmount()), (CompoundTag)compound);
            if (!simulate) {
                this.tank = fluidHolder;
            }
            return fluidHolder.getFluidAmount();
        }
        if (!this.tank.getFluid().equals(fluid.getFluid())) {
            return 0L;
        }
        long amount = Math.min(this.getTankCapacity(0) - this.tank.getFluidAmount(), fluid.getFluidAmount());
        if (!simulate) {
            this.tank.setAmount(this.tank.getFluidAmount() + amount);
        }
        return amount;
    }

    public FluidHolder extractFluid(FluidHolder fluid, boolean simulate) {
        if (this.tank.isEmpty()) {
            return FluidHooks.emptyFluid();
        }
        if (fluid.isEmpty()) {
            return FluidHooks.emptyFluid();
        }
        if (!fluid.getFluid().equals(Fluids.f_76193_)) {
            return FluidHooks.emptyFluid();
        }
        if (!Objects.equals(fluid.getCompound(), this.tank.getCompound())) {
            return FluidHooks.emptyFluid();
        }
        long amount = Math.min(this.tank.getFluidAmount(), fluid.getFluidAmount());
        if (!simulate) {
            this.tank.setAmount(this.tank.getFluidAmount() - amount);
        }
        CompoundTag compound = fluid.getCompound() != null ? fluid.getCompound().m_6426_() : null;
        return FluidHooks.newFluidHolder((Fluid)fluid.getFluid(), (long)amount, (CompoundTag)compound);
    }

    public void setFluid(int slot, FluidHolder fluid) {
        if (slot == 0 && fluid.getFluid().equals(Fluids.f_76193_)) {
            this.tank = fluid.copyHolder();
        }
    }

    public List<FluidHolder> getFluids() {
        return List.of(this.tank);
    }

    public int getSize() {
        return 1;
    }

    public boolean isEmpty() {
        return this.tank.isEmpty();
    }

    public FluidContainer copy() {
        return new WaterPumpFluidTank(this.tank.copyHolder(), this.updatable);
    }

    public long getTankCapacity(int tankSlot) {
        return WaterPumpConfig.tankSize;
    }

    public void fromContainer(FluidContainer container) {
        this.tank = ((FluidHolder)container.getFluids().get(0)).copyHolder();
    }

    public long extractFromSlot(FluidHolder fluidHolder, FluidHolder toInsert, Runnable snapshot) {
        if (Objects.equals(fluidHolder.getCompound(), toInsert.getCompound()) && fluidHolder.getFluid().m_6212_(toInsert.getFluid())) {
            long amount = Mth.m_14053_((long)toInsert.getFluidAmount(), (long)0L, (long)fluidHolder.getFluidAmount());
            snapshot.run();
            fluidHolder.setAmount(fluidHolder.getFluidAmount() - amount);
            if (fluidHolder.getFluidAmount() == 0L) {
                fluidHolder.setFluid(Fluids.f_76191_);
            }
            return amount;
        }
        return 0L;
    }

    public boolean allowsInsertion() {
        return false;
    }

    public boolean allowsExtraction() {
        return true;
    }

    public FluidSnapshot createSnapshot() {
        return new WaterPumpSnapshot(this.tank);
    }

    public void deserialize(CompoundTag nbtCompound) {
        this.tank = FluidHooks.fluidFromCompound((CompoundTag)nbtCompound.m_128469_("Tank"));
    }

    public CompoundTag serialize(CompoundTag nbtCompound) {
        nbtCompound.m_128365_("Tank", (Tag)this.tank.serialize());
        return nbtCompound;
    }

    public void update(BlockEntity block) {
        this.updatable.update();
    }

    private record WaterPumpSnapshot(FluidHolder tank) implements FluidSnapshot
    {
        private WaterPumpSnapshot(FluidHolder tank) {
            this.tank = tank.copyHolder();
        }

        public void loadSnapshot(FluidContainer container) {
            container.setFluid(0, this.tank);
        }
    }
}

