/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.resourcepack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import earth.terrarium.ad_astra.AdAstra;
import earth.terrarium.ad_astra.client.AdAstraClient;
import earth.terrarium.ad_astra.client.dimension.ClientModSkies;
import earth.terrarium.ad_astra.client.resourcepack.Galaxy;
import earth.terrarium.ad_astra.client.resourcepack.PlanetRing;
import earth.terrarium.ad_astra.client.resourcepack.PlanetSkyRenderer;
import earth.terrarium.ad_astra.client.resourcepack.SolarSystem;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class PlanetResources
implements ResourceManagerReloadListener {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public void m_6213_(ResourceManager manager) {
        JsonObject jsonObject;
        InputStreamReader reader;
        ArrayList<PlanetSkyRenderer> skyRenderers = new ArrayList<PlanetSkyRenderer>();
        ArrayList<SolarSystem> solarSystems = new ArrayList<SolarSystem>();
        ArrayList<PlanetRing> planetRings = new ArrayList<PlanetRing>();
        ArrayList<Galaxy> galaxies = new ArrayList<Galaxy>();
        for (ResourceLocation id : manager.m_214159_("planet_resources/sky_renderers", path -> path.m_135815_().endsWith(".json")).keySet()) {
            try {
                for (Resource resource : manager.m_213829_(id)) {
                    reader = new InputStreamReader(resource.m_215507_());
                    jsonObject = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                    if (jsonObject == null) continue;
                    skyRenderers.add((PlanetSkyRenderer)PlanetSkyRenderer.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(false, arg_0 -> ((Logger)AdAstra.LOGGER).error(arg_0)));
                }
            }
            catch (Exception e) {
                AdAstra.LOGGER.error("Failed to load Ad Astra sky rendering assets from: \"" + id.toString() + "\"", (Throwable)e);
                e.printStackTrace();
            }
        }
        for (ResourceLocation id : manager.m_214159_("planet_resources/solar_systems", path -> path.m_135815_().endsWith(".json")).keySet()) {
            try {
                for (Resource resource : manager.m_213829_(id)) {
                    reader = new InputStreamReader(resource.m_215507_());
                    jsonObject = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                    if (jsonObject == null) continue;
                    solarSystems.add((SolarSystem)SolarSystem.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(false, arg_0 -> ((Logger)AdAstra.LOGGER).error(arg_0)));
                }
            }
            catch (Exception e) {
                AdAstra.LOGGER.error("Failed to load Ad Astra solar system assets from: \"" + id.toString() + "\"", (Throwable)e);
                e.printStackTrace();
            }
        }
        for (ResourceLocation id : manager.m_214159_("planet_resources/planet_rings", path -> path.m_135815_().endsWith(".json")).keySet()) {
            try {
                for (Resource resource : manager.m_213829_(id)) {
                    reader = new InputStreamReader(resource.m_215507_());
                    jsonObject = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                    if (jsonObject == null) continue;
                    planetRings.add((PlanetRing)PlanetRing.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(false, arg_0 -> ((Logger)AdAstra.LOGGER).error(arg_0)));
                }
            }
            catch (Exception e) {
                AdAstra.LOGGER.error("Failed to load Ad Astra planet ring assets from: \"" + id.toString() + "\"", (Throwable)e);
                e.printStackTrace();
            }
        }
        for (ResourceLocation id : manager.m_214159_("planet_resources/galaxy", path -> path.m_135815_().endsWith(".json")).keySet()) {
            try {
                for (Resource resource : manager.m_213829_(id)) {
                    reader = new InputStreamReader(resource.m_215507_());
                    jsonObject = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                    if (jsonObject == null) continue;
                    galaxies.add((Galaxy)Galaxy.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(false, arg_0 -> ((Logger)AdAstra.LOGGER).error(arg_0)));
                }
            }
            catch (Exception e) {
                AdAstra.LOGGER.error("Failed to load Ad Astra galaxy assets from: \"" + id.toString() + "\"", (Throwable)e);
                e.printStackTrace();
            }
        }
        solarSystems.sort(Comparator.comparing(SolarSystem::solarSystem));
        galaxies.sort(Comparator.comparing(Galaxy::galaxy));
        AdAstraClient.skyRenderers = skyRenderers;
        AdAstraClient.solarSystems = solarSystems;
        AdAstraClient.planetRings = planetRings;
        AdAstraClient.galaxies = galaxies;
        ClientModSkies.register();
    }
}

