/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.registry;

import com.mrbysco.forcecraft.entities.AngryEndermanEntity;
import com.mrbysco.forcecraft.entities.ChuChuEntity;
import com.mrbysco.forcecraft.entities.ColdChickenEntity;
import com.mrbysco.forcecraft.entities.ColdCowEntity;
import com.mrbysco.forcecraft.entities.ColdPigEntity;
import com.mrbysco.forcecraft.entities.CreeperTotEntity;
import com.mrbysco.forcecraft.entities.EnderTotEntity;
import com.mrbysco.forcecraft.entities.FairyEntity;
import com.mrbysco.forcecraft.entities.projectile.FlaskEntity;
import com.mrbysco.forcecraft.entities.projectile.ForceArrowEntity;
import com.mrbysco.forcecraft.items.nonburnable.NonBurnableItemEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ForceEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"forcecraft");
    public static final RegistryObject<EntityType<NonBurnableItemEntity>> NON_BURNABLE_ITEM = ENTITY_TYPES.register("non_burnable_item", () -> ForceEntities.register("non_burnable_item", EntityType.Builder.m_20704_(NonBurnableItemEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20702_(6).m_20717_(20)));
    public static final RegistryObject<EntityType<ColdChickenEntity>> COLD_CHICKEN = ENTITY_TYPES.register("cold_chicken", () -> ForceEntities.register("cold_chicken", EntityType.Builder.m_20704_(ColdChickenEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.4f, 0.7f).m_20702_(10)));
    public static final RegistryObject<EntityType<ColdCowEntity>> COLD_COW = ENTITY_TYPES.register("cold_cow", () -> ForceEntities.register("cold_cow", EntityType.Builder.m_20704_(ColdCowEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.4f).m_20702_(10)));
    public static final RegistryObject<EntityType<ColdPigEntity>> COLD_PIG = ENTITY_TYPES.register("cold_pig", () -> ForceEntities.register("cold_pig", EntityType.Builder.m_20704_(ColdPigEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 0.9f).m_20702_(10)));
    public static final RegistryObject<EntityType<FairyEntity>> FAIRY = ENTITY_TYPES.register("fairy", () -> ForceEntities.register("fairy", EntityType.Builder.m_20704_(FairyEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.5f, 0.5f).m_20702_(10)));
    public static final RegistryObject<EntityType<ChuChuEntity>> RED_CHU_CHU = ENTITY_TYPES.register("red_chu_chu", () -> ForceEntities.register("red_chu_chu", EntityType.Builder.m_20704_(ChuChuEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(2.04f, 2.04f).m_20702_(10)));
    public static final RegistryObject<EntityType<ChuChuEntity>> GREEN_CHU_CHU = ENTITY_TYPES.register("green_chu_chu", () -> ForceEntities.register("green_chu_chu", EntityType.Builder.m_20704_(ChuChuEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(2.04f, 2.04f).m_20702_(10)));
    public static final RegistryObject<EntityType<ChuChuEntity>> BLUE_CHU_CHU = ENTITY_TYPES.register("blue_chu_chu", () -> ForceEntities.register("blue_chu_chu", EntityType.Builder.m_20704_(ChuChuEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(2.04f, 2.04f).m_20702_(10)));
    public static final RegistryObject<EntityType<ChuChuEntity>> GOLD_CHU_CHU = ENTITY_TYPES.register("gold_chu_chu", () -> ForceEntities.register("gold_chu_chu", EntityType.Builder.m_20704_(ChuChuEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(2.04f, 2.04f).m_20702_(10)));
    public static final RegistryObject<EntityType<CreeperTotEntity>> CREEPER_TOT = ENTITY_TYPES.register("creeper_tot", () -> ForceEntities.register("creeper_tot", EntityType.Builder.m_20704_(CreeperTotEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.1f).m_20702_(8)));
    public static final RegistryObject<EntityType<EnderTotEntity>> ENDER_TOT = ENTITY_TYPES.register("ender_tot", () -> ForceEntities.register("ender_tot", EntityType.Builder.m_20704_(EnderTotEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.6f).m_20702_(8)));
    public static final RegistryObject<EntityType<AngryEndermanEntity>> ANGRY_ENDERMAN = ENTITY_TYPES.register("angry_enderman", () -> ForceEntities.register("angry_enderman", EntityType.Builder.m_20704_(AngryEndermanEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 2.9f).m_20702_(8)));
    public static final RegistryObject<EntityType<ForceArrowEntity>> FORCE_ARROW = ENTITY_TYPES.register("force_arrow", () -> ForceEntities.register("force_arrow", EntityType.Builder.m_20704_(ForceArrowEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(20)));
    public static final RegistryObject<EntityType<FlaskEntity>> FORCE_FLASK = ENTITY_TYPES.register("force_flask", () -> ForceEntities.register("force_flask", EntityType.Builder.m_20704_(FlaskEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).setCustomClientFactory(FlaskEntity::new).m_20702_(4).m_20717_(10)));

    public static void registerSpawnPlacement(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)RED_CHU_CHU.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ChuChuEntity::canSpawnHere, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)GREEN_CHU_CHU.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ChuChuEntity::canSpawnHere, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)BLUE_CHU_CHU.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ChuChuEntity::canSpawnHere, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)GOLD_CHU_CHU.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ChuChuEntity::canSpawnHere, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)CREEPER_TOT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)ENDER_TOT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)FAIRY.get(), SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING, FairyEntity::canSpawnOn, SpawnPlacementRegisterEvent.Operation.AND);
    }

    public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)COLD_CHICKEN.get(), ColdChickenEntity.generateAttributes().m_22265_());
        event.put((EntityType)COLD_COW.get(), ColdCowEntity.generateAttributes().m_22265_());
        event.put((EntityType)COLD_PIG.get(), ColdPigEntity.generateAttributes().m_22265_());
        event.put((EntityType)RED_CHU_CHU.get(), Monster.m_33035_().m_22265_());
        event.put((EntityType)GREEN_CHU_CHU.get(), Monster.m_33035_().m_22265_());
        event.put((EntityType)BLUE_CHU_CHU.get(), Monster.m_33035_().m_22265_());
        event.put((EntityType)GOLD_CHU_CHU.get(), Monster.m_33035_().m_22265_());
        event.put((EntityType)CREEPER_TOT.get(), CreeperTotEntity.generateAttributes().m_22265_());
        event.put((EntityType)ENDER_TOT.get(), EnderTotEntity.generateAttributes().m_22265_());
        event.put((EntityType)ANGRY_ENDERMAN.get(), AngryEndermanEntity.generateAttributes().m_22265_());
        event.put((EntityType)FAIRY.get(), FairyEntity.generateAttributes().m_22265_());
    }

    public static <T extends Entity> EntityType<T> register(String id, EntityType.Builder<T> builder) {
        return builder.m_20712_(id);
    }
}

