/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.networking.message;

import com.mrbysco.forcecraft.items.ForceBeltItem;
import com.mrbysco.forcecraft.storage.BeltStorage;
import com.mrbysco.forcecraft.storage.StorageManager;
import com.mrbysco.forcecraft.util.FindingUtil;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkEvent;

public class QuickUseBeltMessage {
    public int slot;

    public QuickUseBeltMessage(int slot) {
        this.slot = slot;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.slot);
    }

    public static QuickUseBeltMessage decode(FriendlyByteBuf packetBuffer) {
        return new QuickUseBeltMessage(packetBuffer.readInt());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ItemStack beltStack;
            Predicate<ItemStack> stackPredicate;
            ServerPlayer player;
            if (ctx.getDirection().getReceptionSide().isServer() && ctx.getSender() != null && FindingUtil.hasSingleStackInHotbar((Player)(player = ctx.getSender()), stackPredicate = stack -> stack.m_41720_() instanceof ForceBeltItem) && !(beltStack = FindingUtil.findInstanceStack((Player)player, stackPredicate)).m_41619_()) {
                Optional<BeltStorage> data = StorageManager.getBelt(beltStack);
                data.ifPresent(belt -> {
                    IItemHandler handler = belt.getInventory();
                    ItemStack stack = handler.getStackInSlot(this.slot);
                    Level level = player.f_19853_;
                    if (!stack.m_41619_()) {
                        stack.m_41671_(level, (LivingEntity)player);
                        level.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), stack.m_41615_(), player.m_5720_(), 0.5f, player.f_19853_.f_46441_.m_188501_() * 0.1f + 0.9f);
                    }
                });
            }
        });
        ctx.setPacketHandled(true);
    }
}

