/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.flask;

import com.mrbysco.forcecraft.items.flask.ForceFilledForceFlask;
import com.mrbysco.forcecraft.items.flask.MilkFlaskItem;
import com.mrbysco.forcecraft.registry.ForceFluids;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.registry.ForceTags;
import javax.annotation.Nonnull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple;

public class FlaskFluidHandler
extends FluidHandlerItemStackSimple {
    public FlaskFluidHandler(@Nonnull ItemStack container) {
        super(container, 1000);
    }

    public int getTankCapacity(int tank) {
        return 1000;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    @Nonnull
    public FluidStack getFluid() {
        Item item = this.container.m_41720_();
        if (item instanceof ForceFilledForceFlask) {
            return new FluidStack((Fluid)ForceFluids.FORCE_FLUID_SOURCE.get(), 1000);
        }
        if (item instanceof MilkFlaskItem && ForgeMod.MILK.isPresent()) {
            return new FluidStack((Fluid)ForgeMod.MILK.get(), 1000);
        }
        return FluidStack.EMPTY;
    }

    public boolean canFillFluidType(FluidStack stack) {
        return stack.getFluid().m_205067_(ForceTags.FORCE) || ForgeMod.MILK.isPresent() && stack.getFluid().m_205067_(ForceTags.MILK);
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.canFillFluidType(stack);
    }

    protected void setContainerToEmpty() {
        this.container = new ItemStack((ItemLike)ForceRegistry.FORCE_FLASK.get());
    }

    protected void setFluid(FluidStack stack) {
        if (stack.isEmpty()) {
            this.setContainerToEmpty();
        } else {
            if (stack.getFluid().m_205067_(ForceTags.FORCE)) {
                this.container = new ItemStack((ItemLike)ForceRegistry.FORCE_FILLED_FORCE_FLASK.get());
                return;
            }
            if (ForgeMod.MILK.isPresent() && stack.getFluid().m_205067_(ForceTags.MILK)) {
                this.container = new ItemStack((ItemLike)ForceRegistry.MILK_FORCE_FLASK.get());
                return;
            }
        }
    }
}

