/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.handlers;

import com.mrbysco.forcecraft.capabilities.CapabilityHandler;
import com.mrbysco.forcecraft.capabilities.toolmodifier.IToolModifier;
import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.items.ForceArmorItem;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerCapHandler {
    private static final int SPEED_DURATION = 200;

    @SubscribeEvent
    public void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.f_19853_.f_46443_) {
            Player player = event.player;
            Iterable armor = player.m_6168_();
            int speed = 0;
            for (ItemStack slotSelected : armor) {
                IToolModifier modifierCap;
                if (!(slotSelected.m_41720_() instanceof ForceArmorItem) || (modifierCap = (IToolModifier)slotSelected.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) == null) continue;
                speed += modifierCap.getSpeedLevel();
            }
            if (speed > 0) {
                MobEffectInstance speedEffect = new MobEffectInstance(MobEffects.f_19596_, 200, speed - 1, false, false);
                if (!player.m_21023_(MobEffects.f_19596_) || player.m_21023_(MobEffects.f_19596_) && player.m_21124_(MobEffects.f_19596_).m_19557_() <= 100) {
                    player.m_7292_(speedEffect);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerCapHandler.updateArmorProperties(event.getEntity());
    }

    @SubscribeEvent
    public void equipmentChangeEvent(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            PlayerCapHandler.updateArmorProperties(player);
        }
    }

    public static void updateArmorProperties(Player player) {
        Iterable armor = player.m_6168_();
        int armorPieces = 0;
        int damage = 0;
        int heat = 0;
        int luck = 0;
        int bane = 0;
        int bleed = 0;
        for (ItemStack slotSelected : armor) {
            IToolModifier modifierCap;
            if (!(slotSelected.m_41720_() instanceof ForceArmorItem) || (modifierCap = (IToolModifier)slotSelected.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) == null) continue;
            ++armorPieces;
            damage += (int)((double)modifierCap.getSharpLevel() * (Double)ConfigHandler.COMMON.forcePunchDamage.get());
            if (modifierCap.hasHeat()) {
                ++heat;
            }
            if (modifierCap.hasLuck()) {
                ++luck;
            }
            if (modifierCap.hasBane()) {
                ++bane;
            }
            if (!modifierCap.hasBleed()) continue;
            bleed += modifierCap.getBleedLevel();
        }
        int finalArmorPieces = armorPieces;
        player.getCapability(CapabilityHandler.CAPABILITY_PLAYERMOD).ifPresent(cap -> cap.setArmorPieces(finalArmorPieces));
        int finalDamage = damage;
        player.getCapability(CapabilityHandler.CAPABILITY_PLAYERMOD).ifPresent(cap -> cap.setAttackDamage(1.0f * (float)finalDamage));
        int finalHeat = heat;
        player.getCapability(CapabilityHandler.CAPABILITY_PLAYERMOD).ifPresent(cap -> {
            cap.setHeatPieces(finalHeat);
            cap.setHeatDamage(2.0f * (float)finalHeat);
        });
        int finalLuck = luck;
        player.getCapability(CapabilityHandler.CAPABILITY_PLAYERMOD).ifPresent(cap -> cap.setLuckLevel(finalLuck));
        int finalBane = bane;
        player.getCapability(CapabilityHandler.CAPABILITY_PLAYERMOD).ifPresent(cap -> cap.setBane(finalBane > 0));
        int finalBleed = bleed;
        player.getCapability(CapabilityHandler.CAPABILITY_PLAYERMOD).ifPresent(cap -> cap.setBleeding(finalBleed));
    }

    @SubscribeEvent
    public void harvestCheckEvent(PlayerEvent.HarvestCheck event) {
        Player player = event.getEntity();
        player.getCapability(CapabilityHandler.CAPABILITY_PLAYERMOD).ifPresent(cap -> {
            if (cap.hasFullSet() && player.m_21205_().m_41619_() && event.getTargetBlock().m_60734_().m_7325_() <= 2.0f) {
                event.setCanHarvest(true);
            }
        });
    }

    @SubscribeEvent
    public void breakSpeedEvent(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        player.getCapability(CapabilityHandler.CAPABILITY_PLAYERMOD).ifPresent(cap -> {
            if (cap.hasFullSet() && player.m_21205_().m_41619_() && event.getOriginalSpeed() < 6.0f) {
                event.setNewSpeed(6.0f);
            }
        });
    }
}

