/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blockentities;

import com.mrbysco.forcecraft.ForceCraft;
import com.mrbysco.forcecraft.blockentities.InfuserBlockEntity;
import com.mrbysco.forcecraft.capabilities.CapabilityHandler;
import com.mrbysco.forcecraft.capabilities.forcerod.IForceRodModifier;
import com.mrbysco.forcecraft.capabilities.toolmodifier.IToolModifier;
import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.items.ForceArmorItem;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookData;
import com.mrbysco.forcecraft.items.tools.ForceAxeItem;
import com.mrbysco.forcecraft.items.tools.ForceBowItem;
import com.mrbysco.forcecraft.items.tools.ForcePickaxeItem;
import com.mrbysco.forcecraft.items.tools.ForceRodItem;
import com.mrbysco.forcecraft.items.tools.ForceShovelItem;
import com.mrbysco.forcecraft.items.tools.ForceSwordItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public enum InfuserModifierType {
    SPEED,
    HEAT,
    FORCE,
    SILK,
    DAMAGE,
    FORTUNE,
    LIGHT,
    STURDY,
    LUMBERJACK,
    HEALING,
    ENDER,
    BLEEDING,
    BANE,
    WING,
    CAMO,
    RAINBOW,
    TIME,
    PACK1,
    PACK2,
    PACK3,
    PACK4,
    GRINDING,
    FREEZING,
    EXP,
    STORAGE,
    SIGHT,
    TREASURE,
    ITEM;


    public boolean apply(ItemStack tool, ItemStack mod, UpgradeBookData bd) {
        switch (this) {
            case DAMAGE: {
                return InfuserBlockEntity.addDamageModifier(tool);
            }
            case ENDER: {
                return InfuserBlockEntity.addEnderModifier(tool);
            }
            case FORCE: {
                return InfuserBlockEntity.addForceModifier(tool);
            }
            case HEALING: {
                return InfuserBlockEntity.addHealingModifier(tool);
            }
            case HEAT: {
                return InfuserBlockEntity.addHeatModifier(tool);
            }
            case LIGHT: {
                return InfuserBlockEntity.addLightModifier(tool);
            }
            case FORTUNE: {
                return InfuserBlockEntity.addLuckModifier(tool);
            }
            case LUMBERJACK: {
                return InfuserBlockEntity.addLumberjackModifier(tool);
            }
            case SILK: {
                return InfuserBlockEntity.addSilkTouchModifier(tool);
            }
            case SPEED: {
                return InfuserBlockEntity.addSpeedModifier(tool);
            }
            case STURDY: {
                return InfuserBlockEntity.addSturdyModifier(tool);
            }
            case CAMO: {
                return InfuserBlockEntity.applyCamo(tool, mod);
            }
            case BANE: {
                return InfuserBlockEntity.addBaneModifier(tool);
            }
            case BLEEDING: {
                return InfuserBlockEntity.addBleedingModifier(tool);
            }
            case WING: {
                return InfuserBlockEntity.addWingModifier(tool);
            }
            case RAINBOW: {
                return InfuserBlockEntity.addRainbowModifier(tool);
            }
            case TIME: {
                break;
            }
            case TREASURE: {
                return InfuserBlockEntity.addTreasureModifier(tool);
            }
            case PACK1: 
            case PACK2: 
            case PACK3: 
            case PACK4: {
                return InfuserBlockEntity.upgradeBag(tool, bd);
            }
            case ITEM: {
                return true;
            }
            case EXP: {
                break;
            }
            case FREEZING: {
                return InfuserBlockEntity.addFreezingModifier(tool);
            }
            case GRINDING: {
                break;
            }
            case SIGHT: {
                break;
            }
        }
        ForceCraft.LOGGER.error("Error: No action for modifier {}", (Object)this);
        return false;
    }

    public int getLevelCap(ItemStack centerStack) {
        Item item = centerStack.m_41720_();
        switch (this) {
            case DAMAGE: {
                IToolModifier modifierCap;
                if (item instanceof ForceSwordItem || item instanceof ForceBowItem) {
                    IToolModifier modifierCap2 = (IToolModifier)centerStack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
                    if (modifierCap2 == null) break;
                    return (Integer)ConfigHandler.COMMON.damageCap.get();
                }
                if (!(item instanceof ForceArmorItem) || (modifierCap = (IToolModifier)centerStack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) == null) break;
                return 1;
            }
            case ENDER: 
            case HEAT: 
            case LIGHT: 
            case LUMBERJACK: 
            case SILK: 
            case CAMO: 
            case BANE: 
            case WING: 
            case RAINBOW: 
            case TREASURE: 
            case PACK1: 
            case PACK2: 
            case PACK3: 
            case PACK4: 
            case ITEM: 
            case EXP: 
            case FREEZING: 
            case GRINDING: 
            case SIGHT: 
            case STORAGE: {
                return 1;
            }
            case FORCE: {
                IToolModifier modifierCap;
                if (!(item instanceof ForceSwordItem) && !(item instanceof ForceAxeItem) || (modifierCap = (IToolModifier)centerStack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) == null) break;
                return (Integer)ConfigHandler.COMMON.forceCap.get();
            }
            case HEALING: {
                IForceRodModifier rodCap;
                if (!(item instanceof ForceRodItem) || (rodCap = (IForceRodModifier)centerStack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).orElse(null)) == null) break;
                return (Integer)ConfigHandler.COMMON.healingCap.get();
            }
            case FORTUNE: {
                return (Integer)ConfigHandler.COMMON.luckCap.get();
            }
            case SPEED: {
                IForceRodModifier rodCap;
                if (item instanceof ForceShovelItem || item instanceof ForcePickaxeItem || item instanceof ForceAxeItem) {
                    IToolModifier modifierCap = (IToolModifier)centerStack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
                    if (modifierCap == null) break;
                    return (Integer)ConfigHandler.COMMON.speedCap.get();
                }
                if (item instanceof ForceBowItem) {
                    IToolModifier modifierCap = (IToolModifier)centerStack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
                    if (modifierCap == null) break;
                    return 1;
                }
                if (item instanceof ForceArmorItem) {
                    IToolModifier modifierCap = (IToolModifier)centerStack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
                    if (modifierCap == null) break;
                    return 1;
                }
                if (!(item instanceof ForceRodItem) || (rodCap = (IForceRodModifier)centerStack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).orElse(null)) == null) break;
                return (Integer)ConfigHandler.COMMON.rodSpeedCap.get();
            }
            case STURDY: {
                IToolModifier modifierCap;
                if (item instanceof ForceSwordItem || item instanceof ForceAxeItem || item instanceof ForceShovelItem || item instanceof ForcePickaxeItem || item instanceof ForceRodItem) {
                    IToolModifier modifierCap3 = (IToolModifier)centerStack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
                    if (modifierCap3 == null) break;
                    return (Integer)ConfigHandler.COMMON.sturdyToolCap.get();
                }
                if (!(item instanceof ForceArmorItem) || (modifierCap = (IToolModifier)centerStack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) == null) break;
                return 1;
            }
            case BLEEDING: {
                IToolModifier modifierCap;
                if (!(item instanceof ForceSwordItem) && !(item instanceof ForceBowItem) && !(item instanceof ForceArmorItem) || (modifierCap = (IToolModifier)centerStack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) == null) break;
                return (Integer)ConfigHandler.COMMON.bleedCap.get();
            }
            case TIME: {
                if (!((Boolean)ConfigHandler.COMMON.timeTorchEnabled.get()).booleanValue()) break;
                return 1;
            }
        }
        return 0;
    }

    public String getTooltip() {
        return "gui.forcecraft.infuser.tooltip." + this.name().toLowerCase();
    }
}

