/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.orderform.requests;

import java.lang.reflect.Type;
import java.util.ArrayList;
import net.creeperhost.minetogether.lib.web.ApiRequest;
import net.creeperhost.minetogether.lib.web.ApiResponse;
import net.creeperhost.minetogether.lib.web.WebUtils;
import net.creeperhost.minetogether.orderform.data.Order;
import net.creeperhost.minetogether.util.ModPackInfo;
import net.minecraft.util.StringUtil;
import org.jetbrains.annotations.Nullable;

public class PostOrderRequest
extends ApiRequest<Response> {
    public PostOrderRequest(Order order, String dcId, String pregen, String fallbackName) {
        super("POST", "https://www.creeperhost.net/json/order/" + order.clientID + "/" + order.productID + "/" + dcId, (Type)((Object)Response.class));
        this.requiredAuthHeaders.add("Fingerprint");
        this.requiredAuthHeaders.add("Identifier");
        ArrayList<WebUtils.UrlParamPair> entries = new ArrayList<WebUtils.UrlParamPair>();
        entries.add(WebUtils.UrlParamPair.of("name", order.name));
        entries.add(WebUtils.UrlParamPair.of("swid", ModPackInfo.getInfo().websiteID));
        if (order.pregen) {
            entries.add(WebUtils.UrlParamPair.of("pregen", pregen));
        }
        if (!StringUtil.m_14408_((String)order.worldUrl)) {
            entries.add(WebUtils.UrlParamPair.of("worldUrl", order.worldUrl));
        }
        if (!StringUtil.m_14408_((String)fallbackName)) {
            entries.add(WebUtils.UrlParamPair.of("fallback", fallbackName));
        }
        this.formBody(entries);
    }

    public static class Response
    extends ApiResponse {
        public Data more;

        public Response(@Nullable String status, @Nullable String message) {
            super(status, message);
        }
    }

    public static class Data {
        public String invoiceid;
        public String orderid;
    }
}

