/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.orderform.requests;

import java.lang.reflect.Type;
import java.util.ArrayList;
import net.creeperhost.minetogether.lib.web.ApiRequest;
import net.creeperhost.minetogether.lib.web.ApiResponse;
import net.creeperhost.minetogether.lib.web.WebUtils;
import net.creeperhost.minetogether.orderform.data.Order;
import net.creeperhost.minetogether.util.ModPackInfo;
import org.jetbrains.annotations.Nullable;

public class PostCreateAccountRequest
extends ApiRequest<Response> {
    public PostCreateAccountRequest(Order order) {
        super("POST", "https://www.creeperhost.net/json/account/create", (Type)((Object)Response.class));
        this.requiredAuthHeaders.add("Fingerprint");
        this.requiredAuthHeaders.add("Identifier");
        ArrayList<WebUtils.UrlParamPair> entries = new ArrayList<WebUtils.UrlParamPair>();
        entries.add(WebUtils.UrlParamPair.of("servername", order.name));
        entries.add(WebUtils.UrlParamPair.of("modpack", ModPackInfo.getInfo().curseID));
        entries.add(WebUtils.UrlParamPair.of("email", order.emailAddress));
        entries.add(WebUtils.UrlParamPair.of("password", order.password));
        entries.add(WebUtils.UrlParamPair.of("fname", order.firstName));
        entries.add(WebUtils.UrlParamPair.of("lname", order.lastName));
        entries.add(WebUtils.UrlParamPair.of("addr1", order.address));
        entries.add(WebUtils.UrlParamPair.of("city", order.city));
        entries.add(WebUtils.UrlParamPair.of("tel", order.phone));
        entries.add(WebUtils.UrlParamPair.of("county", order.state));
        entries.add(WebUtils.UrlParamPair.of("state", order.state));
        entries.add(WebUtils.UrlParamPair.of("country", order.country));
        entries.add(WebUtils.UrlParamPair.of("pcode", order.zip));
        entries.add(WebUtils.UrlParamPair.of("currency", order.currency));
        this.formBody(entries);
    }

    public static class Response
    extends ApiResponse {
        public String currency;
        public String userid;

        public Response(@Nullable String status, @Nullable String message) {
            super(status, message);
        }
    }
}

