/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.chat.message;

import net.creeperhost.minetogether.lib.chat.message.MessageComponent;
import net.creeperhost.minetogether.lib.chat.profile.Profile;

public class ProfileMessageComponent
extends MessageComponent {
    public final Profile profile;
    private String displayName;

    public ProfileMessageComponent(Profile profile) {
        this.profile = profile;
        this.displayName = this.getUserName(profile);
        profile.addListener(this, ProfileMessageComponent::onProfileUpdate);
    }

    private void onProfileUpdate(Profile.ProfileEvent event) {
        if (!event.type.canChangeName()) {
            return;
        }
        assert (this.profile == event.profile) : "Profile update got a different profile???";
        String newName = this.getUserName(this.profile);
        if (!newName.equals(this.displayName)) {
            this.displayName = newName;
            this.fire(this);
        }
    }

    private String getUserName(Profile profile) {
        String name = profile.getDisplayName();
        if (profile.isFriend()) {
            name = profile.getFriendName();
        }
        return name;
    }

    @Override
    public String getMessage() {
        return this.displayName;
    }
}

