/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.chat.irc;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.creeperhost.minetogether.lib.chat.ChatState;
import net.creeperhost.minetogether.lib.chat.irc.IrcChannel;
import net.creeperhost.minetogether.lib.chat.message.Message;
import net.creeperhost.minetogether.lib.chat.message.MessageComponent;
import net.creeperhost.minetogether.lib.chat.message.MessageUtils;
import net.creeperhost.minetogether.lib.chat.message.ProfileMessageComponent;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractChannel
implements IrcChannel {
    public static final ExecutorService SEND_EXECUTOR = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("irc-send-queue").setDaemon(true).build());
    protected final ChatState chatState;
    protected final String name;
    private final List<IrcChannel.ChatListener> listeners = new LinkedList<IrcChannel.ChatListener>();
    private final List<Message> messages = new ArrayList<Message>();
    private final List<Message> messagesView = Collections.unmodifiableList(this.messages);

    protected AbstractChannel(ChatState chatState, String name) {
        this.chatState = chatState;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Message> getMessages() {
        return this.messagesView;
    }

    @Override
    public IrcChannel.ChatListener addListener(IrcChannel.ChatListener listener) {
        this.listeners.add(listener);
        return listener;
    }

    @Override
    public void removeListener(IrcChannel.ChatListener listener) {
        this.listeners.remove(listener);
    }

    public void addMessage(Instant timestamp, Profile sender, String message) {
        this.addMessage(new Message(timestamp, sender, MessageComponent.of(sender), MessageUtils.parseMessage(this.chatState.profileManager, message)));
    }

    public void addNoticeMessage(Instant timestamp, String message) {
        Pair<MessageComponent, MessageComponent> pair = MessageUtils.parseSystemMessage(this.chatState.profileManager, message);
        MessageComponent sender = (MessageComponent)pair.getLeft();
        this.addMessage(new Message(timestamp, sender instanceof ProfileMessageComponent ? ((ProfileMessageComponent)sender).profile : null, sender, (MessageComponent)pair.getRight()));
    }

    private void addMessage(Message message) {
        if (message.sender != null && message.sender.isMuted()) {
            return;
        }
        if (message.sender != null) {
            message.sender.addSentMessage(message);
        }
        this.messages.add(message);
        for (IrcChannel.ChatListener listener : this.listeners) {
            listener.newMessage(message);
        }
    }
}

