/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.gui;

import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.lib.ForegroundRender;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class ConsoleFeedbackElement
extends GuiElement<ConsoleFeedbackElement>
implements ForegroundRender {
    private final Map<Component, Long> DISPLAY_LIST = new IdentityHashMap<Component, Long>();
    private final LinkedList<Component> DISPLAY_ORDER = new LinkedList();
    private long displayTime = 5000L;
    private long fadeOutTime = 1000L;
    private int maxWidth = 256;
    private Position position = Position.BOTTOM_LEFT;

    public ConsoleFeedbackElement(@NotNull GuiParent<?> parent) {
        super(parent);
    }

    public ConsoleFeedbackElement setDisplayTime(long displayTime) {
        this.displayTime = displayTime;
        return this;
    }

    public ConsoleFeedbackElement setFadeOutTime(long fadeOutTime) {
        this.fadeOutTime = fadeOutTime;
        return this;
    }

    public ConsoleFeedbackElement setPosition(Position position) {
        this.position = position;
        return this;
    }

    public ConsoleFeedbackElement setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsoleFeedbackElement addMessage(Component message) {
        Map<Component, Long> map = this.DISPLAY_LIST;
        synchronized (map) {
            this.DISPLAY_LIST.put(message, System.currentTimeMillis());
            this.DISPLAY_ORDER.addFirst(message);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick(double mouseX, double mouseY) {
        super.tick(mouseX, mouseY);
        Map<Component, Long> map = this.DISPLAY_LIST;
        synchronized (map) {
            this.DISPLAY_LIST.entrySet().removeIf(e -> System.currentTimeMillis() > (Long)e.getValue() + this.displayTime + this.fadeOutTime);
            this.DISPLAY_ORDER.removeIf(e -> !this.DISPLAY_LIST.containsKey(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderInFront(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        int inset = 5;
        int bgColour = 0;
        Map<Component, Long> map = this.DISPLAY_LIST;
        synchronized (map) {
            int yOffset = 0;
            for (Component message : this.DISPLAY_ORDER) {
                long time = System.currentTimeMillis() - this.DISPLAY_LIST.get(message) - this.displayTime;
                double fadeOut = 1.0f - (this.fadeOutTime > 0L && time > 0L ? (float)time / (float)this.fadeOutTime : 0.0f);
                int colour = (int)(fadeOut * 255.0) << 24;
                int colour2 = (int)(fadeOut * 144.0) << 24;
                if (time >= this.fadeOutTime - 20L) continue;
                List lines = this.font().m_92923_((FormattedText)message, this.maxWidth);
                int n = lines.size();
                Objects.requireNonNull(this.font());
                yOffset += n * 9;
                int i = 0;
                if (this.position == Position.BOTTOM_LEFT || this.position == Position.BOTTOM_RIGHT) {
                    Objects.requireNonNull(this.font());
                    i += 9;
                } else {
                    Objects.requireNonNull(this.font());
                    i -= 9 * lines.size();
                }
                for (FormattedCharSequence line : lines) {
                    int lineWidth = this.font().m_92724_(line);
                    switch (this.position) {
                        case TOP_LEFT: {
                            double d = this.xMin() + (double)inset;
                            double d2 = this.yMin() + (double)inset + (double)yOffset + (double)i;
                            double d3 = lineWidth + 2;
                            Objects.requireNonNull(this.font());
                            render.rect(d, d2, d3, 9.0, colour2 | bgColour);
                            render.drawString(line, this.xMin() + (double)inset + 1.0, this.yMin() + (double)inset + (double)yOffset + (double)i, colour | 0xFFFFFF, false);
                            break;
                        }
                        case TOP_RIGHT: {
                            double d = this.xMax() - (double)lineWidth - (double)inset;
                            double d4 = this.yMin() + (double)inset + (double)yOffset + (double)i;
                            double d5 = lineWidth + 2;
                            Objects.requireNonNull(this.font());
                            render.rect(d, d4, d5, 9.0, colour2 | bgColour);
                            render.drawString(line, this.xMax() - (double)lineWidth - (double)inset + 1.0, this.yMin() + (double)inset + (double)yOffset + (double)i, colour | 0xFFFFFF, false);
                            break;
                        }
                        case BOTTOM_LEFT: {
                            double d = this.xMin() + (double)inset;
                            double d6 = this.yMax() - (double)inset - (double)yOffset;
                            Objects.requireNonNull(this.font());
                            double d7 = d6 - 9.0 + (double)i;
                            double d8 = lineWidth + 2;
                            Objects.requireNonNull(this.font());
                            render.rect(d, d7, d8, 9.0, colour2 | bgColour);
                            double d9 = this.xMin() + (double)inset + 1.0;
                            double d10 = this.yMax() - (double)inset - (double)yOffset;
                            Objects.requireNonNull(this.font());
                            render.drawString(line, d9, d10 - 9.0 + (double)i, colour | 0xFFFFFF, false);
                            break;
                        }
                        case BOTTOM_RIGHT: {
                            double d = this.xMax() - (double)lineWidth - (double)inset;
                            double d11 = this.yMax() - (double)inset - (double)yOffset;
                            Objects.requireNonNull(this.font());
                            double d12 = d11 - 9.0 + (double)i;
                            double d13 = lineWidth + 2;
                            Objects.requireNonNull(this.font());
                            render.rect(d, d12, d13, 9.0, colour2 | bgColour);
                            double d14 = this.xMax() - (double)lineWidth - (double)inset + 1.0;
                            double d15 = this.yMax() - (double)inset - (double)yOffset;
                            Objects.requireNonNull(this.font());
                            render.drawString(line, d14, d15 - 9.0 + (double)i, colour | 0xFFFFFF, false);
                        }
                    }
                    Objects.requireNonNull(this.font());
                    i += 9;
                }
            }
        }
    }

    public static enum Position {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

