/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect.lib.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import net.creeperhost.minetogether.connect.lib.netty.packet.CRaw;
import net.creeperhost.minetogether.connect.lib.netty.packet.Packet;
import net.creeperhost.minetogether.connect.lib.netty.packet.SRaw;
import net.creeperhost.minetogether.repack.net.covers1624.quack.util.SneakyUtils;
import org.apache.logging.log4j.Logger;

public class LoggingPacketCodec
extends MessageToMessageCodec<Packet<?>, Packet<?>> {
    private final Logger logger;
    private final boolean noRaw;

    public LoggingPacketCodec(Logger logger) {
        this.logger = logger;
        this.noRaw = false;
    }

    public LoggingPacketCodec(Logger logger, boolean noRaw) {
        this.logger = logger;
        this.noRaw = noRaw;
    }

    protected void encode(ChannelHandlerContext ctx, Packet<?> msg, List<Object> out) throws Exception {
        out.add(msg);
        try {
            this.logPacket(ctx.channel(), msg, false);
        }
        catch (Throwable ex) {
            this.logger.error("Failed to log packet: {}", (Object)msg.getClass().getName(), (Object)ex);
        }
    }

    protected void decode(ChannelHandlerContext ctx, Packet<?> msg, List<Object> out) throws Exception {
        out.add(msg);
        try {
            this.logPacket(ctx.channel(), msg, true);
        }
        catch (Throwable ex) {
            this.logger.error("Failed to log packet: {}", (Object)msg.getClass().getName(), (Object)ex);
        }
    }

    private void logPacket(Channel channel, Packet<?> packet, boolean inbound) {
        if (this.noRaw && (packet instanceof CRaw || packet instanceof SRaw)) {
            return;
        }
        Class pClass = (Class)SneakyUtils.unsafeCast(packet.getClass());
        StringBuilder sb = new StringBuilder(channel.remoteAddress().toString()).append("\n").append(inbound ? "RECV :> " : "SEND <: ").append(pClass.getSimpleName());
        for (Field field : pClass.getFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                sb.append("\n\t").append(field.getName()).append(" = ").append(field.get(packet));
            }
            catch (IllegalAccessException ex) {
                this.logger.warn("Failed to read field {}.{}", (Object)packet.getClass().getName(), (Object)field.getName(), (Object)ex);
            }
        }
        this.logger.info(sb.toString());
    }
}

