/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.creeperhost.minetogether.chat.MessageDropdownOption;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.gui.dialogs.ContextMenu;
import net.creeperhost.minetogether.gui.dialogs.TextInputDialog;
import net.creeperhost.minetogether.lib.chat.message.Message;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.minetogether.lib.chat.profile.ProfileManager;
import net.creeperhost.minetogether.util.MessageFormatter;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiList;
import net.creeperhost.polylib.client.modulargui.elements.GuiTextField;
import net.creeperhost.polylib.client.modulargui.lib.ForegroundRender;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class MessageElement
extends GuiElement<MessageElement>
implements ForegroundRender {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Message message;
    private final GuiTextField textField;
    private final boolean friendUI;
    private int lastWidth;
    private int height = 9;
    private int inset = 0;
    private final List<FormattedCharSequence> wrappedLines = new ArrayList<FormattedCharSequence>();

    public MessageElement(GuiList<?> parent, Message message, GuiTextField textField) {
        this(parent, message, textField, false);
    }

    public MessageElement(GuiList<?> parent, Message message, GuiTextField textField, boolean friendUI) {
        super(parent);
        this.message = message;
        this.lastWidth = (int)parent.xSize();
        this.textField = textField;
        this.friendUI = friendUI;
        message.addListener(this, (i, m) -> i.updateMessage(false));
        this.constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> this.height));
        this.updateMessage(true);
    }

    public Message getMessage() {
        return this.message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMessage(boolean init) {
        List<FormattedCharSequence> list = this.wrappedLines;
        synchronized (list) {
            this.wrappedLines.clear();
            Component formatted = MessageFormatter.formatMessage(this.message);
            if (formatted.getString().startsWith("\u00a7f<\u00a7bSystem\u00a7f>")) {
                this.inset = this.font().m_92895_("<System>");
            }
            if (this.lastWidth - this.inset < 20) {
                return;
            }
            this.wrappedLines.addAll(ComponentRenderUtils.m_94005_((FormattedText)formatted, (int)(this.lastWidth - this.inset), (Font)this.font()));
            int lines = Math.max(this.wrappedLines.size(), 1);
            Objects.requireNonNull(this.font());
            this.height = lines * 9 + (lines - 1);
            if (!init) {
                ((GuiList)this.getParent()).markDirty();
            }
        }
    }

    public void tick(double mouseX, double mouseY) {
        super.tick(mouseX, mouseY);
        if ((int)this.xSize() != this.lastWidth) {
            this.lastWidth = (int)this.xSize();
            this.updateMessage(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderInFront(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        List<FormattedCharSequence> list = this.wrappedLines;
        synchronized (list) {
            double y = this.yMin();
            for (FormattedCharSequence line : this.wrappedLines) {
                render.drawString(line, this.xMin() + (double)(y == this.yMin() ? 0 : this.inset), y, 0xFFFFFF);
                Objects.requireNonNull(this.font());
                y += (double)(9 + 1);
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseOver() || button != 0 && button != 1) {
            return false;
        }
        Style style = this.getStyleAtPos(mouseX, mouseY);
        if (style == null) {
            return false;
        }
        ClickEvent event = style.m_131182_();
        if (event == null) {
            return false;
        }
        if (!this.friendUI && "CE:CLICK_NAME".equals(event.m_130623_()) && this.message.sender != null && this.message.sender != MineTogetherChat.getOurProfile()) {
            ContextMenu menu = new ContextMenu((GuiParent<?>)this.getModularGui().getRoot());
            menu.addTitle((Component)Component.m_237113_((String)this.message.senderName.getMessage()).m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GOLD}));
            block5: for (MessageDropdownOption value : MessageDropdownOption.VALUES) {
                switch (value) {
                    case MUTE: {
                        menu.addOption((Component)value.getTitle(true).m_6881_().m_130940_(ChatFormatting.RED), this.message.sender::mute);
                        continue block5;
                    }
                    case ADD_FRIEND: {
                        menu.addOption((Component)value.getTitle(true).m_6881_().m_130940_(ChatFormatting.AQUA), () -> {
                            ProfileManager profileManager = MineTogetherChat.CHAT_STATE.profileManager;
                            new TextInputDialog((GuiParent<?>)this.getModularGui().getRoot(), (Component)Component.m_237115_((String)"minetogether:screen.friendreq.desc.request"), MessageElement.displayName(this.message.sender)).setResultCallback(friendName -> {
                                Profile target = this.message.sender;
                                if (!target.hasFriendCode()) {
                                    LOGGER.warn("User profile incomplete, unable to send friend request at this time.");
                                    MineTogetherChat.simpleToast((Component)Component.m_237113_((String)"Error, Profile Incomplete").m_130940_(ChatFormatting.RED));
                                    return;
                                }
                                profileManager.sendFriendRequest(target.getFriendCode(), friendName.trim(), success -> MineTogetherChat.simpleToast((Component)Component.m_237115_((String)(success != false ? "minetogether:gui.friends.request_sent" : "minetogether:gui.friends.request_fail"))));
                            });
                        });
                        continue block5;
                    }
                    case MENTION: {
                        menu.addOption((Component)value.getTitle(true).m_6881_().m_130940_(ChatFormatting.AQUA), () -> {
                            Object val = this.textField.getValue();
                            if (!((String)val).isEmpty() && ((String)val).charAt(((String)val).length() - 1) != ' ') {
                                val = (String)val + " ";
                            }
                            this.textField.setValue((String)val + this.message.sender.getDisplayName());
                        });
                    }
                }
            }
            menu.setPosition(mouseX, mouseY);
        } else {
            this.getModularGui().getScreen().m_5561_(style);
        }
        return false;
    }

    public boolean renderOverlay(GuiRender render, double mouseX, double mouseY, float partialTicks, boolean consumed) {
        if (consumed || super.renderOverlay(render, mouseX, mouseY, partialTicks, consumed)) {
            return true;
        }
        if (!this.isMouseOver()) {
            return false;
        }
        Style style = this.getStyleAtPos(mouseX, mouseY);
        if (style != null && style.m_131186_() != null) {
            render.renderComponentHoverEffect(style, (int)mouseX, (int)mouseY);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Style getStyleAtPos(double x, double y) {
        List<FormattedCharSequence> list = this.wrappedLines;
        synchronized (list) {
            x -= this.xMin();
            Objects.requireNonNull(this.font());
            int index = (int)((y -= this.yMin()) / (double)(9 + 1));
            if (index < 0 || index >= this.wrappedLines.size()) {
                return null;
            }
            FormattedCharSequence line = this.wrappedLines.get(index);
            return this.font().m_92865_().m_92338_(line, (int)Math.floor(x - (double)this.inset));
        }
    }

    public static String displayName(@Nullable Profile profile) {
        return profile == null ? "" : (profile.isFriend() && profile.hasFriendName() ? profile.getFriendName() : profile.getDisplayName());
    }
}

