/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat.gui;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.chat.gui.FriendChatGui;
import net.creeperhost.minetogether.chat.gui.MTStyle;
import net.creeperhost.minetogether.gui.MTTextures;
import net.creeperhost.minetogether.lib.chat.irc.IrcChannel;
import net.creeperhost.minetogether.lib.chat.irc.IrcClient;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.minetogether.lib.chat.profile.ProfileManager;
import net.creeperhost.minetogether.repack.net.covers1624.quack.collection.FastStream;
import net.creeperhost.polylib.client.modulargui.elements.GuiButton;
import net.creeperhost.polylib.client.modulargui.elements.GuiDialog;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiText;
import net.creeperhost.polylib.client.modulargui.elements.GuiTexture;
import net.creeperhost.polylib.client.modulargui.lib.BackgroundRender;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Align;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstrainedGeometry;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoRef;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class GroupChatElement
extends GuiElement<GroupChatElement>
implements BackgroundRender {
    public GroupChatElement(@NotNull GuiParent<?> parent) {
        super(parent);
        ProfileManager manager = MineTogetherChat.CHAT_STATE.profileManager;
        this.setEnabled(() -> manager.getPrivateGroup() != null);
        GuiButton select = new GuiButton((GuiParent)this).onClick(FriendChatGui::selectGroupChat);
        Constraints.bind((ConstrainedGeometry)select, (ConstrainedGeometry)this);
        GuiText name = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)this, (Component)Component.m_237119_()).setTextSupplier(this::getGroupName).setShadow(false).setAlignment(Align.LEFT).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.TOP), (double)1.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.LEFT), (double)3.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.RIGHT), (double)-20.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)9.0));
        GuiText players = (GuiText)((GuiText)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)this, (Component)Component.m_237119_()).setTextSupplier(this::getUserCount).setTooltip(this::getUserList)).setTooltipDelay(0)).setShadow(false).setAlignment(Align.LEFT).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.BOTTOM), (double)-2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.LEFT), (double)3.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.RIGHT), (double)-20.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)9.0));
        GuiButton leave = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(this, (Component)Component.m_237119_()).setTooltipSingle(this::getLeaveToolTip)).setTooltipDelay(0)).onPress(() -> {
            ProfileManager.PrivateGroup group = manager.getPrivateGroup();
            if (group == null) {
                return;
            }
            GuiDialog.optionsDialog((GuiParent)this.getModularGui().getRoot(), (Component)Component.m_237115_((String)(group.ownerHash == null ? "minetogether:gui.friends.group.confirm_leave_own" : "minetogether:gui.friends.group.confirm_leave")), (int)250, (GuiDialog.Option[])new GuiDialog.Option[]{GuiDialog.primary((Component)Component.m_237115_((String)"gui.yes"), () -> {
                manager.leaveGroup("leaving");
                FriendChatGui.setSelected(null);
            }), GuiDialog.neutral((Component)Component.m_237115_((String)"gui.cancel"), () -> {})});
        }).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.TOP), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.RIGHT), (double)-2.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)18.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)18.0));
        GuiTexture icon = new GuiTexture((GuiParent)leave, MTTextures.get("buttons/leave_group"));
        Constraints.bind((ConstrainedGeometry)icon, (ConstrainedGeometry)leave);
    }

    private Component getGroupName() {
        ProfileManager manager = MineTogetherChat.CHAT_STATE.profileManager;
        ProfileManager.PrivateGroup group = manager.getPrivateGroup();
        if (group == null) {
            return Component.m_237119_();
        }
        if (group.isOurGroup() || group.ownerHash == null) {
            return Component.m_237115_((String)"minetogether:gui.friends.group.own");
        }
        Profile profile = manager.lookupProfile(group.ownerHash);
        return Component.m_237110_((String)"minetogether:gui.friends.group.user", (Object[])new Object[]{FriendChatGui.displayName(profile)});
    }

    private Component getUserCount() {
        ProfileManager manager = MineTogetherChat.CHAT_STATE.profileManager;
        ProfileManager.PrivateGroup group = manager.getPrivateGroup();
        if (group == null) {
            return Component.m_237119_();
        }
        IrcClient client = MineTogetherChat.CHAT_STATE.ircClient;
        IrcChannel channel = client.getChannel(group.channelName);
        if (channel == null) {
            return Component.m_237119_();
        }
        int count = channel.getUsers().size();
        return Component.m_237110_((String)"minetogether:gui.friends.group.user_count", (Object[])new Object[]{count}).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.UNDERLINE});
    }

    private List<Component> getUserList() {
        ProfileManager manager = MineTogetherChat.CHAT_STATE.profileManager;
        ProfileManager.PrivateGroup group = manager.getPrivateGroup();
        if (group == null) {
            return Collections.emptyList();
        }
        IrcClient client = MineTogetherChat.CHAT_STATE.ircClient;
        IrcChannel channel = client.getChannel(group.channelName);
        if (channel == null) {
            return Collections.emptyList();
        }
        return FastStream.of(channel.getUsers()).sorted(Comparator.comparing(FriendChatGui::displayName)).map(profile -> {
            String name = FriendChatGui.displayName(profile);
            return Component.m_237113_((String)name).m_130940_(profile == manager.getOwnProfile() ? ChatFormatting.GRAY : ChatFormatting.YELLOW);
        }).toList();
    }

    private Component getLeaveToolTip() {
        ProfileManager manager = MineTogetherChat.CHAT_STATE.profileManager;
        ProfileManager.PrivateGroup group = manager.getPrivateGroup();
        if (group == null) {
            return Component.m_237119_();
        }
        return group.ownerHash == null ? Component.m_237115_((String)"minetogether:gui.friends.button.disband_group") : Component.m_237115_((String)"minetogether:gui.friends.button.leave_group");
    }

    public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        render.rect(this.getRectangle(), MTStyle.Flat.listEntryBackground(this.isMouseOver() || FriendChatGui.groupChat));
    }
}

